/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry.search;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intellij.docker.registry.search.DockerSearchContext;
import com.intellij.docker.registry.search.UrisKt;
import com.intellij.util.Base64;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000eR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/registry/search/DockerOauthHelper;", "", "basicAuthBytes", "", "context", "Lcom/intellij/docker/registry/search/DockerSearchContext;", "([BLcom/intellij/docker/registry/search/DockerSearchContext;)V", "basicAuth", "", "obtainTokenLater", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/registry/search/DockerOauthHelper$OauthToken;", "repository", "service", "obtainTokenLater$intellij_clouds_docker", "OauthToken", "intellij.clouds.docker"})
public final class DockerOauthHelper {
    private final String basicAuth;
    private final DockerSearchContext context;

    @NotNull
    public final CompletableFuture<OauthToken> obtainTokenLater$intellij_clouds_docker(@NotNull String repository, @NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        String repoFQN = StringsKt.contains$default((CharSequence)repository, (CharSequence)"/", (boolean)false, (int)2, null) ? repository : "library/" + repository;
        URI url = UrisKt.addQueryParameter(UrisKt.addQueryParameter(new URI("https://auth.docker.io/token"), "scope", "repository:" + repoFQN + ":pull"), "service", service);
        HttpRequest.Builder builder = HttpRequest.newBuilder(url);
        boolean bl = false;
        boolean bl2 = false;
        HttpRequest.Builder it = builder;
        boolean bl3 = false;
        HttpRequest.Builder request = this.basicAuth != null ? it.header("Authorization", "Basic " + this.basicAuth) : it;
        HttpRequest httpRequest = request.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"request.build()");
        return this.context.executeLater$intellij_clouds_docker(httpRequest, (Function1)new Function1<HttpResponse<String>, OauthToken>(this){
            final /* synthetic */ DockerOauthHelper this$0;

            @NotNull
            public final OauthToken invoke(@NotNull HttpResponse<String> response) {
                Intrinsics.checkNotNullParameter(response, (String)"response");
                String body = response.body();
                DockerSearchContext dockerSearchContext = DockerOauthHelper.access$getContext$p(this.this$0);
                String string = body;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body");
                OauthToken oauthToken = (OauthToken)dockerSearchContext.parseJSON$intellij_clouds_docker(string, Reflection.getOrCreateKotlinClass(OauthToken.class));
                if (oauthToken == null) {
                    throw (Throwable)new NullPointerException("Can't parse token response: " + body);
                }
                return oauthToken;
            }
            {
                this.this$0 = dockerOauthHelper;
                super(1);
            }
        });
    }

    public static /* synthetic */ CompletableFuture obtainTokenLater$intellij_clouds_docker$default(DockerOauthHelper dockerOauthHelper, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "registry.docker.io";
        }
        return dockerOauthHelper.obtainTokenLater$intellij_clouds_docker(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public DockerOauthHelper(@Nullable byte[] basicAuthBytes, @NotNull DockerSearchContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        DockerOauthHelper dockerOauthHelper = this;
        if (basicAuthBytes != null) {
            void it;
            byte[] byArray = basicAuthBytes;
            boolean bl = false;
            boolean bl2 = false;
            byte[] byArray2 = byArray;
            DockerOauthHelper dockerOauthHelper2 = dockerOauthHelper;
            boolean bl3 = false;
            String string2 = Base64.encode((byte[])it);
            dockerOauthHelper = dockerOauthHelper2;
            string = string2;
        } else {
            string = null;
        }
        dockerOauthHelper.basicAuth = string;
    }

    public /* synthetic */ DockerOauthHelper(byte[] byArray, DockerSearchContext dockerSearchContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            byArray = null;
        }
        if ((n & 2) != 0) {
            dockerSearchContext = new DockerSearchContext(null, 1, null);
        }
        this(byArray, dockerSearchContext);
    }

    public DockerOauthHelper() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ DockerSearchContext access$getContext$p(DockerOauthHelper $this) {
        return $this.context;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001e\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/registry/search/DockerOauthHelper$OauthToken;", "", "()V", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "expiresIn", "", "getExpiresIn", "()I", "setExpiresIn", "(I)V", "issuedAt", "getIssuedAt", "setIssuedAt", "token", "getToken", "setToken", "intellij.clouds.docker"})
    public static final class OauthToken {
        @JsonProperty(value="token")
        @NotNull
        private String token = "";
        @JsonProperty(value="access_token")
        @NotNull
        private String accessToken = "";
        @JsonProperty(value="issued_at")
        @Nullable
        private String issuedAt;
        @JsonProperty(value="expires_in")
        private int expiresIn;

        @NotNull
        public final String getToken() {
            return this.token;
        }

        public final void setToken(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.token = string;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.accessToken = string;
        }

        @Nullable
        public final String getIssuedAt() {
            return this.issuedAt;
        }

        public final void setIssuedAt(@Nullable String string) {
            this.issuedAt = string;
        }

        public final int getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(int n) {
            this.expiresIn = n;
        }
    }
}

