/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.pull;

import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.DockerResponseItemTtyHandler;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Base64;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J&\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/pull/DockerRedirectToTerminal;", "Ljava/util/function/Consumer;", "Ljava/util/concurrent/BlockingQueue;", "", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "(Lcom/intellij/docker/agent/progress/TtySink;)V", "accept", "", "t", "onPullChannelAvailable", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "channel", "redirectToTerminalLater", "Ljava/util/concurrent/CompletableFuture;", "channelPromise", "Companion", "intellij.clouds.docker"})
public final class DockerRedirectToTerminal
implements Consumer<BlockingQueue<byte[]>> {
    private final TtySink ttySink;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void accept(@NotNull BlockingQueue<byte[]> t) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        this.onPullChannelAvailable(t);
    }

    @NotNull
    public final CompletableFuture<List<DockerResponseItem.AuxDetail>> redirectToTerminalLater(@NotNull CompletableFuture<BlockingQueue<byte[]>> channelPromise) {
        Intrinsics.checkNotNullParameter(channelPromise, (String)"channelPromise");
        CompletionStage completionStage = ((CompletableFuture)channelPromise.thenApplyAsync(new Function<BlockingQueue<byte[]>, List<? extends DockerResponseItem.AuxDetail>>(this){
            final /* synthetic */ DockerRedirectToTerminal this$0;

            public final List<DockerResponseItem.AuxDetail> apply(BlockingQueue<byte[]> channel) {
                BlockingQueue<byte[]> blockingQueue = channel;
                Intrinsics.checkNotNullExpressionValue(blockingQueue, (String)"channel");
                return DockerRedirectToTerminal.access$onPullChannelAvailable(this.this$0, blockingQueue);
            }
            {
                this.this$0 = dockerRedirectToTerminal;
            }
        }, (Executor)AppExecutorUtil.getAppExecutorService())).exceptionally(new Function<Throwable, List<? extends DockerResponseItem.AuxDetail>>(this){
            final /* synthetic */ DockerRedirectToTerminal this$0;

            public final List<DockerResponseItem.AuxDetail> apply(Throwable failure) {
                DockerRedirectToTerminal.Companion.getLOG().warn(failure);
                TtySink ttySink = DockerRedirectToTerminal.access$getTtySink$p(this.this$0);
                String string = DockerBundle.message("DockerPullToTerminal.error.operation.failed", failure.getMessage());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Do\u2026failed\", failure.message)");
                ttySink.ttyPrintln(string);
                return null;
            }
            {
                this.this$0 = dockerRedirectToTerminal;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"channelPromise\n      .th\u2026ge))\n        null\n      }");
        return completionStage;
    }

    private final List<DockerResponseItem.AuxDetail> onPullChannelAvailable(BlockingQueue<byte[]> channel) {
        boolean bl = false;
        List auxDetails = new ArrayList();
        DockerResponseItemTtyHandler handler = new DockerResponseItemTtyHandler(this.ttySink);
        LOG.trace("poll: about to start");
        while (true) {
            try {
                byte[] next = channel.poll(3L, TimeUnit.SECONDS);
                if (next == null) {
                    LOG.trace("poll: nothing polled for 3 seconds");
                    continue;
                }
                byte[] byArray = next;
                boolean bl2 = false;
                if (byArray.length == 0) {
                    LOG.trace("poll: closing signal received");
                    break;
                }
                DockerResponseItem.Impl nextItem = DockerResponseItem.Impl.Companion.fromByteArray(next);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("packet: " + Base64.encode((byte[])next));
                    LOG.trace("decode: " + nextItem);
                }
                handler.handleItem((DockerResponseItem)nextItem);
                if (nextItem.getAux() != null) {
                    DockerResponseItem.AuxDetail auxDetail;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    DockerResponseItem.AuxDetail it = auxDetail;
                    boolean bl5 = false;
                    auxDetails.add(it);
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }
        LOG.trace("poll: finished");
        return CollectionsKt.toList((Iterable)auxDetails);
    }

    public DockerRedirectToTerminal(@NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.ttySink = ttySink;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DockerRedirectToTerminal.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Docke\u2026ctToTerminal::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ List access$onPullChannelAvailable(DockerRedirectToTerminal $this, BlockingQueue channel) {
        return $this.onPullChannelAvailable(channel);
    }

    public static final /* synthetic */ TtySink access$getTtySink$p(DockerRedirectToTerminal $this) {
        return $this.ttySink;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/pull/DockerRedirectToTerminal$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.docker"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

