/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.debug.DeploymentStatusWaiter;
import com.intellij.docker.debug.DockerBeforeRunTask;
import com.intellij.docker.debug.DockerContainerWaiter;
import com.intellij.docker.debug.HealthyStatusWaiter;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteDebug.RemoteServerRequestAdapterFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import com.intellij.ui.GuiUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DockerBeforeRunTaskLauncherBase {
    private final ExecutionEnvironment myEnvironment;
    private final DockerBeforeRunTask myTask;
    private final DeployToServerRunConfiguration<?, ?> myDockerRunConfig;

    DockerBeforeRunTaskLauncherBase(@NotNull ExecutionEnvironment environment, @NotNull DockerBeforeRunTask task) {
        if (environment == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(0);
        }
        if (task == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(1);
        }
        this.myEnvironment = environment;
        this.myTask = task;
        this.myDockerRunConfig = this.myTask.getDockerRunConfig();
        assert (this.myDockerRunConfig != null);
        assert (DockerCloudType.getInstance() == this.myDockerRunConfig.getServerType()) : "Docker expected: " + this.myDockerRunConfig.getServerType();
    }

    public void startAsBeforeRunStep(@NotNull CompletableFuture<String> promise) throws RuntimeConfigurationException {
        if (promise == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(2);
        }
        this.myDockerRunConfig.checkConfiguration();
        RemoteServer<DockerCloudConfiguration> docker = DockerBeforeRunTaskLauncherBase.findDocker(this.myDockerRunConfig);
        if (docker == null) {
            throw new RuntimeConfigurationError(DockerBundle.message("DockerBeforeRunTaskLauncherBase.error.cant.find.docker", this.myDockerRunConfig.getServerName()));
        }
        this.validateBeforeRunTask();
        GuiUtils.invokeLaterIfNeeded(() -> this.startDeploymentAndWait(docker, promise), (ModalityState)ModalityState.defaultModalityState());
    }

    protected abstract void validateBeforeRunTask() throws RuntimeConfigurationException;

    protected abstract void adjustDeployment(@NotNull DockerDeploymentConfiguration var1) throws IOException;

    private void startDeploymentAndWait(@NotNull RemoteServer<DockerCloudConfiguration> docker, @NotNull CompletableFuture<String> promise) {
        if (docker == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(3);
        }
        if (promise == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(4);
        }
        this.rebindRequest();
        DockerDeploymentConfiguration adjustedDeployment = new DockerDeploymentConfiguration();
        XmlSerializerUtil.copyBean((Object)this.myDockerRunConfig.getDeploymentConfiguration(), (Object)((Object)adjustedDeployment));
        try {
            this.adjustDeployment(adjustedDeployment);
        }
        catch (IOException e) {
            promise.completeExceptionally(e);
            return;
        }
        DeploymentTaskImpl deploymentTask = new DeploymentTaskImpl(this.myDockerRunConfig.getDeploymentSource(), (DeploymentConfiguration)adjustedDeployment, this.getProject(), null, this.myEnvironment);
        ServerConnection connection = ServerConnectionManager.getInstance().getOrCreateConnection(docker);
        RemoteServersView.getInstance((Project)this.getProject()).showServerConnection(connection);
        connection.deploy((DeploymentTask)deploymentTask, deploymentName -> {
            RemoteServersView.getInstance((Project)this.getProject()).showDeployment(connection, deploymentName);
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.waitUntilDeployed((ServerConnection<DockerDeploymentConfiguration>)connection, (String)deploymentName, promise));
        });
    }

    protected final void waitUntilDeployed(@NotNull ServerConnection<DockerDeploymentConfiguration> connection, @NotNull String deploymentName, @NotNull CompletableFuture<String> promise) {
        if (connection == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(5);
        }
        if (deploymentName == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(6);
        }
        if (promise == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(7);
        }
        Condition<Deployment> deploymentMatcher = this.getDeploymentMatcher(deploymentName);
        DockerContainerWaiter waiter = this.myTask.isWaitForHealthCheck() ? new HealthyStatusWaiter(connection, deploymentMatcher) : new DeploymentStatusWaiter(connection, deploymentMatcher);
        Boolean started = waiter.waitForContainer(3L, TimeUnit.MINUTES);
        promise.complete(String.valueOf(started));
    }

    @NotNull
    protected Condition<Deployment> getDeploymentMatcher(@NotNull String deploymentName) {
        if (deploymentName == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(8);
        }
        Condition condition = d -> deploymentName.equals(d.getName());
        if (condition == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(9);
        }
        return condition;
    }

    @Nullable
    private static RemoteServer<DockerCloudConfiguration> findDocker(@NotNull DeployToServerRunConfiguration<?, ?> dockerRunConfig) {
        if (dockerRunConfig == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(10);
        }
        if (dockerRunConfig.getServerName() == null) {
            return null;
        }
        return RemoteServersManager.getInstance().findByName(dockerRunConfig.getServerName(), (ServerType)DockerCloudType.getInstance());
    }

    @NotNull
    protected RunConfiguration getHostDebugRunConfiguration() {
        RunConfiguration runConfiguration = this.myEnvironment.getRunnerAndConfigurationSettings().getConfiguration();
        if (runConfiguration == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(11);
        }
        return runConfiguration;
    }

    private void rebindRequest() {
        RunConfiguration hostRunConfig = this.getHostDebugRunConfiguration();
        RemoteServerRequestAdapterFactory factory = RemoteServerRequestAdapterFactory.findAdapterFactory(hostRunConfig);
        if (factory != null) {
            factory.bind(this.myTask.getRequest(), hostRunConfig);
        }
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myEnvironment.getProject();
        if (project == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(12);
        }
        return project;
    }

    @NotNull
    protected final DockerBeforeRunTask getBeforeRunTask() {
        DockerBeforeRunTask dockerBeforeRunTask = this.myTask;
        if (dockerBeforeRunTask == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(13);
        }
        return dockerBeforeRunTask;
    }

    @NotNull
    protected final DeployToServerRunConfiguration<?, ?> getDockerRunConfig() {
        DeployToServerRunConfiguration<?, ?> deployToServerRunConfiguration = this.myDockerRunConfig;
        if (deployToServerRunConfiguration == null) {
            DockerBeforeRunTaskLauncherBase.$$$reportNull$$$0(14);
        }
        return deployToServerRunConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentName";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/debug/DockerBeforeRunTaskLauncherBase";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRunConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunTaskLauncherBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentMatcher";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostDebugRunConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTask";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerRunConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startAsBeforeRunStep";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startDeploymentAndWait";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "waitUntilDeployed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentMatcher";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDocker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

