/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRunLineMarkerProviderBase
implements LineMarkerProvider {
    protected static List<RemoteServer<DockerCloudConfiguration>> listAllDockerAccounts() {
        return RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
    }

    @Nls
    public static String getGenericTooltip() {
        return DockerBundle.message("DockerRunLineMarkerProviderBase.tooltip", new Object[0]);
    }

    @Nullable
    protected static ActionGroup combineActions(@NotNull List<? extends AnAction> existingRunConfigsActions, @NotNull List<? extends AnAction> newRunConfigActions) {
        if (existingRunConfigsActions == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(0);
        }
        if (newRunConfigActions == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(1);
        }
        if (existingRunConfigsActions.isEmpty() && newRunConfigActions.isEmpty()) {
            return null;
        }
        DefaultActionGroup result = new DefaultActionGroup();
        for (AnAction anAction : existingRunConfigsActions) {
            result.addAction(anAction);
        }
        if (!existingRunConfigsActions.isEmpty() && !newRunConfigActions.isEmpty()) {
            result.addAction((AnAction)new Separator());
        }
        for (AnAction anAction : newRunConfigActions) {
            result.addAction(anAction);
        }
        return result;
    }

    protected static List<RemoteServer<DockerCloudConfiguration>> allServersExceptKnowns(@NotNull List<? extends DockerRunConfig> runConfigs) {
        if (runConfigs == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(2);
        }
        Set<String> knownServerNames = DockerRunLineMarkerProviderBase.distinctServerNames(runConfigs);
        return ContainerUtil.filter(DockerRunLineMarkerProviderBase.listAllDockerAccounts(), nextDocker -> !knownServerNames.contains(nextDocker.getName()));
    }

    private static Set<String> distinctServerNames(@NotNull Collection<? extends DockerRunConfig> runConfigs) {
        if (runConfigs == null) {
            DockerRunLineMarkerProviderBase.$$$reportNull$$$0(3);
        }
        return runConfigs.stream().map(dockerRC -> dockerRC.getConfig().getServerName()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingRunConfigsActions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRunConfigActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "combineActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "allServersExceptKnowns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "distinctServerNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Deprecated
    public static final class DockerRunConfig
    extends com.intellij.docker.deployment.DockerRunConfig {
        private final RunnerAndConfigurationSettings mySettings;

        @Nullable
        public static DockerRunConfig wrapIfDocker(@NotNull RunnerAndConfigurationSettings settings) {
            if (settings == null) {
                DockerRunConfig.$$$reportNull$$$0(0);
            }
            return (DockerRunConfig)DockerRunConfig.wrapImpl(settings, (runConfig, deployment, sourceType) -> new DockerRunConfig(settings, (DeployToServerRunConfiguration<?, ?>)runConfig, (DockerDeploymentConfiguration)((Object)deployment), (DockerSingletonDeploymentSourceType)((Object)sourceType)));
        }

        @NotNull
        public static List<DockerRunConfig> dockerConfigs(@NotNull Project project, @NotNull VirtualFile vFile, @NotNull DeploymentSourceType<?> expectedType) {
            if (project == null) {
                DockerRunConfig.$$$reportNull$$$0(1);
            }
            if (vFile == null) {
                DockerRunConfig.$$$reportNull$$$0(2);
            }
            if (expectedType == null) {
                DockerRunConfig.$$$reportNull$$$0(3);
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            List<DockerRunConfig> list = runManager.getAllSettings().stream().map(DockerRunConfig::wrapIfDocker).filter(Objects::nonNull).filter(wrapper -> wrapper.hasDeploymentSourceOfType(expectedType)).filter(wrapper -> wrapper.isForVirtualFile(vFile)).collect(Collectors.toList());
            if (list == null) {
                DockerRunConfig.$$$reportNull$$$0(4);
            }
            return list;
        }

        private DockerRunConfig(@NotNull RunnerAndConfigurationSettings settings, @NotNull DeployToServerRunConfiguration<?, ?> runConfiguration, @NotNull DockerDeploymentConfiguration deployment, @NotNull DockerSingletonDeploymentSourceType sourceType) {
            if (settings == null) {
                DockerRunConfig.$$$reportNull$$$0(5);
            }
            if (runConfiguration == null) {
                DockerRunConfig.$$$reportNull$$$0(6);
            }
            if (deployment == null) {
                DockerRunConfig.$$$reportNull$$$0(7);
            }
            if (sourceType == null) {
                DockerRunConfig.$$$reportNull$$$0(8);
            }
            super(runConfiguration, deployment, sourceType);
            this.mySettings = settings;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                DockerRunConfig.$$$reportNull$$$0(9);
            }
            return runnerAndConfigurationSettings;
        }

        @NotNull
        public DeployToServerRunConfiguration<DockerCloudConfiguration, DockerDeploymentConfiguration> getConfig() {
            DeployToServerRunConfiguration<DockerCloudConfiguration, DockerDeploymentConfiguration> deployToServerRunConfiguration = this.getRunConfigurationImpl();
            if (deployToServerRunConfiguration == null) {
                DockerRunConfig.$$$reportNull$$$0(10);
            }
            return deployToServerRunConfiguration;
        }

        public DockerDeploymentConfiguration getDeploymentConfiguration() {
            return (DockerDeploymentConfiguration)this.getConfig().getDeploymentConfiguration();
        }

        public void setBuildOnly(boolean buildOnly) {
            ((DockerDeploymentConfiguration)this.getConfig().getDeploymentConfiguration()).setBuildOnly(buildOnly);
        }

        public boolean hasDeploymentSourceOfType(@NotNull DeploymentSourceType<?> expectedType) {
            if (expectedType == null) {
                DockerRunConfig.$$$reportNull$$$0(11);
            }
            return expectedType.equals((Object)this.getSourceType());
        }

        public boolean isForVirtualFile(@Nullable VirtualFile file2) {
            return file2 != null && DockerDeploymentConfiguration.ProjectAwareHelper.isForSameFile(this.getRunConfiguration().getProject(), this.getDeployment(), file2);
        }

        @NotNull
        public String getRunConfigName() {
            String string = this.mySettings.getName();
            if (string == null) {
                DockerRunConfig.$$$reportNull$$$0(12);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vFile";
                    break;
                }
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedType";
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/DockerRunLineMarkerProviderBase$DockerRunConfig";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfiguration";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployment";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase$DockerRunConfig";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dockerConfigs";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfig";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunConfigName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapIfDocker";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "dockerConfigs";
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 12: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "hasDeploymentSourceOfType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class FireAsTemporaryRunConfigAction
    extends RunConfigActionBase {
        @NotNull
        private final VirtualFile mySourceFile;
        @NotNull
        private final RemoteServer<DockerCloudConfiguration> myDocker;
        @NotNull
        private final DockerSingletonDeploymentSourceType mySourceType;

        public FireAsTemporaryRunConfigAction(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile, @NotNull DockerSingletonDeploymentSourceType sourceType, @NotNull RemoteServer<DockerCloudConfiguration> docker) {
            if (helper == null) {
                FireAsTemporaryRunConfigAction.$$$reportNull$$$0(0);
            }
            if (sourceFile == null) {
                FireAsTemporaryRunConfigAction.$$$reportNull$$$0(1);
            }
            if (sourceType == null) {
                FireAsTemporaryRunConfigAction.$$$reportNull$$$0(2);
            }
            if (docker == null) {
                FireAsTemporaryRunConfigAction.$$$reportNull$$$0(3);
            }
            super(helper);
            this.mySourceFile = sourceFile;
            this.mySourceType = sourceType;
            this.myDocker = docker;
            this.getTemplatePresentation().setText(DockerBundle.messagePointer("DockerRunLineMarkerProviderBase.RunAsTemporaryRunConfig.text", docker.getName()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FireAsTemporaryRunConfigAction.$$$reportNull$$$0(4);
            }
            RunnerAndConfigurationSettings runConfig = this.getHelper().createConfiguration(this.mySourceType, this.mySourceFile, this.myDocker);
            DockerRunConfig dockerRunConfig = DockerRunConfig.wrapIfDocker(runConfig);
            assert (dockerRunConfig != null);
            this.customize(dockerRunConfig);
            this.remember(dockerRunConfig);
            this.getHelper().executeConfiguration(runConfig);
        }

        protected void customize(DockerRunConfig runConfig) {
        }

        protected void remember(DockerRunConfig runConfig) {
            this.getHelper().rememberConfiguration(runConfig.getSettings());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docker";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase$FireAsTemporaryRunConfigAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ConfigureNewRunConfig
    extends RunConfigActionBase {
        private final VirtualFile mySourceFile;
        private final RemoteServer myDocker;
        private final DockerSingletonDeploymentSourceType mySourceType;

        public ConfigureNewRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile, @NotNull DockerSingletonDeploymentSourceType sourceType, @Nullable RemoteServer<?> docker) {
            if (helper == null) {
                ConfigureNewRunConfig.$$$reportNull$$$0(0);
            }
            if (sourceFile == null) {
                ConfigureNewRunConfig.$$$reportNull$$$0(1);
            }
            if (sourceType == null) {
                ConfigureNewRunConfig.$$$reportNull$$$0(2);
            }
            super(helper);
            this.mySourceFile = sourceFile;
            this.mySourceType = sourceType;
            this.myDocker = docker;
            this.getTemplatePresentation().setText(DockerBundle.messagePointer("DockerRunLineMarkerProviderBase.ConfigureNewRunConfig.text", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConfigureNewRunConfig.$$$reportNull$$$0(3);
            }
            RunnerAndConfigurationSettings runConfig = this.getHelper().createConfiguration(this.mySourceType, this.mySourceFile, this.myDocker);
            this.customizeRunConfig(runConfig);
            this.getHelper().rememberConfiguration(runConfig);
            this.getHelper().openForEditingAndExecute(runConfig, DockerBundle.message("DockerRunLineMarkerProviderBase.ConfigureNewRunConfig.dialogTitle", new Object[0]));
        }

        protected void customizeRunConfig(@NotNull RunnerAndConfigurationSettings runConfig) {
            if (runConfig == null) {
                ConfigureNewRunConfig.$$$reportNull$$$0(4);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfig";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase$ConfigureNewRunConfig";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeRunConfig";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class EditExistingRunConfig
    extends RunConfigActionBase {
        private final RunnerAndConfigurationSettings myRunConfig;

        public EditExistingRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull DockerRunConfig wrapper) {
            if (helper == null) {
                EditExistingRunConfig.$$$reportNull$$$0(0);
            }
            if (wrapper == null) {
                EditExistingRunConfig.$$$reportNull$$$0(1);
            }
            this(helper, wrapper.getSettings());
        }

        public EditExistingRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull RunnerAndConfigurationSettings runConfig) {
            if (helper == null) {
                EditExistingRunConfig.$$$reportNull$$$0(2);
            }
            if (runConfig == null) {
                EditExistingRunConfig.$$$reportNull$$$0(3);
            }
            super(helper);
            this.myRunConfig = runConfig;
            this.getTemplatePresentation().setText(DockerBundle.messagePointer("DockerRunLineMarkerProviderBase.EditExistingRunConfig.text", this.myRunConfig.getName()));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditExistingRunConfig.$$$reportNull$$$0(4);
            }
            this.getHelper().openForEditingAndExecute(this.myRunConfig, DockerBundle.message("DockerRunLineMarkerProviderBase.EditExistingRunConfig.dialogTitle", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfig";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase$EditExistingRunConfig";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class RunExistingRunConfig
    extends RunConfigActionBase {
        @NotNull
        private final DockerRunConfig myWrapper;

        public RunExistingRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull DockerRunConfig wrapper) {
            if (helper == null) {
                RunExistingRunConfig.$$$reportNull$$$0(0);
            }
            if (wrapper == null) {
                RunExistingRunConfig.$$$reportNull$$$0(1);
            }
            super(helper);
            this.myWrapper = wrapper;
            this.getTemplatePresentation().setText(DockerBundle.messagePointer("DockerRunLineMarkerProviderBase.RunExistingRunConfig.text", this.myWrapper.getRunConfigName()));
            this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.TestState.Run);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RunExistingRunConfig.$$$reportNull$$$0(2);
            }
            this.myWrapper.setBuildOnly(false);
            this.getHelper().executeConfiguration(this.myWrapper.getSettings());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase$RunExistingRunConfig";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class RunConfigLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        public RunConfigLineMarkerInfo(@NotNull PsiElement psi, @NotNull Icon icon) {
            if (psi == null) {
                RunConfigLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                RunConfigLineMarkerInfo.$$$reportNull$$$0(1);
            }
            super(psi, psi.getTextRange(), icon, whatever -> DockerRunLineMarkerProviderBase.getGenericTooltip(), null, GutterIconRenderer.Alignment.CENTER);
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                @Nullable
                public ActionGroup getPopupMenuActions() {
                    PsiElement psi = this.getElement();
                    if (psi == null) {
                        return null;
                    }
                    VirtualFile vFile = Optional.ofNullable(psi.getContainingFile()).map(PsiFile::getVirtualFile).orElse(null);
                    return vFile == null ? null : this.computeGutterPopup(new DockerRunConfigurationCreator(psi.getProject()), vFile);
                }
            };
        }

        protected abstract ActionGroup computeGutterPopup(@NotNull DockerRunConfigurationCreator var1, @NotNull VirtualFile var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase$RunConfigLineMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class RunConfigActionBase
    extends AnAction {
        private final DockerRunConfigurationCreator myHelper;

        protected RunConfigActionBase(@NotNull DockerRunConfigurationCreator helper) {
            if (helper == null) {
                RunConfigActionBase.$$$reportNull$$$0(0);
            }
            this.myHelper = helper;
        }

        @NotNull
        protected DockerRunConfigurationCreator getHelper() {
            DockerRunConfigurationCreator dockerRunConfigurationCreator = this.myHelper;
            if (dockerRunConfigurationCreator == null) {
                RunConfigActionBase.$$$reportNull$$$0(1);
            }
            return dockerRunConfigurationCreator;
        }

        @NotNull
        protected Project getProject() {
            Project project = this.myHelper.getProject();
            if (project == null) {
                RunConfigActionBase.$$$reportNull$$$0(2);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/DockerRunLineMarkerProviderBase$RunConfigActionBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/DockerRunLineMarkerProviderBase$RunConfigActionBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

