/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerDeploymentConfiguration
extends DeploymentConfigurationBase<DockerDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerDeploymentConfiguration.class);
    private String mySourceFilePath;
    private String myContextFolderPath;
    private boolean myBuildOnly;
    private String myAllImageTagsJoined;
    private String[] myImageTags = ArrayUtil.EMPTY_STRING_ARRAY;
    private String myContainerName;
    private Integer myDebugPort;
    private String myEntrypoint;
    private String myCommand;
    private List<DockerPortBindingImpl> myPortBindings = new ArrayList<DockerPortBindingImpl>();
    private boolean myPublishAllPorts;
    private List<DockerLinkImpl> myLinks = new ArrayList<DockerLinkImpl>();
    private List<DockerVolumeBindingImpl> myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
    private List<DockerEnvVarImpl> myEnvVars = new ArrayList<DockerEnvVarImpl>();
    private List<DockerEnvVarImpl> myBuildArgs = new ArrayList<DockerEnvVarImpl>();
    private String myRunCliOptions;
    private String myBuildCliOptions;
    private boolean myLinksExpanded = false;
    private boolean myVolumeBindingsExpanded = false;
    private boolean myEnvVarsExpanded = false;
    private boolean myPortBindingsExpanded = false;
    private List<String> mySecondarySourceFiles = new ArrayList<String>();
    private List<String> myServices = new ArrayList<String>();
    private List<String> myImagesToPullBeforeRun = new ArrayList<String>();
    private boolean myRemoveVolumesOnComposeDown;

    @OptionTag(value="imageTag")
    public String getAllImageTagsJoined() {
        return this.myAllImageTagsJoined;
    }

    public void setAllImageTagsJoined(String allTagsJoined) {
        this.myAllImageTagsJoined = StringUtil.trim((String)allTagsJoined);
        this.myImageTags = DockerDeploymentConfiguration.splitTags(this.myAllImageTagsJoined);
    }

    private static String @NotNull [] splitTags(@Nullable String allTagsJoined) {
        Object[] result;
        if (StringUtil.isEmptyOrSpaces((String)allTagsJoined)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                DockerDeploymentConfiguration.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        for (String string : result = allTagsJoined.split("(\\s|,)+")) {
            if (!StringUtil.isEmptyOrSpaces((String)string)) continue;
            String[] stringArray = ArrayUtil.toStringArray((Collection)ContainerUtil.filter((Object[])result, text -> !StringUtil.isEmptyOrSpaces((String)text)));
            if (stringArray == null) {
                DockerDeploymentConfiguration.$$$reportNull$$$0(1);
            }
            return stringArray;
        }
        if (result == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(2);
        }
        return result;
    }

    @Transient
    public String @NotNull [] getSeparateImageTags() {
        if (this.myImageTags == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(3);
        }
        return this.myImageTags;
    }

    @Transient
    public void setTheOnlyImageTag(@NotNull String imageTag) {
        if (imageTag == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(4);
        }
        this.setAllImageTagsJoined(imageTag);
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public void setContainerName(String containerName) {
        this.myContainerName = StringUtil.trim((String)containerName);
    }

    public String getSourceFilePath() {
        return this.mySourceFilePath;
    }

    public void setSourceFilePath(String path) {
        this.mySourceFilePath = path;
    }

    @OptionTag(value="commandLineOptions")
    public String getRunCliOptions() {
        return this.myRunCliOptions;
    }

    public void setRunCliOptions(String runCliOptions) {
        this.myRunCliOptions = runCliOptions;
    }

    public String getBuildCliOptions() {
        return this.myBuildCliOptions;
    }

    public void setBuildCliOptions(String buildCliOptions) {
        this.myBuildCliOptions = buildCliOptions;
    }

    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setDebugPort(Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    public String getContextFolderPath() {
        return this.myContextFolderPath;
    }

    public void setContextFolderPath(String path) {
        this.myContextFolderPath = path;
    }

    public boolean isRemoveVolumesOnComposeDown() {
        return this.myRemoveVolumesOnComposeDown;
    }

    public void setRemoveVolumesOnComposeDown(boolean remove) {
        this.myRemoveVolumesOnComposeDown = remove;
    }

    public void checkConfiguration(RemoteServer<?> server, DeploymentSource deploymentSource, Project project) throws RuntimeConfigurationException {
        assert (deploymentSource != null);
        assert (project != null);
        if (deploymentSource.getType() instanceof DockerSingletonDeploymentSourceType) {
            DockerSingletonDeploymentSourceType typeImpl = (DockerSingletonDeploymentSourceType)deploymentSource.getType();
            typeImpl.checkDeploymentConfiguration(project, this);
        }
    }

    public String getEntrypoint() {
        return this.myEntrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.myEntrypoint = entrypoint;
    }

    public String getCommand() {
        return this.myCommand;
    }

    public void setCommand(String command) {
        this.myCommand = command;
    }

    @AbstractCollection
    public List<DockerPortBindingImpl> getPortBindings() {
        if (this.myPortBindings == null) {
            this.myPortBindings = new ArrayList<DockerPortBindingImpl>();
        }
        return this.myPortBindings;
    }

    public void setPortBindings(List<DockerPortBindingImpl> portBindings) {
        this.myPortBindings = DockerDeploymentConfiguration.defensiveCopy(portBindings);
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
    }

    public boolean isPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    @AbstractCollection
    public List<DockerLinkImpl> getLinks() {
        if (this.myLinks == null) {
            this.myLinks = new ArrayList<DockerLinkImpl>();
        }
        return this.myLinks;
    }

    public void setLinks(List<DockerLinkImpl> links) {
        this.myLinks = DockerDeploymentConfiguration.defensiveCopy(links);
    }

    @AbstractCollection
    public List<DockerVolumeBindingImpl> getVolumeBindings() {
        if (this.myVolumeBindings == null) {
            this.myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
        }
        return this.myVolumeBindings;
    }

    public void setVolumeBindings(List<DockerVolumeBindingImpl> volumeBindings) {
        this.myVolumeBindings = DockerDeploymentConfiguration.defensiveCopy(volumeBindings);
    }

    @AbstractCollection
    public List<DockerEnvVarImpl> getEnvVars() {
        if (this.myEnvVars == null) {
            this.myEnvVars = new ArrayList<DockerEnvVarImpl>();
        }
        return this.myEnvVars;
    }

    public void setEnvVars(List<DockerEnvVarImpl> envVars) {
        this.myEnvVars = DockerDeploymentConfiguration.defensiveCopy(envVars);
    }

    @AbstractCollection
    public List<DockerEnvVarImpl> getBuildArgs() {
        if (this.myBuildArgs == null) {
            this.myBuildArgs = new ArrayList<DockerEnvVarImpl>();
        }
        return this.myBuildArgs;
    }

    public void setBuildArgs(List<DockerEnvVarImpl> buildArgs) {
        this.myBuildArgs = DockerDeploymentConfiguration.defensiveCopy(buildArgs);
    }

    public boolean isLinksExpanded() {
        return this.myLinksExpanded;
    }

    public void setLinksExpanded(boolean linksExpanded) {
        this.myLinksExpanded = linksExpanded;
    }

    public boolean isVolumeBindingsExpanded() {
        return this.myVolumeBindingsExpanded;
    }

    public void setVolumeBindingsExpanded(boolean volumeBindingsExpanded) {
        this.myVolumeBindingsExpanded = volumeBindingsExpanded;
    }

    public boolean isEnvVarsExpanded() {
        return this.myEnvVarsExpanded;
    }

    public void setEnvVarsExpanded(boolean envVarsExpanded) {
        this.myEnvVarsExpanded = envVarsExpanded;
    }

    public boolean isPortBindingsExpanded() {
        return this.myPortBindingsExpanded;
    }

    public void setPortBindingsExpanded(boolean portBindingsExpanded) {
        this.myPortBindingsExpanded = portBindingsExpanded;
    }

    public boolean isBuildOnly() {
        return this.myBuildOnly;
    }

    public void setBuildOnly(boolean buildOnly) {
        this.myBuildOnly = buildOnly;
    }

    @AbstractCollection
    public List<String> getSecondarySourceFiles() {
        if (this.mySecondarySourceFiles == null) {
            this.mySecondarySourceFiles = new ArrayList<String>();
        }
        return this.mySecondarySourceFiles;
    }

    public void setSecondarySourceFiles(List<String> files) {
        this.mySecondarySourceFiles = DockerDeploymentConfiguration.defensiveCopy(files);
    }

    @AbstractCollection
    @NotNull
    public List<String> getServices() {
        if (this.myServices == null) {
            this.myServices = new ArrayList<String>();
        }
        List<String> list = this.myServices;
        if (list == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void setServices(List<String> services) {
        this.myServices = DockerDeploymentConfiguration.defensiveCopy(services);
    }

    @XCollection
    @NotNull
    public List<String> getImagesToPullBeforeRun() {
        List<String> list = this.myImagesToPullBeforeRun;
        if (list == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void setImagesToPullBeforeRun(@NotNull List<String> imagesToPull) {
        if (imagesToPull == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(7);
        }
        this.myImagesToPullBeforeRun = DockerDeploymentConfiguration.defensiveCopy(imagesToPull);
    }

    public void loadState(@NotNull DockerDeploymentConfiguration state) {
        if (state == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(8);
        }
        String mayBePresetPath = this.getSourceFilePath();
        super.loadState((DeploymentConfigurationBase)state);
        if (mayBePresetPath != null && this.getSourceFilePath() == null) {
            this.setSourceFilePath(mayBePresetPath);
        }
    }

    @NotNull
    private static <T> List<T> defensiveCopy(@Nullable List<T> list) {
        return list == null ? new ArrayList() : new ArrayList<T>(list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerDeploymentConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageTag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imagesToPull";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "splitTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparateImageTags";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerDeploymentConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImagesToPullBeforeRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTheOnlyImageTag";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setImagesToPullBeforeRun";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static class ProjectAwareHelper {
        public static void setSourceFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration model, @Nullable File sourceFile) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(0);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(1);
            }
            String path = sourceFile == null ? null : ProjectAwareHelper.getPathToStore(project, sourceFile);
            model.setSourceFilePath(path);
        }

        public static void setManySourceFiles(@NotNull Project project, @NotNull DockerDeploymentConfiguration model, @NotNull List<File> sourceFiles) {
            List<Object> secondaryFiles;
            File mainFile;
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(2);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(3);
            }
            if (sourceFiles == null) {
                ProjectAwareHelper.$$$reportNull$$$0(4);
            }
            if (sourceFiles.isEmpty()) {
                mainFile = null;
                secondaryFiles = Collections.emptyList();
            } else {
                mainFile = sourceFiles.get(0);
                secondaryFiles = sourceFiles.subList(1, sourceFiles.size());
            }
            ProjectAwareHelper.setSourceFile(project, model, mainFile);
            List storableSecondaries = ContainerUtil.map(secondaryFiles, file2 -> ProjectAwareHelper.getPathToStore(project, file2));
            model.setSecondarySourceFiles(storableSecondaries);
        }

        public static void setSourceFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration model, @Nullable VirtualFile sourceFile) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(5);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(6);
            }
            String path = sourceFile == null ? null : ProjectAwareHelper.getPathToStore(project, sourceFile);
            model.setSourceFilePath(path);
        }

        public static boolean isForSameFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration model, @NotNull VirtualFile file2) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(7);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(8);
            }
            if (file2 == null) {
                ProjectAwareHelper.$$$reportNull$$$0(9);
            }
            return FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (File)ProjectAwareHelper.getSourceFile(project, model));
        }

        @Nullable
        public static File getSourceFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration model) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(10);
            }
            if (model == null) {
                ProjectAwareHelper.$$$reportNull$$$0(11);
            }
            return ProjectAwareHelper.getSourceFile(project, model.getSourceFilePath());
        }

        @Nullable
        public static File getSourceFile(@NotNull Project project, @Nullable String path) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(12);
            }
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                return null;
            }
            File file2 = new File(path = FileUtil.toSystemDependentName((String)path));
            return file2.isAbsolute() ? file2 : new File(project.getBasePath(), file2.getPath());
        }

        @NotNull
        public static String getPathToStore(@NotNull Project project, @NotNull VirtualFile file2) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(13);
            }
            if (file2 == null) {
                ProjectAwareHelper.$$$reportNull$$$0(14);
            }
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
            return ProjectAwareHelper.getPathToStore(project, ioFile);
        }

        @NotNull
        public static String getPathToStore(@NotNull Project project, @NotNull File file2) {
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(15);
            }
            if (file2 == null) {
                ProjectAwareHelper.$$$reportNull$$$0(16);
            }
            String projectRelativePath = ProjectAwareHelper.makeProjectRelative(project, file2);
            String string = FileUtil.toSystemIndependentName((String)projectRelativePath);
            if (string == null) {
                ProjectAwareHelper.$$$reportNull$$$0(17);
            }
            return string;
        }

        @NotNull
        private static String makeProjectRelative(@NotNull Project project, @NotNull File ioFile) {
            String relativePath;
            String basePath;
            if (project == null) {
                ProjectAwareHelper.$$$reportNull$$$0(18);
            }
            if (ioFile == null) {
                ProjectAwareHelper.$$$reportNull$$$0(19);
            }
            if ((basePath = project.getBasePath()) != null && (relativePath = FileUtil.getRelativePath((File)new File(basePath), (File)ioFile)) != null) {
                String string = relativePath;
                if (string == null) {
                    ProjectAwareHelper.$$$reportNull$$$0(20);
                }
                return string;
            }
            String string = ioFile.getAbsolutePath();
            if (string == null) {
                ProjectAwareHelper.$$$reportNull$$$0(21);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 17: 
                case 20: 
                case 21: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 17: 
                case 20: 
                case 21: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFiles";
                    break;
                }
                case 9: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 17: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/DockerDeploymentConfiguration$ProjectAwareHelper";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ioFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/DockerDeploymentConfiguration$ProjectAwareHelper";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathToStore";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeProjectRelative";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setSourceFile";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setManySourceFiles";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isForSameFile";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getSourceFile";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getPathToStore";
                    break;
                }
                case 17: 
                case 20: 
                case 21: {
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "makeProjectRelative";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 17: 
                case 20: 
                case 21: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

