/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.contracts.Effect;
import kotlin.ranges.IntRange;
import org.apache.log4j.RollingFileAppender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.ILoggerFactory;

public class DockerConnector
extends ServerConnector<DockerDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerConnector.class);
    private static final String RUNTIME_FOLDER = "rt";
    private static final String FROM_SOURCES_LIBS_DEFAULT = "lib";
    private final DockerCloudConfiguration myConfiguration;
    private final ServerTaskExecutor myTasksExecutor;

    public DockerConnector(DockerCloudConfiguration configuration, ServerTaskExecutor tasksExecutor) {
        this.myConfiguration = configuration;
        this.myTasksExecutor = tasksExecutor;
    }

    public void connect(@NotNull ServerConnector.ConnectionCallback<DockerDeploymentConfiguration> callback) {
        if (callback == null) {
            DockerConnector.$$$reportNull$$$0(0);
        }
        this.myTasksExecutor.submit(() -> {
            List<File> clientLibrary = DockerConnector.loadBundledClientLibrary();
            new DockerServerRuntimeInstance(this.myConfiguration, this.myTasksExecutor, clientLibrary).connect(callback);
        }, callback);
    }

    @Nullable
    public static List<File> loadBundledClientLibrary() {
        File clientJar = new File(PathUtil.getJarPathForClass(DockerConnector.class));
        if (clientJar.isDirectory()) {
            Path mavenRootPath;
            String ultimateSourcesFolder = PathManager.getHomePath();
            Path docker = Paths.get(ultimateSourcesFolder, "plugins", "Docker");
            Path implRt = docker.resolve("Docker-agent-impl-rt");
            Path apiRt = docker.resolve("Docker-agent-api-rt");
            List<File> fromPlugin = DockerConnector.listBundledClientLibrary(apiRt.resolve(FROM_SOURCES_LIBS_DEFAULT), implRt.resolve(FROM_SOURCES_LIBS_DEFAULT));
            List<File> fromProjectLibraries = DockerConnector.projectLibraryJarsForClasses(RollingFileAppender.class, IntRange.class, Effect.class, JsonProperty.class, ILoggerFactory.class);
            String mavenRoot = DockerConnector.resolveMavenRepository();
            if (mavenRoot == null) {
                mavenRootPath = Paths.get(System.getProperty("user.home"), ".m2", "repository");
                File mavenRootFile = mavenRootPath.toFile();
                if (!mavenRootFile.exists() || !mavenRootFile.isDirectory()) {
                    throw new RuntimeException("To connect to Docker while running IDE from sources, please set up path macro `MAVEN_REPOSITORY` in the runtime IDE");
                }
            } else {
                mavenRootPath = Paths.get(mavenRoot, new String[0]);
            }
            String[] libraryPaths = new String[]{"com/github/docker-java/docker-java-api/3.2.6/docker-java-api-3.2.6.jar", "com/github/docker-java/docker-java-transport-okhttp/3.2.6/docker-java-transport-okhttp-3.2.6.jar", "com/github/docker-java/docker-java-core/3.2.6/docker-java-core-3.2.6.jar", "com/github/docker-java/docker-java-transport/3.2.6/docker-java-transport-3.2.6.jar", "commons-io/commons-io/2.6/commons-io-2.6.jar", "org/apache/commons/commons-compress/1.20/commons-compress-1.20.jar", "commons-lang/commons-lang/2.6/commons-lang-2.6.jar", "com/fasterxml/jackson/core/jackson-databind/2.10.3/jackson-databind-2.10.3.jar", "com/fasterxml/jackson/core/jackson-core/2.10.3/jackson-core-2.10.3.jar", "com/google/guava/guava/19.0/guava-19.0.jar", "org/bouncycastle/bcpkix-jdk15on/1.64/bcpkix-jdk15on-1.64.jar", "org/bouncycastle/bcprov-jdk15on/1.64/bcprov-jdk15on-1.64.jar", "com/squareup/okhttp3/okhttp/3.14.4/okhttp-3.14.4.jar", "com/squareup/okio/okio/1.17.2/okio-1.17.2.jar", "net/java/dev/jna/jna-platform/5.5.0/jna-platform-5.5.0.jar", "net/java/dev/jna/jna/5.5.0/jna-5.5.0.jar", "javax/activation/javax.activation-api/1.2.0/javax.activation-api-1.2.0.jar"};
            List fromMaven = Stream.of(libraryPaths).map(next -> mavenRootPath.resolve((String)next)).map(Path::toFile).collect(Collectors.toList());
            ArrayList<File> result = new ArrayList<File>();
            if (fromPlugin != null) {
                result.addAll(fromPlugin);
            }
            result.addAll(fromMaven);
            result.addAll(fromProjectLibraries);
            return result;
        }
        File runtimeFolder = new File(clientJar.getParentFile(), RUNTIME_FOLDER);
        return DockerConnector.listBundledClientLibrary(runtimeFolder);
    }

    @Nullable
    private static String resolveMavenRepository() {
        String MACRO = "$MAVEN_REPOSITORY$";
        String result = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath("$MAVEN_REPOSITORY$");
        return "$MAVEN_REPOSITORY$".equals(result) ? null : result;
    }

    @Nullable
    private static List<File> listBundledClientLibrary(Path ... clientFolderPaths) {
        if (clientFolderPaths == null) {
            DockerConnector.$$$reportNull$$$0(1);
        }
        return DockerConnector.listBundledClientLibrary((File[])Stream.of(clientFolderPaths).map(Path::toFile).toArray(File[]::new));
    }

    @Nullable
    private static List<File> listBundledClientLibrary(File ... clientFolders) {
        if (clientFolders == null) {
            DockerConnector.$$$reportNull$$$0(2);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File nextFolder : clientFolders) {
            File[] clientFiles = nextFolder.listFiles();
            if (clientFiles == null) {
                LOG.info("Unable to load bundled client library files from " + nextFolder);
                return null;
            }
            result.addAll(Arrays.asList(clientFiles));
            LOG.debug("Bundled client library loaded from " + nextFolder);
        }
        return result;
    }

    @NotNull
    private static List<File> projectLibraryJarsForClasses(Class<?> ... classes) {
        List<File> list = Arrays.stream(classes).map(PathUtil::getJarPathForClass).map(File::new).collect(Collectors.toList());
        if (list == null) {
            DockerConnector.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientFolderPaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientFolders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerConnector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerConnector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "projectLibraryJarsForClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "listBundledClientLibrary";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

