/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkPropertiesPaths;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDockerProcessConnectionData
implements RemoteSdkPropertiesPaths {
    @NotNull
    protected final RemoteSdkAdditionalData myCommonCredentials;

    public AbstractDockerProcessConnectionData(@NotNull RemoteSdkAdditionalData commonCredentials) {
        if (commonCredentials == null) {
            AbstractDockerProcessConnectionData.$$$reportNull$$$0(0);
        }
        this.myCommonCredentials = commonCredentials;
    }

    public String getInterpreterPath() {
        return this.myCommonCredentials.getInterpreterPath();
    }

    public String getSdkHomePath() {
        return this.myCommonCredentials.getSdkId();
    }

    public String getHelpersPath() {
        return this.myCommonCredentials.getHelpersPath();
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public DockerCloudConfiguration getAccount() throws RemoteSdkException {
        DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)this.getRemoteServer().getConfiguration();
        if (dockerCloudConfiguration == null) {
            AbstractDockerProcessConnectionData.$$$reportNull$$$0(1);
        }
        return dockerCloudConfiguration;
    }

    @NotNull
    public RemoteServer<DockerCloudConfiguration> getRemoteServer() throws RemoteSdkException {
        String accountName = this.getDockerAccountName();
        if (StringUtil.isEmpty((String)accountName)) {
            throw new RemoteSdkException(DockerBundle.message("AbstractDockerProcessConnectionData.docker.account.specified", new Object[0]));
        }
        RemoteServer result = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (result == null) {
            throw new RemoteSdkException(DockerBundle.message("AbstractDockerProcessConnectionData.docker.account.found", new Object[0]));
        }
        RemoteServer remoteServer = result;
        if (remoteServer == null) {
            AbstractDockerProcessConnectionData.$$$reportNull$$$0(2);
        }
        return remoteServer;
    }

    protected abstract String getDockerAccountName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCredentials";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/AbstractDockerProcessConnectionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/AbstractDockerProcessConnectionData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccount";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

