/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.handler.mxMovePreview;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxMouseAdapter;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TooManyListenersException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class mxGraphHandler
extends mxMouseAdapter
implements DropTargetListener {
    private static final long serialVersionUID = 3241109976696510225L;
    public static Cursor DEFAULT_CURSOR = new Cursor(0);
    public static Cursor MOVE_CURSOR = new Cursor(13);
    public static Cursor FOLD_CURSOR = new Cursor(12);
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected boolean cloneEnabled = true;
    protected boolean moveEnabled = true;
    protected boolean selectEnabled = true;
    protected boolean markerEnabled = true;
    protected boolean removeCellsFromParent = true;
    protected mxMovePreview movePreview;
    protected boolean livePreview = false;
    protected boolean imagePreview = true;
    protected boolean centerPreview = true;
    protected boolean keepOnTop = true;
    protected transient Object[] cells;
    protected transient ImageIcon dragImage;
    protected transient Point first;
    protected transient Object cell;
    protected transient Object initialCell;
    protected transient Object[] dragCells;
    protected transient mxCellMarker marker;
    protected transient boolean canImport;
    protected transient mxRectangle cellBounds;
    protected transient mxRectangle bbox;
    protected transient mxRectangle transferBounds;
    protected transient boolean visible = false;
    protected transient Rectangle previewBounds = null;
    protected transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;
    protected transient DropTarget currentDropTarget = null;

    public mxGraphHandler(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        this.marker = this.createMarker();
        this.movePreview = this.createMovePreview();
        graphComponent.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                mxGraphHandler.this.paint(g);
            }
        });
        graphComponent.getGraphControl().addMouseListener(this);
        graphComponent.getGraphControl().addMouseMotionListener(this);
        this.installDragGestureHandler();
        this.installDropTargetHandler();
        graphComponent.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("transferHandler")) {
                    if (mxGraphHandler.this.currentDropTarget != null) {
                        mxGraphHandler.this.currentDropTarget.removeDropTargetListener(mxGraphHandler.this);
                    }
                    mxGraphHandler.this.installDropTargetHandler();
                }
            }
        });
        this.setVisible(false);
    }

    protected void installDragGestureHandler() {
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent e) {
                mxGraphTransferable t;
                TransferHandler th;
                if (mxGraphHandler.this.graphComponent.isDragEnabled() && mxGraphHandler.this.first != null && (th = mxGraphHandler.this.graphComponent.getTransferHandler()) instanceof mxGraphTransferHandler && (t = (mxGraphTransferable)((mxGraphTransferHandler)th).createTransferable(mxGraphHandler.this.graphComponent)) != null) {
                    e.startDrag(null, mxSwingConstants.EMPTY_IMAGE, new Point(), t, new DragSourceAdapter(){

                        public void dragDropEnd(DragSourceDropEvent dsde) {
                            ((mxGraphTransferHandler)th).exportDone(mxGraphHandler.this.graphComponent, t, 0);
                            mxGraphHandler.this.first = null;
                        }
                    });
                }
            }
        };
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this.graphComponent.getGraphControl(), this.isCloneEnabled() ? 3 : 2, dragGestureListener);
    }

    protected void installDropTargetHandler() {
        DropTarget dropTarget = this.graphComponent.getDropTarget();
        try {
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(this);
                this.currentDropTarget = dropTarget;
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        if (this.visible != value) {
            this.visible = value;
            if (this.previewBounds != null) {
                this.graphComponent.getGraphControl().repaint(this.previewBounds);
            }
        }
    }

    public void setPreviewBounds(Rectangle bounds) {
        if (bounds == null && this.previewBounds != null || bounds != null && this.previewBounds == null || bounds != null && this.previewBounds != null && !bounds.equals(this.previewBounds)) {
            Rectangle dirty = null;
            if (this.isVisible()) {
                dirty = this.previewBounds;
                if (dirty != null) {
                    dirty.add(bounds);
                } else {
                    dirty = bounds;
                }
            }
            this.previewBounds = bounds;
            if (dirty != null) {
                this.graphComponent.getGraphControl().repaint(dirty.x - 1, dirty.y - 1, dirty.width + 2, dirty.height + 2);
            }
        }
    }

    protected mxMovePreview createMovePreview() {
        return new mxMovePreview(this.graphComponent);
    }

    public mxMovePreview getMovePreview() {
        return this.movePreview;
    }

    protected mxCellMarker createMarker() {
        mxCellMarker marker = new mxCellMarker(this.graphComponent, Color.BLUE){
            private static final long serialVersionUID = -8451338653189373347L;

            public boolean isEnabled() {
                return this.graphComponent.getGraph().isDropEnabled();
            }

            public Object getCell(MouseEvent e) {
                boolean clone;
                mxIGraphModel model = this.graphComponent.getGraph().getModel();
                TransferHandler th = this.graphComponent.getTransferHandler();
                boolean isLocal = th instanceof mxGraphTransferHandler && ((mxGraphTransferHandler)th).isLocalDrag();
                mxGraph graph = this.graphComponent.getGraph();
                Object cell = super.getCell(e);
                Object[] cells = isLocal ? graph.getSelectionCells() : mxGraphHandler.this.dragCells;
                Object parent = cell = graph.getDropTarget(cells, e.getPoint(), cell);
                while (parent != null) {
                    if (mxUtils.contains(cells, parent)) {
                        return null;
                    }
                    parent = model.getParent(parent);
                }
                boolean bl = clone = this.graphComponent.isCloneEvent(e) && mxGraphHandler.this.isCloneEnabled();
                if (isLocal && cell != null && cells.length > 0 && !clone && graph.getModel().getParent(cells[0]) == cell) {
                    cell = null;
                }
                return cell;
            }
        };
        marker.setSwimlaneContentEnabled(true);
        return marker;
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isCloneEnabled() {
        return this.cloneEnabled;
    }

    public void setCloneEnabled(boolean value) {
        this.cloneEnabled = value;
    }

    public boolean isMoveEnabled() {
        return this.moveEnabled;
    }

    public void setMoveEnabled(boolean value) {
        this.moveEnabled = value;
    }

    public boolean isMarkerEnabled() {
        return this.markerEnabled;
    }

    public void setMarkerEnabled(boolean value) {
        this.markerEnabled = value;
    }

    public mxCellMarker getMarker() {
        return this.marker;
    }

    public void setMarker(mxCellMarker value) {
        this.marker = value;
    }

    public boolean isSelectEnabled() {
        return this.selectEnabled;
    }

    public void setSelectEnabled(boolean value) {
        this.selectEnabled = value;
    }

    public boolean isRemoveCellsFromParent() {
        return this.removeCellsFromParent;
    }

    public void setRemoveCellsFromParent(boolean value) {
        this.removeCellsFromParent = value;
    }

    public boolean isLivePreview() {
        return this.livePreview;
    }

    public void setLivePreview(boolean value) {
        this.livePreview = value;
    }

    public boolean isImagePreview() {
        return this.imagePreview;
    }

    public void setImagePreview(boolean value) {
        this.imagePreview = value;
    }

    public boolean isCenterPreview() {
        return this.centerPreview;
    }

    public void setCenterPreview(boolean value) {
        this.centerPreview = value;
    }

    public void updateDragImage(Object[] cells) {
        BufferedImage img;
        this.dragImage = null;
        if (cells != null && cells.length > 0 && (img = mxCellRenderer.createBufferedImage(this.graphComponent.getGraph(), cells, this.graphComponent.getGraph().getView().getScale(), null, this.graphComponent.isAntiAlias(), null, this.graphComponent.getCanvas())) != null) {
            this.dragImage = new ImageIcon(img);
            this.previewBounds.setSize(this.dragImage.getIconWidth(), this.dragImage.getIconHeight());
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !e.isConsumed()) {
            Cursor cursor = this.getCursor(e);
            if (cursor != null) {
                this.graphComponent.getGraphControl().setCursor(cursor);
                e.consume();
            } else {
                this.graphComponent.getGraphControl().setCursor(DEFAULT_CURSOR);
            }
        }
    }

    protected Cursor getCursor(MouseEvent e) {
        Object cell;
        Cursor cursor = null;
        if (this.isMoveEnabled() && (cell = this.graphComponent.getCellAt(e.getX(), e.getY(), false)) != null) {
            if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(cell, e.getX(), e.getY())) {
                cursor = FOLD_CURSOR;
            } else if (this.graphComponent.getGraph().isCellMovable(cell)) {
                cursor = MOVE_CURSOR;
            }
        }
        return cursor;
    }

    public void dragEnter(DropTargetDragEvent e) {
        boolean isLocal;
        JComponent component = mxGraphHandler.getDropTarget(e);
        TransferHandler th = component.getTransferHandler();
        boolean bl = isLocal = th instanceof mxGraphTransferHandler && ((mxGraphTransferHandler)th).isLocalDrag();
        if (isLocal) {
            this.canImport = true;
        } else {
            boolean bl2 = this.canImport = this.graphComponent.isImportEnabled() && th.canImport(component, e.getCurrentDataFlavors());
        }
        if (this.canImport) {
            this.transferBounds = null;
            this.setVisible(false);
            try {
                Transferable t = e.getTransferable();
                if (t.isDataFlavorSupported(mxGraphTransferable.dataFlavor)) {
                    mxGraphTransferable gt = (mxGraphTransferable)t.getTransferData(mxGraphTransferable.dataFlavor);
                    this.dragCells = gt.getCells();
                    if (gt.getBounds() != null) {
                        mxGraph graph = this.graphComponent.getGraph();
                        double scale = graph.getView().getScale();
                        this.transferBounds = gt.getBounds();
                        int w = (int)Math.ceil((this.transferBounds.getWidth() + 1.0) * scale);
                        int h = (int)Math.ceil((this.transferBounds.getHeight() + 1.0) * scale);
                        this.setPreviewBounds(new Rectangle((int)this.transferBounds.getX(), (int)this.transferBounds.getY(), w, h));
                        if (this.imagePreview) {
                            if (isLocal) {
                                if (!this.isLivePreview()) {
                                    this.updateDragImage(graph.getMovableCells(this.dragCells));
                                }
                            } else {
                                Object[] tmp = this.graphComponent.getImportableCells(this.dragCells);
                                this.updateDragImage(tmp);
                                if (tmp == null || tmp.length == 0) {
                                    this.canImport = false;
                                    e.rejectDrag();
                                    return;
                                }
                            }
                        }
                        this.setVisible(true);
                    }
                }
                e.acceptDrag(3);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            e.rejectDrag();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !e.isConsumed() && !this.graphComponent.isForceMarqueeEvent(e)) {
            this.initialCell = this.cell = this.graphComponent.getCellAt(e.getX(), e.getY(), false);
            if (this.cell != null) {
                if (this.isSelectEnabled() && !this.graphComponent.getGraph().isCellSelected(this.cell)) {
                    this.graphComponent.selectCellForEvent(this.cell, e);
                    this.cell = null;
                }
                if (this.isMoveEnabled() && !e.isPopupTrigger()) {
                    this.start(e);
                    e.consume();
                }
            } else if (e.isPopupTrigger()) {
                this.graphComponent.getGraph().clearSelection();
            }
        }
    }

    public Object[] getCells(Object initialCell) {
        mxGraph graph = this.graphComponent.getGraph();
        return graph.getMovableCells(graph.getSelectionCells());
    }

    public void start(MouseEvent e) {
        if (this.isLivePreview()) {
            this.movePreview.start(e, this.graphComponent.getGraph().getView().getState(this.initialCell));
        } else {
            mxGraph graph = this.graphComponent.getGraph();
            this.cells = this.getCells(this.initialCell);
            this.cellBounds = graph.getView().getBounds(this.cells);
            if (this.cellBounds != null) {
                this.bbox = graph.getView().getBoundingBox(this.cells);
                Rectangle bounds = this.cellBounds.getRectangle();
                ++bounds.width;
                ++bounds.height;
                this.setPreviewBounds(bounds);
            }
        }
        this.first = e.getPoint();
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        if (this.canImport) {
            this.mouseDragged(this.createEvent(e));
            mxGraphTransferHandler handler = mxGraphHandler.getGraphTransferHandler(e);
            if (handler != null) {
                mxGraph graph = this.graphComponent.getGraph();
                double scale = graph.getView().getScale();
                Point pt = SwingUtilities.convertPoint(this.graphComponent, e.getLocation(), this.graphComponent.getGraphControl());
                pt = this.graphComponent.snapScaledPoint(new mxPoint(pt)).getPoint();
                handler.setLocation(new Point(pt));
                int dx = 0;
                int dy = 0;
                if (this.centerPreview && this.transferBounds != null) {
                    dx = (int)((long)dx - Math.round(this.transferBounds.getWidth() * scale / 2.0));
                    dy = (int)((long)dy - Math.round(this.transferBounds.getHeight() * scale / 2.0));
                }
                handler.setOffset(new Point((int)graph.snap((double)dx / scale), (int)graph.snap((double)dy / scale)));
                pt.translate(dx, dy);
                if (this.transferBounds != null && this.dragImage != null) {
                    dx = (int)Math.round(((double)(this.dragImage.getIconWidth() - 2) - this.transferBounds.getWidth() * scale) / 2.0);
                    dy = (int)Math.round(((double)(this.dragImage.getIconHeight() - 2) - this.transferBounds.getHeight() * scale) / 2.0);
                    pt.translate(-dx, -dy);
                }
                if (!handler.isLocalDrag() && this.previewBounds != null) {
                    this.setPreviewBounds(new Rectangle(pt, this.previewBounds.getSize()));
                }
            }
        } else {
            e.rejectDrag();
        }
    }

    public Point convertPoint(Point pt) {
        pt = SwingUtilities.convertPoint(this.graphComponent, pt, this.graphComponent.getGraphControl());
        pt.x -= this.graphComponent.getHorizontalScrollBar().getValue();
        pt.y -= this.graphComponent.getVerticalScrollBar().getValue();
        return pt;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.graphComponent.isAutoScroll()) {
            this.graphComponent.getGraphControl().scrollRectToVisible(new Rectangle(e.getPoint()));
        }
        if (!e.isConsumed()) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(e);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(e);
            if (this.constrainedEvent && this.first != null) {
                int x = e.getX();
                int y = e.getY();
                if (Math.abs(e.getX() - this.first.x) > Math.abs(e.getY() - this.first.y)) {
                    y = this.first.y;
                } else {
                    x = this.first.x;
                }
                e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            }
            if (this.isVisible() && this.isMarkerEnabled()) {
                this.marker.process(e);
            }
            if (this.first != null) {
                if (this.movePreview.isActive()) {
                    double dx = e.getX() - this.first.x;
                    double dy = e.getY() - this.first.y;
                    if (this.graphComponent.isGridEnabledEvent(e)) {
                        mxGraph graph = this.graphComponent.getGraph();
                        dx = graph.snap(dx);
                        dy = graph.snap(dy);
                    }
                    boolean clone = this.isCloneEnabled() && this.graphComponent.isCloneEvent(e);
                    this.movePreview.update(e, dx, dy, clone);
                    e.consume();
                } else if (this.cellBounds != null) {
                    double dx = e.getX() - this.first.x;
                    double dy = e.getY() - this.first.y;
                    if (this.previewBounds != null) {
                        this.setPreviewBounds(new Rectangle(this.getPreviewLocation(e, this.gridEnabledEvent), this.previewBounds.getSize()));
                    }
                    if (!this.isVisible() && this.graphComponent.isSignificant(dx, dy)) {
                        if (this.imagePreview && this.dragImage == null && !this.graphComponent.isDragEnabled()) {
                            this.updateDragImage(this.cells);
                        }
                        this.setVisible(true);
                    }
                    e.consume();
                }
            }
        }
    }

    protected Point getPreviewLocation(MouseEvent e, boolean gridEnabled) {
        int x = 0;
        int y = 0;
        if (this.first != null && this.cellBounds != null) {
            mxGraph graph = this.graphComponent.getGraph();
            double scale = graph.getView().getScale();
            mxPoint trans = graph.getView().getTranslate();
            double dx = e.getX() - this.first.x;
            double dy = e.getY() - this.first.y;
            double dxg = (this.cellBounds.getX() + dx) / scale - trans.getX();
            double dyg = (this.cellBounds.getY() + dy) / scale - trans.getY();
            if (gridEnabled) {
                dxg = graph.snap(dxg);
                dyg = graph.snap(dyg);
            }
            x = (int)Math.round((dxg + trans.getX()) * scale) + (int)Math.round(this.bbox.getX()) - (int)Math.round(this.cellBounds.getX());
            y = (int)Math.round((dyg + trans.getY()) * scale) + (int)Math.round(this.bbox.getY()) - (int)Math.round(this.cellBounds.getY());
        }
        return new Point(x, y);
    }

    public void dragExit(DropTargetEvent e) {
        mxGraphTransferHandler handler = mxGraphHandler.getGraphTransferHandler(e);
        if (handler != null) {
            handler.setLocation(null);
        }
        this.dragCells = null;
        this.setVisible(false);
        this.marker.reset();
        this.reset();
    }

    public void drop(DropTargetDropEvent e) {
        if (this.canImport) {
            mxGraphTransferHandler handler = mxGraphHandler.getGraphTransferHandler(e);
            MouseEvent event = this.createEvent(e);
            if (handler != null && !handler.isLocalDrag()) {
                event.consume();
            }
            this.mouseReleased(event);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !e.isConsumed()) {
            mxGraph graph = this.graphComponent.getGraph();
            double dx = 0.0;
            double dy = 0.0;
            if (this.first != null && (this.cellBounds != null || this.movePreview.isActive())) {
                double scale = graph.getView().getScale();
                mxPoint trans = graph.getView().getTranslate();
                dx = e.getX() - this.first.x;
                dy = e.getY() - this.first.y;
                if (this.cellBounds != null) {
                    double dxg = (this.cellBounds.getX() + dx) / scale - trans.getX();
                    double dyg = (this.cellBounds.getY() + dy) / scale - trans.getY();
                    if (this.gridEnabledEvent) {
                        dxg = graph.snap(dxg);
                        dyg = graph.snap(dyg);
                    }
                    double x = (dxg + trans.getX()) * scale + this.bbox.getX() - this.cellBounds.getX();
                    double y = (dyg + trans.getY()) * scale + this.bbox.getY() - this.cellBounds.getY();
                    dx = Math.round((x - this.bbox.getX()) / scale);
                    dy = Math.round((y - this.bbox.getY()) / scale);
                }
            }
            if (this.first == null || !this.graphComponent.isSignificant(e.getX() - this.first.x, e.getY() - this.first.y)) {
                if (!(this.cell == null || e.isPopupTrigger() || !this.isSelectEnabled() || this.first == null && this.isMoveEnabled())) {
                    this.graphComponent.selectCellForEvent(this.cell, e);
                }
                if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(this.initialCell, e.getX(), e.getY())) {
                    this.fold(this.initialCell);
                } else {
                    Object tmp = this.graphComponent.getCellAt(e.getX(), e.getY(), this.graphComponent.isSwimlaneSelectionEnabled());
                    if (this.cell == null && this.first == null) {
                        if (tmp == null) {
                            if (!this.graphComponent.isToggleEvent(e)) {
                                graph.clearSelection();
                            }
                        } else if (graph.isSwimlane(tmp) && this.graphComponent.getCanvas().hitSwimlaneContent(this.graphComponent, graph.getView().getState(tmp), e.getX(), e.getY())) {
                            this.graphComponent.selectCellForEvent(tmp, e);
                        }
                    }
                    if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(tmp, e.getX(), e.getY())) {
                        this.fold(tmp);
                        e.consume();
                    }
                }
            } else if (this.movePreview.isActive()) {
                boolean clone;
                Object[] result;
                mxCellState markedState;
                Object target;
                if (this.graphComponent.isConstrainedEvent(e)) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        dy = 0.0;
                    } else {
                        dx = 0.0;
                    }
                }
                Object object = target = (markedState = this.marker.getMarkedState()) != null ? markedState.getCell() : null;
                if (target == null && this.isRemoveCellsFromParent() && this.shouldRemoveCellFromParent(graph.getModel().getParent(this.initialCell), this.cells, e)) {
                    target = graph.getDefaultParent();
                }
                if (this.cells != (result = this.movePreview.stop(true, e, dx, dy, clone = this.isCloneEnabled() && this.graphComponent.isCloneEvent(e), target))) {
                    graph.setSelectionCells(result);
                }
                e.consume();
            } else if (this.isVisible()) {
                mxCellState targetState;
                Object target;
                if (this.constrainedEvent) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        dy = 0.0;
                    } else {
                        dx = 0.0;
                    }
                }
                Object object = target = (targetState = this.marker.getValidState()) != null ? targetState.getCell() : null;
                if (graph.isSplitEnabled() && graph.isSplitTarget(target, this.cells)) {
                    graph.splitEdge(target, this.cells, dx, dy);
                } else {
                    this.moveCells(this.cells, dx, dy, target, e);
                }
                e.consume();
            }
        }
        this.reset();
    }

    protected void fold(Object cell) {
        boolean collapse = !this.graphComponent.getGraph().isCellCollapsed(cell);
        this.graphComponent.getGraph().foldCells(collapse, false, new Object[]{cell});
    }

    public void reset() {
        if (this.movePreview.isActive()) {
            this.movePreview.stop(false, null, 0.0, 0.0, false, null);
        }
        this.setVisible(false);
        this.marker.reset();
        this.initialCell = null;
        this.dragCells = null;
        this.dragImage = null;
        this.cells = null;
        this.first = null;
        this.cell = null;
    }

    protected boolean shouldRemoveCellFromParent(Object parent, Object[] cells, MouseEvent e) {
        if (this.graphComponent.getGraph().getModel().isVertex(parent)) {
            mxCellState pState = this.graphComponent.getGraph().getView().getState(parent);
            return pState != null && !pState.contains(e.getX(), e.getY());
        }
        return false;
    }

    protected void moveCells(Object[] cells, double dx, double dy, Object target, MouseEvent e) {
        boolean clone;
        mxGraph graph = this.graphComponent.getGraph();
        boolean bl = clone = e.isControlDown() && this.isCloneEnabled();
        if (clone) {
            cells = graph.getCloneableCells(cells);
        }
        if (cells.length > 0) {
            if (target == null && this.isRemoveCellsFromParent() && this.shouldRemoveCellFromParent(graph.getModel().getParent(this.initialCell), cells, e)) {
                target = graph.getDefaultParent();
            }
            Object[] tmp = graph.moveCells(cells, dx, dy, clone, target, e.getPoint());
            if (this.isSelectEnabled() && clone && tmp != null && tmp.length == cells.length) {
                graph.setSelectionCells(tmp);
            }
        }
    }

    public void paint(Graphics g) {
        if (this.isVisible() && this.previewBounds != null) {
            if (this.dragImage != null) {
                Graphics2D tmp = (Graphics2D)g.create();
                if (this.graphComponent.getPreviewAlpha() < 1.0f) {
                    tmp.setComposite(AlphaComposite.getInstance(3, this.graphComponent.getPreviewAlpha()));
                }
                tmp.drawImage(this.dragImage.getImage(), this.previewBounds.x, this.previewBounds.y, this.dragImage.getIconWidth(), this.dragImage.getIconHeight(), null);
                tmp.dispose();
            } else if (!this.imagePreview) {
                mxSwingConstants.PREVIEW_BORDER.paintBorder(this.graphComponent, g, this.previewBounds.x, this.previewBounds.y, this.previewBounds.width, this.previewBounds.height);
            }
        }
    }

    protected MouseEvent createEvent(DropTargetEvent e) {
        JComponent component = mxGraphHandler.getDropTarget(e);
        Point location = null;
        int action = 0;
        if (e instanceof DropTargetDropEvent) {
            location = ((DropTargetDropEvent)e).getLocation();
            action = ((DropTargetDropEvent)e).getDropAction();
        } else if (e instanceof DropTargetDragEvent) {
            location = ((DropTargetDragEvent)e).getLocation();
            action = ((DropTargetDragEvent)e).getDropAction();
        }
        if (location != null) {
            location = this.convertPoint(location);
            Rectangle r = this.graphComponent.getViewport().getViewRect();
            location.translate(r.x, r.y);
        }
        int mod = action == 1 ? 2 : 0;
        return new MouseEvent(component, 0, System.currentTimeMillis(), mod, location.x, location.y, 1, false, 1);
    }

    protected static final mxGraphTransferHandler getGraphTransferHandler(DropTargetEvent e) {
        JComponent component = mxGraphHandler.getDropTarget(e);
        TransferHandler transferHandler = component.getTransferHandler();
        if (transferHandler instanceof mxGraphTransferHandler) {
            return (mxGraphTransferHandler)transferHandler;
        }
        return null;
    }

    protected static final JComponent getDropTarget(DropTargetEvent e) {
        return (JComponent)e.getDropTargetContext().getComponent();
    }
}

