/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.stage;

import com.mxgraph.layout.hierarchical.model.mxGraphAbstractHierarchyCell;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyEdge;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyNode;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.hierarchical.stage.mxHierarchicalLayoutStage;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraph;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxCoordinateAssignment
implements mxHierarchicalLayoutStage {
    protected mxHierarchicalLayout layout;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 30.0;
    protected double parallelEdgeSpacing = 4.0;
    protected double vertexConnectionBuffer = 0.0;
    protected int maxIterations = 8;
    protected int prefHozEdgeSep = 5;
    protected int prefVertEdgeOff = 2;
    protected int minEdgeJetty = 12;
    protected int channelBuffer = 4;
    protected Map<mxGraphHierarchyEdge, double[]> jettyPositions = new HashMap<mxGraphHierarchyEdge, double[]>();
    protected int orientation = 1;
    protected double initialX;
    protected double limitX;
    protected double currentXDelta;
    protected int widestRank;
    protected double[] rankTopY;
    protected double[] rankBottomY;
    protected double widestRankValue;
    protected double[] rankWidths;
    protected double[] rankY;
    protected boolean fineTuning = true;
    protected boolean disableEdgeStyle = true;
    protected HierarchicalEdgeStyle edgeStyle = HierarchicalEdgeStyle.POLYLINE;
    protected mxGraphAbstractHierarchyCell[][] nextLayerConnectedCache;
    protected int groupPadding = 10;
    protected mxGraphAbstractHierarchyCell[][] previousLayerConnectedCache;
    private static Logger logger = Logger.getLogger("com.jgraph.layout.hierarchical.JGraphCoordinateAssignment");

    public mxCoordinateAssignment(mxHierarchicalLayout layout, double intraCellSpacing, double interRankCellSpacing, int orientation, double initialX, double parallelEdgeSpacing) {
        this.layout = layout;
        this.intraCellSpacing = intraCellSpacing;
        this.interRankCellSpacing = interRankCellSpacing;
        this.orientation = orientation;
        this.initialX = initialX;
        this.parallelEdgeSpacing = parallelEdgeSpacing;
        this.setLoggerLevel(Level.OFF);
    }

    public void printStatus() {
        mxGraphHierarchyModel model = this.layout.getModel();
        System.out.println("======Coord assignment debug=======");
        for (int j = 0; j < model.ranks.size(); ++j) {
            System.out.print("Rank " + j + " : ");
            mxGraphHierarchyRank rank = model.ranks.get(new Integer(j));
            for (mxGraphAbstractHierarchyCell cell : rank) {
                System.out.print(cell.getX(j) + "  ");
            }
            System.out.println();
        }
        System.out.println("====================================");
    }

    @Override
    public void execute(Object parent) {
        mxGraphHierarchyModel model = this.layout.getModel();
        this.currentXDelta = 0.0;
        this.initialCoords(this.layout.getGraph(), model);
        if (this.fineTuning) {
            this.minNode(model);
        }
        double bestXDelta = 1.0E8;
        if (this.fineTuning) {
            for (int i = 0; i < this.maxIterations; ++i) {
                mxGraphHierarchyRank rank;
                int j;
                if (i != 0) {
                    this.medianPos(i, model);
                    this.minNode(model);
                }
                if (this.currentXDelta < bestXDelta) {
                    for (j = 0; j < model.ranks.size(); ++j) {
                        rank = model.ranks.get(new Integer(j));
                        for (mxGraphAbstractHierarchyCell cell : rank) {
                            cell.setX(j, cell.getGeneralPurposeVariable(j));
                        }
                    }
                    bestXDelta = this.currentXDelta;
                } else {
                    for (j = 0; j < model.ranks.size(); ++j) {
                        rank = model.ranks.get(new Integer(j));
                        for (mxGraphAbstractHierarchyCell cell : rank) {
                            cell.setGeneralPurposeVariable(j, (int)cell.getX(j));
                        }
                    }
                }
                this.minPath(model);
                this.currentXDelta = 0.0;
            }
        }
        this.setCellLocations(this.layout.getGraph(), model);
    }

    private void minNode(mxGraphHierarchyModel model) {
        LinkedList<WeightedCellSorter> nodeList = new LinkedList<WeightedCellSorter>();
        Hashtable<mxGraphAbstractHierarchyCell, WeightedCellSorter> map = new Hashtable<mxGraphAbstractHierarchyCell, WeightedCellSorter>();
        mxGraphAbstractHierarchyCell[][] rank = new mxGraphAbstractHierarchyCell[model.maxRank + 1][];
        for (int i = 0; i <= model.maxRank; ++i) {
            mxGraphHierarchyRank rankSet = model.ranks.get(new Integer(i));
            rank[i] = rankSet.toArray(new mxGraphAbstractHierarchyCell[rankSet.size()]);
            int j = 0;
            while (j < rank[i].length) {
                mxGraphAbstractHierarchyCell cell = rank[i][j];
                WeightedCellSorter cellWrapper = new WeightedCellSorter(cell, i);
                cellWrapper.rankIndex = j++;
                cellWrapper.visited = true;
                nodeList.add(cellWrapper);
                map.put(cell, cellWrapper);
            }
        }
        int maxTries = nodeList.size() * 10;
        int tolerance = 1;
        for (int count = 0; !nodeList.isEmpty() && count <= maxTries; ++count) {
            WeightedCellSorter cellWrapper = (WeightedCellSorter)nodeList.getFirst();
            mxGraphAbstractHierarchyCell cell = cellWrapper.cell;
            int rankValue = cellWrapper.weightedValue;
            int rankIndex = cellWrapper.rankIndex;
            Object[] nextLayerConnectedCells = cell.getNextLayerConnectedCells(rankValue).toArray();
            Object[] previousLayerConnectedCells = cell.getPreviousLayerConnectedCells(rankValue).toArray();
            int numNextLayerConnected = nextLayerConnectedCells.length;
            int numPreviousLayerConnected = previousLayerConnectedCells.length;
            int medianNextLevel = this.medianXValue(nextLayerConnectedCells, rankValue + 1);
            int medianPreviousLevel = this.medianXValue(previousLayerConnectedCells, rankValue - 1);
            int numConnectedNeighbours = numNextLayerConnected + numPreviousLayerConnected;
            int currentPosition = cell.getGeneralPurposeVariable(rankValue);
            double cellMedian = currentPosition;
            if (numConnectedNeighbours > 0) {
                cellMedian = (medianNextLevel * numNextLayerConnected + medianPreviousLevel * numPreviousLayerConnected) / numConnectedNeighbours;
            }
            boolean positionChanged = false;
            if (cellMedian < (double)(currentPosition - tolerance)) {
                if (rankIndex == 0) {
                    cell.setGeneralPurposeVariable(rankValue, (int)cellMedian);
                    positionChanged = true;
                } else {
                    mxGraphAbstractHierarchyCell leftCell = rank[rankValue][rankIndex - 1];
                    int leftLimit = leftCell.getGeneralPurposeVariable(rankValue);
                    if ((double)(leftLimit = leftLimit + (int)leftCell.width / 2 + (int)this.intraCellSpacing + (int)cell.width / 2) < cellMedian) {
                        cell.setGeneralPurposeVariable(rankValue, (int)cellMedian);
                        positionChanged = true;
                    } else if (leftLimit < cell.getGeneralPurposeVariable(rankValue) - tolerance) {
                        cell.setGeneralPurposeVariable(rankValue, leftLimit);
                        positionChanged = true;
                    }
                }
            } else if (cellMedian > (double)(currentPosition + tolerance)) {
                int rankSize = rank[rankValue].length;
                if (rankIndex == rankSize - 1) {
                    cell.setGeneralPurposeVariable(rankValue, (int)cellMedian);
                    positionChanged = true;
                } else {
                    mxGraphAbstractHierarchyCell rightCell = rank[rankValue][rankIndex + 1];
                    int rightLimit = rightCell.getGeneralPurposeVariable(rankValue);
                    if ((double)(rightLimit = rightLimit - (int)rightCell.width / 2 - (int)this.intraCellSpacing - (int)cell.width / 2) > cellMedian) {
                        cell.setGeneralPurposeVariable(rankValue, (int)cellMedian);
                        positionChanged = true;
                    } else if (rightLimit > cell.getGeneralPurposeVariable(rankValue) + tolerance) {
                        cell.setGeneralPurposeVariable(rankValue, rightLimit);
                        positionChanged = true;
                    }
                }
            }
            if (positionChanged) {
                int i;
                for (i = 0; i < nextLayerConnectedCells.length; ++i) {
                    mxGraphAbstractHierarchyCell connectedCell = (mxGraphAbstractHierarchyCell)nextLayerConnectedCells[i];
                    WeightedCellSorter connectedCellWrapper = (WeightedCellSorter)map.get(connectedCell);
                    if (connectedCellWrapper == null || connectedCellWrapper.visited) continue;
                    connectedCellWrapper.visited = true;
                    nodeList.add(connectedCellWrapper);
                }
                for (i = 0; i < previousLayerConnectedCells.length; ++i) {
                    mxGraphAbstractHierarchyCell connectedCell = (mxGraphAbstractHierarchyCell)previousLayerConnectedCells[i];
                    WeightedCellSorter connectedCellWrapper = (WeightedCellSorter)map.get(connectedCell);
                    if (connectedCellWrapper == null || connectedCellWrapper.visited) continue;
                    connectedCellWrapper.visited = true;
                    nodeList.add(connectedCellWrapper);
                }
            }
            nodeList.removeFirst();
            cellWrapper.visited = false;
        }
    }

    private void medianPos(int i, mxGraphHierarchyModel model) {
        boolean downwardSweep;
        boolean bl = downwardSweep = i % 2 == 0;
        if (downwardSweep) {
            for (int j = model.maxRank; j > 0; --j) {
                this.rankMedianPosition(j - 1, model, j);
            }
        } else {
            for (int j = 0; j < model.maxRank - 1; ++j) {
                this.rankMedianPosition(j + 1, model, j);
            }
        }
    }

    protected void rankMedianPosition(int rankValue, mxGraphHierarchyModel model, int nextRankValue) {
        int i;
        mxGraphHierarchyRank rankSet = model.ranks.get(new Integer(rankValue));
        Object[] rank = rankSet.toArray();
        Object[] weightedValues = new WeightedCellSorter[rank.length];
        Hashtable<mxGraphAbstractHierarchyCell, Object> cellMap = new Hashtable<mxGraphAbstractHierarchyCell, Object>(rank.length);
        for (i = 0; i < rank.length; ++i) {
            mxGraphAbstractHierarchyCell currentCell = (mxGraphAbstractHierarchyCell)rank[i];
            weightedValues[i] = new WeightedCellSorter();
            ((WeightedCellSorter)weightedValues[i]).cell = currentCell;
            ((WeightedCellSorter)weightedValues[i]).rankIndex = i;
            cellMap.put(currentCell, weightedValues[i]);
            List<mxGraphAbstractHierarchyCell> nextLayerConnectedCells = null;
            nextLayerConnectedCells = nextRankValue < rankValue ? currentCell.getPreviousLayerConnectedCells(rankValue) : currentCell.getNextLayerConnectedCells(rankValue);
            ((WeightedCellSorter)weightedValues[i]).weightedValue = this.calculatedWeightedValue(currentCell, nextLayerConnectedCells);
        }
        Arrays.sort(weightedValues);
        for (i = 0; i < weightedValues.length; ++i) {
            int numConnectionsNextLevel = 0;
            mxGraphAbstractHierarchyCell cell = ((WeightedCellSorter)weightedValues[i]).cell;
            Object[] nextLayerConnectedCells = null;
            int medianNextLevel = 0;
            nextLayerConnectedCells = nextRankValue < rankValue ? cell.getPreviousLayerConnectedCells(rankValue).toArray() : cell.getNextLayerConnectedCells(rankValue).toArray();
            if (nextLayerConnectedCells != null) {
                numConnectionsNextLevel = nextLayerConnectedCells.length;
                medianNextLevel = numConnectionsNextLevel > 0 ? this.medianXValue(nextLayerConnectedCells, nextRankValue) : cell.getGeneralPurposeVariable(rankValue);
            }
            double leftBuffer = 0.0;
            double leftLimit = -1.0E8;
            int j = ((WeightedCellSorter)weightedValues[i]).rankIndex - 1;
            while (j >= 0) {
                WeightedCellSorter weightedValue = (WeightedCellSorter)cellMap.get(rank[j]);
                if (weightedValue == null) continue;
                mxGraphAbstractHierarchyCell leftCell = weightedValue.cell;
                if (weightedValue.visited) {
                    leftLimit = (double)leftCell.getGeneralPurposeVariable(rankValue) + leftCell.width / 2.0 + this.intraCellSpacing + leftBuffer + cell.width / 2.0;
                    j = -1;
                    continue;
                }
                leftBuffer += leftCell.width + this.intraCellSpacing;
                --j;
            }
            double rightBuffer = 0.0;
            double rightLimit = 1.0E8;
            int j2 = ((WeightedCellSorter)weightedValues[i]).rankIndex + 1;
            while (j2 < weightedValues.length) {
                WeightedCellSorter weightedValue = (WeightedCellSorter)cellMap.get(rank[j2]);
                if (weightedValue == null) continue;
                mxGraphAbstractHierarchyCell rightCell = weightedValue.cell;
                if (weightedValue.visited) {
                    rightLimit = (double)rightCell.getGeneralPurposeVariable(rankValue) - rightCell.width / 2.0 - this.intraCellSpacing - rightBuffer - cell.width / 2.0;
                    j2 = weightedValues.length;
                    continue;
                }
                rightBuffer += rightCell.width + this.intraCellSpacing;
                ++j2;
            }
            if ((double)medianNextLevel >= leftLimit && (double)medianNextLevel <= rightLimit) {
                cell.setGeneralPurposeVariable(rankValue, medianNextLevel);
            } else if ((double)medianNextLevel < leftLimit) {
                cell.setGeneralPurposeVariable(rankValue, (int)leftLimit);
                this.currentXDelta += leftLimit - (double)medianNextLevel;
            } else if ((double)medianNextLevel > rightLimit) {
                cell.setGeneralPurposeVariable(rankValue, (int)rightLimit);
                this.currentXDelta += (double)medianNextLevel - rightLimit;
            }
            ((WeightedCellSorter)weightedValues[i]).visited = true;
        }
    }

    private int calculatedWeightedValue(mxGraphAbstractHierarchyCell currentCell, Collection<mxGraphAbstractHierarchyCell> collection) {
        int totalWeight = 0;
        for (mxGraphAbstractHierarchyCell cell : collection) {
            if (currentCell.isVertex() && cell.isVertex()) {
                ++totalWeight;
                continue;
            }
            if (currentCell.isEdge() && cell.isEdge()) {
                totalWeight += 8;
                continue;
            }
            totalWeight += 2;
        }
        return totalWeight;
    }

    private int medianXValue(Object[] connectedCells, int rankValue) {
        if (connectedCells.length == 0) {
            return 0;
        }
        int[] medianValues = new int[connectedCells.length];
        for (int i = 0; i < connectedCells.length; ++i) {
            medianValues[i] = ((mxGraphAbstractHierarchyCell)connectedCells[i]).getGeneralPurposeVariable(rankValue);
        }
        Arrays.sort(medianValues);
        if (connectedCells.length % 2 == 1) {
            return medianValues[connectedCells.length / 2];
        }
        int medianPoint = connectedCells.length / 2;
        int leftMedian = medianValues[medianPoint - 1];
        int rightMedian = medianValues[medianPoint];
        return (leftMedian + rightMedian) / 2;
    }

    private void initialCoords(mxGraph facade, mxGraphHierarchyModel model) {
        int i;
        this.calculateWidestRank(facade, model);
        for (i = this.widestRank; i >= 0; --i) {
            if (i >= model.maxRank) continue;
            this.rankCoordinates(i, facade, model);
        }
        for (i = this.widestRank + 1; i <= model.maxRank; ++i) {
            if (i <= 0) continue;
            this.rankCoordinates(i, facade, model);
        }
    }

    protected void rankCoordinates(int rankValue, mxGraph graph, mxGraphHierarchyModel model) {
        mxGraphHierarchyRank rank = model.ranks.get(new Integer(rankValue));
        double maxY = 0.0;
        double localX = this.initialX + (this.widestRankValue - this.rankWidths[rankValue]) / 2.0;
        boolean boundsWarning = false;
        for (mxGraphAbstractHierarchyCell cell : rank) {
            if (cell.isVertex()) {
                mxGraphHierarchyNode node = (mxGraphHierarchyNode)cell;
                mxRectangle bounds = this.layout.getVertexBounds(node.cell);
                if (bounds != null) {
                    if (this.orientation == 1 || this.orientation == 5) {
                        cell.width = bounds.getWidth();
                        cell.height = bounds.getHeight();
                    } else {
                        cell.width = bounds.getHeight();
                        cell.height = bounds.getWidth();
                    }
                } else {
                    boundsWarning = true;
                }
                maxY = Math.max(maxY, cell.height);
            } else if (cell.isEdge()) {
                mxGraphHierarchyEdge edge = (mxGraphHierarchyEdge)cell;
                int numEdges = 1;
                if (edge.edges != null) {
                    numEdges = edge.edges.size();
                } else {
                    logger.info("edge.edges is null");
                }
                cell.width = (double)(numEdges - 1) * this.parallelEdgeSpacing;
            }
            cell.setX(rankValue, localX += cell.width / 2.0);
            cell.setGeneralPurposeVariable(rankValue, (int)localX);
            localX += cell.width / 2.0;
            localX += this.intraCellSpacing;
        }
        if (boundsWarning) {
            logger.info("At least one cell has no bounds");
        }
    }

    protected void calculateWidestRank(mxGraph graph, mxGraphHierarchyModel model) {
        double y = -this.interRankCellSpacing;
        double lastRankMaxCellHeight = 0.0;
        this.rankWidths = new double[model.maxRank + 1];
        this.rankY = new double[model.maxRank + 1];
        for (int rankValue = model.maxRank; rankValue >= 0; --rankValue) {
            double maxCellHeight = 0.0;
            mxGraphHierarchyRank rank = model.ranks.get(new Integer(rankValue));
            double localX = this.initialX;
            boolean boundsWarning = false;
            for (mxGraphAbstractHierarchyCell cell : rank) {
                if (cell.isVertex()) {
                    mxGraphHierarchyNode node = (mxGraphHierarchyNode)cell;
                    mxRectangle bounds = this.layout.getVertexBounds(node.cell);
                    if (bounds != null) {
                        if (this.orientation == 1 || this.orientation == 5) {
                            cell.width = bounds.getWidth();
                            cell.height = bounds.getHeight();
                        } else {
                            cell.width = bounds.getHeight();
                            cell.height = bounds.getWidth();
                        }
                    } else {
                        boundsWarning = true;
                    }
                    maxCellHeight = Math.max(maxCellHeight, cell.height);
                } else if (cell.isEdge()) {
                    mxGraphHierarchyEdge edge = (mxGraphHierarchyEdge)cell;
                    int numEdges = 1;
                    if (edge.edges != null) {
                        numEdges = edge.edges.size();
                    } else {
                        logger.info("edge.edges is null");
                    }
                    cell.width = (double)(numEdges - 1) * this.parallelEdgeSpacing;
                }
                cell.setX(rankValue, localX += cell.width / 2.0);
                cell.setGeneralPurposeVariable(rankValue, (int)localX);
                localX += cell.width / 2.0;
                localX += this.intraCellSpacing;
                if (localX > this.widestRankValue) {
                    this.widestRankValue = localX;
                    this.widestRank = rankValue;
                }
                this.rankWidths[rankValue] = localX;
            }
            if (boundsWarning) {
                logger.info("At least one cell has no bounds");
            }
            this.rankY[rankValue] = y;
            double distanceToNextRank = maxCellHeight / 2.0 + lastRankMaxCellHeight / 2.0 + this.interRankCellSpacing;
            lastRankMaxCellHeight = maxCellHeight;
            y = this.orientation == 1 || this.orientation == 7 ? (y += distanceToNextRank) : (y -= distanceToNextRank);
            for (mxGraphAbstractHierarchyCell cell : rank) {
                cell.setY(rankValue, y);
            }
        }
    }

    protected void minPath(mxGraphHierarchyModel model) {
        Map<Object, mxGraphHierarchyEdge> edges = model.getEdgeMapper();
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : edges.values()) {
            double nextX;
            int i;
            if (mxGraphAbstractHierarchyCell2.maxRank <= mxGraphAbstractHierarchyCell2.minRank + 2) continue;
            int numEdgeLayers = mxGraphAbstractHierarchyCell2.maxRank - mxGraphAbstractHierarchyCell2.minRank - 1;
            int referenceX = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(mxGraphAbstractHierarchyCell2.minRank + 1);
            boolean edgeStraight = true;
            int refSegCount = 0;
            for (int i2 = mxGraphAbstractHierarchyCell2.minRank + 2; i2 < mxGraphAbstractHierarchyCell2.maxRank; ++i2) {
                int x = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(i2);
                if (referenceX != x) {
                    edgeStraight = false;
                    referenceX = x;
                    continue;
                }
                ++refSegCount;
            }
            if (edgeStraight) continue;
            int upSegCount = 0;
            int downSegCount = 0;
            double[] upXPositions = new double[numEdgeLayers - 1];
            double[] downXPositions = new double[numEdgeLayers - 1];
            double currentX = mxGraphAbstractHierarchyCell2.getX(mxGraphAbstractHierarchyCell2.minRank + 1);
            for (i = mxGraphAbstractHierarchyCell2.minRank + 1; i < mxGraphAbstractHierarchyCell2.maxRank - 1; ++i) {
                nextX = mxGraphAbstractHierarchyCell2.getX(i + 1);
                if (currentX == nextX) {
                    upXPositions[i - mxGraphAbstractHierarchyCell2.minRank - 1] = currentX;
                    ++upSegCount;
                    continue;
                }
                if (this.repositionValid(model, mxGraphAbstractHierarchyCell2, i + 1, currentX)) {
                    upXPositions[i - mxGraphAbstractHierarchyCell2.minRank - 1] = currentX;
                    ++upSegCount;
                    continue;
                }
                upXPositions[i - mxGraphAbstractHierarchyCell2.minRank - 1] = nextX;
                currentX = nextX;
            }
            currentX = mxGraphAbstractHierarchyCell2.getX(mxGraphAbstractHierarchyCell2.maxRank - 1);
            for (i = mxGraphAbstractHierarchyCell2.maxRank - 1; i > mxGraphAbstractHierarchyCell2.minRank + 1; --i) {
                nextX = mxGraphAbstractHierarchyCell2.getX(i - 1);
                if (currentX == nextX) {
                    downXPositions[i - mxGraphAbstractHierarchyCell2.minRank - 2] = currentX;
                    ++downSegCount;
                    continue;
                }
                if (this.repositionValid(model, mxGraphAbstractHierarchyCell2, i - 1, currentX)) {
                    downXPositions[i - mxGraphAbstractHierarchyCell2.minRank - 2] = currentX;
                    ++downSegCount;
                    continue;
                }
                downXPositions[i - mxGraphAbstractHierarchyCell2.minRank - 2] = mxGraphAbstractHierarchyCell2.getX(i - 1);
                currentX = nextX;
            }
            if (downSegCount <= refSegCount && upSegCount <= refSegCount) continue;
            if (downSegCount >= upSegCount) {
                for (i = mxGraphAbstractHierarchyCell2.maxRank - 2; i > mxGraphAbstractHierarchyCell2.minRank; --i) {
                    mxGraphAbstractHierarchyCell2.setX(i, (int)downXPositions[i - mxGraphAbstractHierarchyCell2.minRank - 1]);
                }
                continue;
            }
            if (upSegCount <= downSegCount) continue;
            for (i = mxGraphAbstractHierarchyCell2.minRank + 2; i < mxGraphAbstractHierarchyCell2.maxRank; ++i) {
                mxGraphAbstractHierarchyCell2.setX(i, (int)upXPositions[i - mxGraphAbstractHierarchyCell2.minRank - 2]);
            }
        }
    }

    protected boolean repositionValid(mxGraphHierarchyModel model, mxGraphAbstractHierarchyCell cell, int rank, double position) {
        mxGraphHierarchyRank rankSet = model.ranks.get(new Integer(rank));
        mxGraphAbstractHierarchyCell[] rankArray = rankSet.toArray(new mxGraphAbstractHierarchyCell[rankSet.size()]);
        int rankIndex = -1;
        for (int i = 0; i < rankArray.length; ++i) {
            if (cell != rankArray[i]) continue;
            rankIndex = i;
            break;
        }
        if (rankIndex < 0) {
            return false;
        }
        int currentX = cell.getGeneralPurposeVariable(rank);
        if (position < (double)currentX) {
            if (rankIndex == 0) {
                return true;
            }
            mxGraphAbstractHierarchyCell leftCell = rankArray[rankIndex - 1];
            int leftLimit = leftCell.getGeneralPurposeVariable(rank);
            return (double)(leftLimit = leftLimit + (int)leftCell.width / 2 + (int)this.intraCellSpacing + (int)cell.width / 2) <= position;
        }
        if (position > (double)currentX) {
            if (rankIndex == rankArray.length - 1) {
                return true;
            }
            mxGraphAbstractHierarchyCell rightCell = rankArray[rankIndex + 1];
            int rightLimit = rightCell.getGeneralPurposeVariable(rank);
            return (double)(rightLimit = rightLimit - (int)rightCell.width / 2 - (int)this.intraCellSpacing - (int)cell.width / 2) >= position;
        }
        return true;
    }

    protected void setCellLocations(mxGraph graph, mxGraphHierarchyModel model) {
        this.rankTopY = new double[model.ranks.size()];
        this.rankBottomY = new double[model.ranks.size()];
        for (int i = 0; i < model.ranks.size(); ++i) {
            this.rankTopY[i] = Double.MAX_VALUE;
            this.rankBottomY[i] = -1.7976931348623157E308;
        }
        HashSet<Object> parentsChanged = null;
        if (this.layout.isResizeParent()) {
            parentsChanged = new HashSet<Object>();
        }
        Map<Object, mxGraphHierarchyEdge> edges = model.getEdgeMapper();
        Map<Object, mxGraphHierarchyNode> vertices = model.getVertexMapper();
        for (mxGraphHierarchyNode mxGraphHierarchyNode2 : vertices.values()) {
            this.setVertexLocation(mxGraphHierarchyNode2);
            if (!this.layout.isResizeParent()) continue;
            parentsChanged.add(graph.getModel().getParent(mxGraphHierarchyNode2.cell));
        }
        if (this.layout.isResizeParent()) {
            this.adjustParents(parentsChanged);
        }
        if (this.edgeStyle == HierarchicalEdgeStyle.ORTHOGONAL || this.edgeStyle == HierarchicalEdgeStyle.POLYLINE) {
            this.localEdgeProcessing(model);
        }
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : edges.values()) {
            this.setEdgePosition(mxGraphAbstractHierarchyCell2);
        }
    }

    protected void adjustParents(Set<Object> parentsChanged) {
        this.layout.arrangeGroups(mxUtils.sortCells(parentsChanged, true).toArray(), this.groupPadding);
    }

    protected void localEdgeProcessing(mxGraphHierarchyModel model) {
        Map<Object, mxGraphHierarchyEdge> edgeMapping = model.getEdgeMapper();
        if (edgeMapping != null && this.jettyPositions.size() != edgeMapping.size()) {
            this.jettyPositions = new HashMap<mxGraphHierarchyEdge, double[]>();
        }
        for (int i = 0; i < model.ranks.size(); ++i) {
            mxGraphHierarchyRank rank = model.ranks.get(new Integer(i));
            for (mxGraphAbstractHierarchyCell cell : rank) {
                if (!cell.isVertex()) continue;
                mxGraphAbstractHierarchyCell[] currentCells = cell.getPreviousLayerConnectedCells(i).toArray(new mxGraphAbstractHierarchyCell[cell.getPreviousLayerConnectedCells(i).size()]);
                int currentRank = i - 1;
                for (int k = 0; k < 2; ++k) {
                    if (currentRank > -1 && currentRank < model.ranks.size() && currentCells != null && currentCells.length > 0) {
                        Object[] sortedCells = new WeightedCellSorter[currentCells.length];
                        for (int j = 0; j < currentCells.length; ++j) {
                            sortedCells[j] = new WeightedCellSorter(currentCells[j], -((int)currentCells[j].getX(currentRank)));
                        }
                        Arrays.sort(sortedCells);
                        mxGraphHierarchyNode node = (mxGraphHierarchyNode)cell;
                        double leftLimit = node.x[0] - node.width / 2.0;
                        double rightLimit = leftLimit + node.width;
                        int connectedEdgeCount = 0;
                        int connectedEdgeGroupCount = 0;
                        mxGraphHierarchyEdge[] connectedEdges = new mxGraphHierarchyEdge[sortedCells.length];
                        for (int j = 0; j < sortedCells.length; ++j) {
                            mxGraphAbstractHierarchyCell innerCell = ((WeightedCellSorter)sortedCells[j]).cell;
                            if (innerCell.isVertex()) {
                                Collection<mxGraphHierarchyEdge> connections = k == 0 ? ((mxGraphHierarchyNode)cell).connectsAsSource : ((mxGraphHierarchyNode)cell).connectsAsTarget;
                                for (mxGraphHierarchyEdge connectedEdge : connections) {
                                    if (connectedEdge.source != innerCell && connectedEdge.target != innerCell) continue;
                                    connectedEdgeCount += connectedEdge.edges.size();
                                    ++connectedEdgeGroupCount;
                                    connectedEdges[j] = connectedEdge;
                                }
                                continue;
                            }
                            connectedEdgeCount += ((mxGraphHierarchyEdge)innerCell).edges.size();
                            ++connectedEdgeGroupCount;
                            connectedEdges[j] = (mxGraphHierarchyEdge)innerCell;
                        }
                        double requiredWidth = (connectedEdgeCount + 1) * this.prefHozEdgeSep;
                        if (cell.width > requiredWidth + (double)(2 * this.prefHozEdgeSep)) {
                            leftLimit += (double)this.prefHozEdgeSep;
                            rightLimit -= (double)this.prefHozEdgeSep;
                        }
                        double availableWidth = rightLimit - leftLimit;
                        double edgeSpacing = availableWidth / (double)connectedEdgeCount;
                        double currentX = leftLimit + edgeSpacing / 2.0;
                        double currentYOffset = this.minEdgeJetty - this.prefVertEdgeOff;
                        double maxYOffset = 0.0;
                        for (int j = 0; j < connectedEdges.length; ++j) {
                            int numActualEdges = connectedEdges[j].edges.size();
                            double[] pos = this.jettyPositions.get(connectedEdges[j]);
                            if (pos == null || pos.length != 4 * numActualEdges) {
                                pos = new double[4 * numActualEdges];
                                this.jettyPositions.put(connectedEdges[j], pos);
                            }
                            if ((float)j < (float)connectedEdgeCount / 2.0f) {
                                currentYOffset += (double)this.prefVertEdgeOff;
                            } else if ((float)j > (float)connectedEdgeCount / 2.0f) {
                                currentYOffset -= (double)this.prefVertEdgeOff;
                            }
                            for (int m = 0; m < numActualEdges; ++m) {
                                pos[m * 4 + k * 2] = currentX;
                                currentX += edgeSpacing;
                                pos[m * 4 + k * 2 + 1] = currentYOffset;
                            }
                            maxYOffset = Math.max(maxYOffset, currentYOffset);
                        }
                    }
                    currentCells = cell.getNextLayerConnectedCells(i).toArray(new mxGraphAbstractHierarchyCell[cell.getNextLayerConnectedCells(i).size()]);
                    currentRank = i + 1;
                }
            }
        }
    }

    protected void setEdgePosition(mxGraphAbstractHierarchyCell cell) {
        mxGraphHierarchyEdge edge = (mxGraphHierarchyEdge)cell;
        double offsetX = 0.0;
        if (edge.temp[0] != 101207) {
            boolean layoutReversed;
            int maxRank = edge.maxRank;
            int minRank = edge.minRank;
            if (maxRank == minRank) {
                maxRank = edge.source.maxRank;
                minRank = edge.target.minRank;
            }
            Iterator<Object> parallelEdges = edge.edges.iterator();
            int parallelEdgeCount = 0;
            double[] jettys = this.jettyPositions.get(edge);
            Object source = edge.isReversed() ? edge.target.cell : edge.source.cell;
            boolean bl = layoutReversed = this.orientation == 3 || this.orientation == 5;
            while (parallelEdges.hasNext()) {
                Object realEdge = parallelEdges.next();
                Object realSource = this.layout.getGraph().getView().getVisibleTerminal(realEdge, true);
                ArrayList<mxPoint> newPoints = new ArrayList<mxPoint>(edge.x.length);
                boolean reversed = edge.isReversed();
                if (realSource != source) {
                    boolean bl2 = reversed = !reversed;
                }
                if (jettys != null) {
                    int arrayOffset;
                    int n = arrayOffset = reversed ? 2 : 0;
                    double y = reversed ? (layoutReversed ? this.rankBottomY[minRank] : this.rankTopY[minRank]) : (layoutReversed ? this.rankTopY[maxRank] : this.rankBottomY[maxRank]);
                    double jetty = jettys[parallelEdgeCount * 4 + 1 + arrayOffset];
                    if (reversed != layoutReversed) {
                        jetty = -jetty;
                    }
                    y += jetty;
                    double x = jettys[parallelEdgeCount * 4 + arrayOffset];
                    if (this.orientation == 1 || this.orientation == 5) {
                        newPoints.add(new mxPoint(x, y));
                    } else {
                        newPoints.add(new mxPoint(y, x));
                    }
                }
                int loopStart = edge.x.length - 1;
                int loopLimit = -1;
                int loopDelta = -1;
                int currentRank = edge.maxRank - 1;
                if (reversed) {
                    loopStart = 0;
                    loopLimit = edge.x.length;
                    loopDelta = 1;
                    currentRank = edge.minRank + 1;
                }
                for (int j = loopStart; edge.maxRank != edge.minRank && j != loopLimit; j += loopDelta) {
                    double positionX = edge.x[j] + offsetX;
                    double topChannelY = (this.rankTopY[currentRank] + this.rankBottomY[currentRank + 1]) / 2.0;
                    double bottomChannelY = (this.rankTopY[currentRank - 1] + this.rankBottomY[currentRank]) / 2.0;
                    if (reversed) {
                        double tmp = topChannelY;
                        topChannelY = bottomChannelY;
                        bottomChannelY = tmp;
                    }
                    if (this.orientation == 1 || this.orientation == 5) {
                        newPoints.add(new mxPoint(positionX, topChannelY));
                        newPoints.add(new mxPoint(positionX, bottomChannelY));
                    } else {
                        newPoints.add(new mxPoint(topChannelY, positionX));
                        newPoints.add(new mxPoint(bottomChannelY, positionX));
                    }
                    this.limitX = Math.max(this.limitX, positionX);
                    currentRank += loopDelta;
                }
                if (jettys != null) {
                    int arrayOffset;
                    int n = arrayOffset = reversed ? 2 : 0;
                    double rankY = reversed ? (layoutReversed ? this.rankTopY[maxRank] : this.rankBottomY[maxRank]) : (layoutReversed ? this.rankBottomY[minRank] : this.rankTopY[minRank]);
                    double jetty = jettys[parallelEdgeCount * 4 + 3 - arrayOffset];
                    if (reversed != layoutReversed) {
                        jetty = -jetty;
                    }
                    double y = rankY - jetty;
                    double x = jettys[parallelEdgeCount * 4 + 2 - arrayOffset];
                    if (this.orientation == 1 || this.orientation == 5) {
                        newPoints.add(new mxPoint(x, y));
                    } else {
                        newPoints.add(new mxPoint(y, x));
                    }
                }
                if (edge.isReversed()) {
                    this.processReversedEdge(edge, realEdge);
                }
                this.layout.setEdgePoints(realEdge, newPoints);
                offsetX = offsetX == 0.0 ? this.parallelEdgeSpacing : (offsetX > 0.0 ? -offsetX : -offsetX + this.parallelEdgeSpacing);
                ++parallelEdgeCount;
            }
            edge.temp[0] = 101207;
        }
    }

    protected void setVertexLocation(mxGraphAbstractHierarchyCell cell) {
        mxGraphHierarchyNode node = (mxGraphHierarchyNode)cell;
        Object realCell = node.cell;
        double positionX = node.x[0] - node.width / 2.0;
        double positionY = node.y[0] - node.height / 2.0;
        this.rankTopY[cell.minRank] = Math.min(this.rankTopY[cell.minRank], positionY);
        this.rankBottomY[cell.minRank] = Math.max(this.rankBottomY[cell.minRank], positionY + node.height);
        if (this.orientation == 1 || this.orientation == 5) {
            this.layout.setVertexLocation(realCell, positionX, positionY);
        } else {
            this.layout.setVertexLocation(realCell, positionY, positionX);
        }
        this.limitX = Math.max(this.limitX, positionX + node.width);
    }

    protected void processReversedEdge(mxGraphHierarchyEdge edge, Object realEdge) {
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double interRankCellSpacing) {
        this.interRankCellSpacing = interRankCellSpacing;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double intraCellSpacing) {
        this.intraCellSpacing = intraCellSpacing;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public double getLimitX() {
        return this.limitX;
    }

    public void setLimitX(double limitX) {
        this.limitX = limitX;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean fineTuning) {
        this.fineTuning = fineTuning;
    }

    public void setLoggerLevel(Level level) {
        try {
            logger.setLevel(level);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected class AreaSpatialCache
    extends Rectangle2D.Double {
        public Set<Object> cells = new HashSet<Object>();

        protected AreaSpatialCache() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WeightedCellSorter
    implements Comparable<Object> {
        public int weightedValue = 0;
        public boolean nudge = false;
        public boolean visited = false;
        public int rankIndex;
        public mxGraphAbstractHierarchyCell cell = null;

        public WeightedCellSorter() {
            this(null, 0);
        }

        public WeightedCellSorter(mxGraphAbstractHierarchyCell cell, int weightedValue) {
            this.cell = cell;
            this.weightedValue = weightedValue;
        }

        @Override
        public int compareTo(Object arg0) {
            if (arg0 instanceof WeightedCellSorter) {
                if (this.weightedValue > ((WeightedCellSorter)arg0).weightedValue) {
                    return -1;
                }
                if (this.weightedValue < ((WeightedCellSorter)arg0).weightedValue) {
                    return 1;
                }
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HierarchicalEdgeStyle {
        ORTHOGONAL,
        POLYLINE,
        STRAIGHT;

    }
}

