/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxBase64;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxSvgCanvas
extends mxBasicCanvas {
    protected Document document;
    private Map<String, Element> gradients = new Hashtable<String, Element>();
    private Map<String, Element> images = new Hashtable<String, Element>();
    protected Element defs = null;
    protected boolean embedded = false;

    public mxSvgCanvas() {
        this(null);
    }

    public mxSvgCanvas(Document document) {
        this.setDocument(document);
    }

    public void appendSvgElement(Element node) {
        if (this.document != null) {
            this.document.getDocumentElement().appendChild(node);
        }
    }

    protected Element getDefsElement() {
        if (this.defs == null) {
            this.defs = this.document.createElement("defs");
            Element svgNode = this.document.getDocumentElement();
            if (svgNode.hasChildNodes()) {
                svgNode.insertBefore(this.defs, svgNode.getFirstChild());
            } else {
                svgNode.appendChild(this.defs);
            }
        }
        return this.defs;
    }

    public Element getGradientElement(String start, String end, String direction) {
        String id = this.getGradientId(start, end, direction);
        Element gradient = this.gradients.get(id);
        if (gradient == null) {
            gradient = this.createGradientElement(start, end, direction);
            gradient.setAttribute("id", "g" + (this.gradients.size() + 1));
            this.getDefsElement().appendChild(gradient);
            this.gradients.put(id, gradient);
        }
        return gradient;
    }

    public Element getGlassGradientElement() {
        String id = "mx-glass-gradient";
        Element glassGradient = this.gradients.get(id);
        if (glassGradient == null) {
            glassGradient = this.document.createElement("linearGradient");
            glassGradient.setAttribute("x1", "0%");
            glassGradient.setAttribute("y1", "0%");
            glassGradient.setAttribute("x2", "0%");
            glassGradient.setAttribute("y2", "100%");
            Element stop1 = this.document.createElement("stop");
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:#ffffff;stop-opacity:0.9");
            glassGradient.appendChild(stop1);
            Element stop2 = this.document.createElement("stop");
            stop2.setAttribute("offset", "100%");
            stop2.setAttribute("style", "stop-color:#ffffff;stop-opacity:0.1");
            glassGradient.appendChild(stop2);
            glassGradient.setAttribute("id", "g" + (this.gradients.size() + 1));
            this.getDefsElement().appendChild(glassGradient);
            this.gradients.put(id, glassGradient);
        }
        return glassGradient;
    }

    protected Element createGradientElement(String start, String end, String direction) {
        Element gradient = this.document.createElement("linearGradient");
        gradient.setAttribute("x1", "0%");
        gradient.setAttribute("y1", "0%");
        gradient.setAttribute("x2", "0%");
        gradient.setAttribute("y2", "0%");
        if (direction == null || direction.equals("south")) {
            gradient.setAttribute("y2", "100%");
        } else if (direction.equals("east")) {
            gradient.setAttribute("x2", "100%");
        } else if (direction.equals("north")) {
            gradient.setAttribute("y1", "100%");
        } else if (direction.equals("west")) {
            gradient.setAttribute("x1", "100%");
        }
        Element stop = this.document.createElement("stop");
        stop.setAttribute("offset", "0%");
        stop.setAttribute("style", "stop-color:" + start);
        gradient.appendChild(stop);
        stop = this.document.createElement("stop");
        stop.setAttribute("offset", "100%");
        stop.setAttribute("style", "stop-color:" + end);
        gradient.appendChild(stop);
        return gradient;
    }

    public String getGradientId(String start, String end, String direction) {
        if (start.startsWith("#")) {
            start = start.substring(1);
        }
        if (end.startsWith("#")) {
            end = end.substring(1);
        }
        start = start.toLowerCase();
        end = end.toLowerCase();
        String dir = null;
        if (direction == null || direction.equals("south")) {
            dir = "south";
        } else if (direction.equals("east")) {
            dir = "east";
        } else {
            String tmp = start;
            start = end;
            end = tmp;
            if (direction.equals("north")) {
                dir = "south";
            } else if (direction.equals("west")) {
                dir = "east";
            }
        }
        return "mx-gradient-" + start + "-" + end + "-" + dir;
    }

    protected boolean isImageResource(String src) {
        return src != null && (src.toLowerCase().endsWith(".png") || src.toLowerCase().endsWith(".jpg") || src.toLowerCase().endsWith(".gif"));
    }

    protected InputStream getResource(String src) {
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new URL(src).openStream());
        }
        catch (Exception e1) {
            stream = this.getClass().getResourceAsStream(src);
        }
        return stream;
    }

    protected String createDataUrl(String src) throws IOException {
        InputStream inputStream;
        String result = null;
        InputStream inputStream2 = inputStream = this.isImageResource(src) ? this.getResource(src) : null;
        if (inputStream != null) {
            int readBytes;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
            byte[] bytes = new byte[512];
            while ((readBytes = inputStream.read(bytes)) > 0) {
                outputStream.write(bytes, 0, readBytes);
            }
            String format = "png";
            int dot = src.lastIndexOf(46);
            if (dot > 0 && dot < src.length()) {
                format = src.substring(dot + 1);
            }
            result = "data:image/" + format + ";base64," + mxBase64.encodeToString(outputStream.toByteArray(), false);
        }
        return result;
    }

    protected Element getEmbeddedImageElement(String src) {
        Element img = this.images.get(src);
        if (img == null) {
            img = this.document.createElement("svg");
            img.setAttribute("width", "100%");
            img.setAttribute("height", "100%");
            Element inner = this.document.createElement("image");
            inner.setAttribute("width", "100%");
            inner.setAttribute("height", "100%");
            this.images.put(src, img);
            if (!src.startsWith("data:image/")) {
                try {
                    String tmp = this.createDataUrl(src);
                    if (tmp != null) {
                        src = tmp;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            inner.setAttributeNS(mxConstants.NS_XLINK, "xlink:href", src);
            img.appendChild(inner);
            img.setAttribute("id", "i" + this.images.size());
            this.getDefsElement().appendChild(img);
        }
        return img;
    }

    protected Element createImageElement(double x, double y, double w, double h, String src, boolean aspect, boolean flipH, boolean flipV, boolean embedded) {
        Element elem = null;
        if (embedded) {
            elem = this.document.createElement("use");
            Element img = this.getEmbeddedImageElement(src);
            elem.setAttributeNS(mxConstants.NS_XLINK, "xlink:href", "#" + img.getAttribute("id"));
        } else {
            elem = this.document.createElement("image");
            elem.setAttributeNS(mxConstants.NS_XLINK, "xlink:href", src);
        }
        elem.setAttribute("x", String.valueOf(x));
        elem.setAttribute("y", String.valueOf(y));
        elem.setAttribute("width", String.valueOf(w));
        elem.setAttribute("height", String.valueOf(h));
        if (aspect) {
            elem.setAttribute("preserveAspectRatio", "xMidYMid");
        } else {
            elem.setAttribute("preserveAspectRatio", "none");
        }
        double sx = 1.0;
        double sy = 1.0;
        double dx = 0.0;
        double dy = 0.0;
        if (flipH) {
            sx *= -1.0;
            dx = -w - 2.0 * x;
        }
        if (flipV) {
            sy *= -1.0;
            dy = -h - 2.0 * y;
        }
        String transform = "";
        if (sx != 1.0 || sy != 1.0) {
            transform = transform + "scale(" + sx + " " + sy + ") ";
        }
        if (dx != 0.0 || dy != 0.0) {
            transform = transform + "translate(" + dx + " " + dy + ") ";
        }
        if (transform.length() > 0) {
            elem.setAttribute("transform", transform);
        }
        return elem;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setEmbedded(boolean value) {
        this.embedded = value;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    @Override
    public Object drawCell(mxCellState state) {
        Map<String, Object> style = state.getStyle();
        Element elem = null;
        if (state.getAbsolutePointCount() > 1) {
            List<mxPoint> pts = state.getAbsolutePoints();
            pts = mxUtils.translatePoints(pts, this.translate.x, this.translate.y);
            elem = this.drawLine(pts, style);
            float opacity = mxUtils.getFloat(style, mxConstants.STYLE_OPACITY, 100.0f);
            if (opacity != 100.0f) {
                String value = String.valueOf(opacity / 100.0f);
                elem.setAttribute("fill-opacity", value);
                elem.setAttribute("stroke-opacity", value);
            }
        } else {
            int x = (int)state.getX() + this.translate.x;
            int y = (int)state.getY() + this.translate.y;
            int w = (int)state.getWidth();
            int h = (int)state.getHeight();
            if (!mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                elem = this.drawShape(x, y, w, h, style);
            } else {
                int start = (int)Math.round((double)mxUtils.getInt(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * this.scale);
                Hashtable<String, Object> cloned = new Hashtable<String, Object>(style);
                cloned.remove(mxConstants.STYLE_FILLCOLOR);
                cloned.remove(mxConstants.STYLE_ROUNDED);
                if (mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
                    elem = this.drawShape(x, y, w, start, style);
                    this.drawShape(x, y + start, w, h - start, cloned);
                } else {
                    elem = this.drawShape(x, y, start, h, style);
                    this.drawShape(x + start, y, w - start, h, cloned);
                }
            }
        }
        return elem;
    }

    @Override
    public Object drawLabel(String label, mxCellState state, boolean html) {
        mxRectangle bounds = state.getLabelBounds();
        if (this.drawLabels && bounds != null) {
            int x = (int)bounds.getX() + this.translate.x;
            int y = (int)bounds.getY() + this.translate.y;
            int w = (int)bounds.getWidth();
            int h = (int)bounds.getHeight();
            Map<String, Object> style = state.getStyle();
            return this.drawText(label, x, y, w, h, style);
        }
        return null;
    }

    public Element drawShape(int x, int y, int w, int h, Map<String, Object> style) {
        String fillColor = mxUtils.getString(style, mxConstants.STYLE_FILLCOLOR, "none");
        String gradientColor = mxUtils.getString(style, mxConstants.STYLE_GRADIENTCOLOR, "none");
        String strokeColor = mxUtils.getString(style, mxConstants.STYLE_STROKECOLOR, "none");
        float strokeWidth = (float)((double)mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        float opacity = mxUtils.getFloat(style, mxConstants.STYLE_OPACITY, 100.0f);
        String shape = mxUtils.getString(style, mxConstants.STYLE_SHAPE, "");
        Element elem = null;
        Element background = null;
        if (shape.equals("image")) {
            String img = this.getImageForStyle(style);
            if (img != null) {
                boolean flipH = mxUtils.isTrue(style, mxConstants.STYLE_IMAGE_FLIPH, false);
                boolean flipV = mxUtils.isTrue(style, mxConstants.STYLE_IMAGE_FLIPV, false);
                elem = this.createImageElement(x, y, w, h, img, PRESERVE_IMAGE_ASPECT, flipH, flipV, this.isEmbedded());
            }
        } else if (shape.equals("line")) {
            int mid;
            String direction = mxUtils.getString(style, mxConstants.STYLE_DIRECTION, "east");
            String d = null;
            if (direction.equals("east") || direction.equals("west")) {
                mid = y + h / 2;
                d = "M " + x + " " + mid + " L " + (x + w) + " " + mid;
            } else {
                mid = x + w / 2;
                d = "M " + mid + " " + y + " L " + mid + " " + (y + h);
            }
            elem = this.document.createElement("path");
            elem.setAttribute("d", d + " Z");
        } else if (shape.equals("ellipse")) {
            elem = this.document.createElement("ellipse");
            elem.setAttribute("cx", String.valueOf(x + w / 2));
            elem.setAttribute("cy", String.valueOf(y + h / 2));
            elem.setAttribute("rx", String.valueOf(w / 2));
            elem.setAttribute("ry", String.valueOf(h / 2));
        } else if (shape.equals("doubleEllipse")) {
            elem = this.document.createElement("g");
            background = this.document.createElement("ellipse");
            background.setAttribute("cx", String.valueOf(x + w / 2));
            background.setAttribute("cy", String.valueOf(y + h / 2));
            background.setAttribute("rx", String.valueOf(w / 2));
            background.setAttribute("ry", String.valueOf(h / 2));
            elem.appendChild(background);
            int inset = (int)((double)(3.0f + strokeWidth) * this.scale);
            Element foreground = this.document.createElement("ellipse");
            foreground.setAttribute("fill", "none");
            foreground.setAttribute("stroke", strokeColor);
            foreground.setAttribute("stroke-width", String.valueOf(strokeWidth));
            foreground.setAttribute("cx", String.valueOf(x + w / 2));
            foreground.setAttribute("cy", String.valueOf(y + h / 2));
            foreground.setAttribute("rx", String.valueOf(w / 2 - inset));
            foreground.setAttribute("ry", String.valueOf(h / 2 - inset));
            elem.appendChild(foreground);
        } else if (shape.equals("rhombus")) {
            elem = this.document.createElement("path");
            String d = "M " + (x + w / 2) + " " + y + " L " + (x + w) + " " + (y + h / 2) + " L " + (x + w / 2) + " " + (y + h) + " L " + x + " " + (y + h / 2);
            elem.setAttribute("d", d + " Z");
        } else if (shape.equals("triangle")) {
            elem = this.document.createElement("path");
            String direction = mxUtils.getString(style, mxConstants.STYLE_DIRECTION, "");
            String d = null;
            d = direction.equals("north") ? "M " + x + " " + (y + h) + " L " + (x + w / 2) + " " + y + " L " + (x + w) + " " + (y + h) : (direction.equals("south") ? "M " + x + " " + y + " L " + (x + w / 2) + " " + (y + h) + " L " + (x + w) + " " + y : (direction.equals("west") ? "M " + (x + w) + " " + y + " L " + x + " " + (y + h / 2) + " L " + (x + w) + " " + (y + h) : "M " + x + " " + y + " L " + (x + w) + " " + (y + h / 2) + " L " + x + " " + (y + h)));
            elem.setAttribute("d", d + " Z");
        } else if (shape.equals("hexagon")) {
            elem = this.document.createElement("path");
            String direction = mxUtils.getString(style, mxConstants.STYLE_DIRECTION, "");
            String d = null;
            d = direction.equals("north") || direction.equals("south") ? "M " + ((double)x + 0.5 * (double)w) + " " + y + " L " + (x + w) + " " + ((double)y + 0.25 * (double)h) + " L " + (x + w) + " " + ((double)y + 0.75 * (double)h) + " L " + ((double)x + 0.5 * (double)w) + " " + (y + h) + " L " + x + " " + ((double)y + 0.75 * (double)h) + " L " + x + " " + ((double)y + 0.25 * (double)h) : "M " + ((double)x + 0.25 * (double)w) + " " + y + " L " + ((double)x + 0.75 * (double)w) + " " + y + " L " + (x + w) + " " + ((double)y + 0.5 * (double)h) + " L " + ((double)x + 0.75 * (double)w) + " " + (y + h) + " L " + ((double)x + 0.25 * (double)w) + " " + (y + h) + " L " + x + " " + ((double)y + 0.5 * (double)h);
            elem.setAttribute("d", d + " Z");
        } else if (shape.equals("cloud")) {
            elem = this.document.createElement("path");
            String d = "M " + ((double)x + 0.25 * (double)w) + " " + ((double)y + 0.25 * (double)h) + " C " + ((double)x + 0.05 * (double)w) + " " + ((double)y + 0.25 * (double)h) + " " + x + " " + ((double)y + 0.5 * (double)h) + " " + ((double)x + 0.16 * (double)w) + " " + ((double)y + 0.55 * (double)h) + " C " + x + " " + ((double)y + 0.66 * (double)h) + " " + ((double)x + 0.18 * (double)w) + " " + ((double)y + 0.9 * (double)h) + " " + ((double)x + 0.31 * (double)w) + " " + ((double)y + 0.8 * (double)h) + " C " + ((double)x + 0.4 * (double)w) + " " + (y + h) + " " + ((double)x + 0.7 * (double)w) + " " + (y + h) + " " + ((double)x + 0.8 * (double)w) + " " + ((double)y + 0.8 * (double)h) + " C " + (x + w) + " " + ((double)y + 0.8 * (double)h) + " " + (x + w) + " " + ((double)y + 0.6 * (double)h) + " " + ((double)x + 0.875 * (double)w) + " " + ((double)y + 0.5 * (double)h) + " C " + (x + w) + " " + ((double)y + 0.3 * (double)h) + " " + ((double)x + 0.8 * (double)w) + " " + ((double)y + 0.1 * (double)h) + " " + ((double)x + 0.625 * (double)w) + " " + ((double)y + 0.2 * (double)h) + " C " + ((double)x + 0.5 * (double)w) + " " + ((double)y + 0.05 * (double)h) + " " + ((double)x + 0.3 * (double)w) + " " + ((double)y + 0.05 * (double)h) + " " + ((double)x + 0.25 * (double)w) + " " + ((double)y + 0.25 * (double)h);
            elem.setAttribute("d", d + " Z");
        } else if (shape.equals("actor")) {
            elem = this.document.createElement("path");
            double width3 = w / 3;
            String d = " M " + x + " " + (y + h) + " C " + x + " " + (y + 3 * h / 5) + " " + x + " " + (y + 2 * h / 5) + " " + (x + w / 2) + " " + (y + 2 * h / 5) + " C " + ((double)(x + w / 2) - width3) + " " + (y + 2 * h / 5) + " " + ((double)(x + w / 2) - width3) + " " + y + " " + (x + w / 2) + " " + y + " C " + ((double)(x + w / 2) + width3) + " " + y + " " + ((double)(x + w / 2) + width3) + " " + (y + 2 * h / 5) + " " + (x + w / 2) + " " + (y + 2 * h / 5) + " C " + (x + w) + " " + (y + 2 * h / 5) + " " + (x + w) + " " + (y + 3 * h / 5) + " " + (x + w) + " " + (y + h);
            elem.setAttribute("d", d + " Z");
        } else if (shape.equals("cylinder")) {
            elem = this.document.createElement("g");
            background = this.document.createElement("path");
            double dy = Math.min(40.0, Math.floor(h / 5));
            String d = " M " + x + " " + ((double)y + dy) + " C " + x + " " + ((double)y - dy / 3.0) + " " + (x + w) + " " + ((double)y - dy / 3.0) + " " + (x + w) + " " + ((double)y + dy) + " L " + (x + w) + " " + ((double)(y + h) - dy) + " C " + (x + w) + " " + ((double)(y + h) + dy / 3.0) + " " + x + " " + ((double)(y + h) + dy / 3.0) + " " + x + " " + ((double)(y + h) - dy);
            background.setAttribute("d", d + " Z");
            elem.appendChild(background);
            Element foreground = this.document.createElement("path");
            d = "M " + x + " " + ((double)y + dy) + " C " + x + " " + ((double)y + 2.0 * dy) + " " + (x + w) + " " + ((double)y + 2.0 * dy) + " " + (x + w) + " " + ((double)y + dy);
            foreground.setAttribute("d", d);
            foreground.setAttribute("fill", "none");
            foreground.setAttribute("stroke", strokeColor);
            foreground.setAttribute("stroke-width", String.valueOf(strokeWidth));
            elem.appendChild(foreground);
        } else {
            elem = background = this.document.createElement("rect");
            elem.setAttribute("x", String.valueOf(x));
            elem.setAttribute("y", String.valueOf(y));
            elem.setAttribute("width", String.valueOf(w));
            elem.setAttribute("height", String.valueOf(h));
            if (mxUtils.isTrue(style, mxConstants.STYLE_ROUNDED, false)) {
                String r = String.valueOf(Math.min((double)w * mxConstants.RECTANGLE_ROUNDING_FACTOR, (double)h * mxConstants.RECTANGLE_ROUNDING_FACTOR));
                elem.setAttribute("rx", r);
                elem.setAttribute("ry", r);
            }
            if (shape.equals("label")) {
                String img = this.getImageForStyle(style);
                if (img != null) {
                    String imgAlign = mxUtils.getString(style, mxConstants.STYLE_IMAGE_ALIGN, "left");
                    String imgValign = mxUtils.getString(style, mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, "middle");
                    int imgWidth = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE) * this.scale);
                    int imgHeight = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE) * this.scale);
                    int spacing = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING, 2) * this.scale);
                    mxRectangle imageBounds = new mxRectangle(x, y, w, h);
                    if (imgAlign.equals("center")) {
                        imageBounds.setX(imageBounds.getX() + (imageBounds.getWidth() - (double)imgWidth) / 2.0);
                    } else if (imgAlign.equals("right")) {
                        imageBounds.setX(imageBounds.getX() + imageBounds.getWidth() - (double)imgWidth - (double)spacing - 2.0);
                    } else {
                        imageBounds.setX(imageBounds.getX() + (double)spacing + 4.0);
                    }
                    if (imgValign.equals("top")) {
                        imageBounds.setY(imageBounds.getY() + (double)spacing);
                    } else if (imgValign.equals("bottom")) {
                        imageBounds.setY(imageBounds.getY() + imageBounds.getHeight() - (double)imgHeight - (double)spacing);
                    } else {
                        imageBounds.setY(imageBounds.getY() + (imageBounds.getHeight() - (double)imgHeight) / 2.0);
                    }
                    imageBounds.setWidth(imgWidth);
                    imageBounds.setHeight(imgHeight);
                    elem = this.document.createElement("g");
                    elem.appendChild(background);
                    Element imageElement = this.createImageElement(imageBounds.getX(), imageBounds.getY(), imageBounds.getWidth(), imageBounds.getHeight(), img, false, false, false, this.isEmbedded());
                    if (opacity != 100.0f) {
                        String value = String.valueOf(opacity / 100.0f);
                        imageElement.setAttribute("opacity", value);
                    }
                    elem.appendChild(imageElement);
                }
                if (mxUtils.isTrue(style, mxConstants.STYLE_GLASS, false)) {
                    double size = 0.4;
                    Element glassOverlay = this.document.createElement("path");
                    glassOverlay.setAttribute("fill", "url(#" + this.getGlassGradientElement().getAttribute("id") + ")");
                    String d = "m " + ((float)x - strokeWidth) + "," + ((float)y - strokeWidth) + " L " + ((float)x - strokeWidth) + "," + ((double)y + (double)h * size) + " Q " + ((double)x + (double)w * 0.5) + "," + ((double)y + (double)h * 0.7) + " " + ((float)(x + w) + strokeWidth) + "," + ((double)y + (double)h * size) + " L " + ((float)(x + w) + strokeWidth) + "," + ((float)y - strokeWidth) + " z";
                    glassOverlay.setAttribute("stroke-width", String.valueOf(strokeWidth / 2.0f));
                    glassOverlay.setAttribute("d", d);
                    elem.appendChild(glassOverlay);
                }
            }
        }
        double rotation = mxUtils.getDouble(style, mxConstants.STYLE_ROTATION);
        int cx = x + w / 2;
        int cy = y + h / 2;
        Element bg = background;
        if (bg == null) {
            bg = elem;
        }
        if (!bg.getNodeName().equalsIgnoreCase("use") && !bg.getNodeName().equalsIgnoreCase("image")) {
            if (!fillColor.equalsIgnoreCase("none") && !gradientColor.equalsIgnoreCase("none")) {
                String direction = mxUtils.getString(style, mxConstants.STYLE_GRADIENT_DIRECTION);
                Element gradient = this.getGradientElement(fillColor, gradientColor, direction);
                if (gradient != null) {
                    bg.setAttribute("fill", "url(#" + gradient.getAttribute("id") + ")");
                }
            } else {
                bg.setAttribute("fill", fillColor);
            }
            bg.setAttribute("stroke", strokeColor);
            bg.setAttribute("stroke-width", String.valueOf(strokeWidth));
            Element shadowElement = null;
            if (mxUtils.isTrue(style, mxConstants.STYLE_SHADOW, false) && !fillColor.equals("none")) {
                shadowElement = (Element)bg.cloneNode(true);
                shadowElement.setAttribute("transform", mxConstants.SVG_SHADOWTRANSFORM);
                shadowElement.setAttribute("fill", mxConstants.W3C_SHADOWCOLOR);
                shadowElement.setAttribute("stroke", mxConstants.W3C_SHADOWCOLOR);
                shadowElement.setAttribute("stroke-width", String.valueOf(strokeWidth));
                if (rotation != 0.0) {
                    shadowElement.setAttribute("transform", "rotate(" + rotation + "," + cx + "," + cy + ") " + mxConstants.SVG_SHADOWTRANSFORM);
                }
                if (opacity != 100.0f) {
                    String value = String.valueOf(opacity / 100.0f);
                    shadowElement.setAttribute("fill-opacity", value);
                    shadowElement.setAttribute("stroke-opacity", value);
                }
                this.appendSvgElement(shadowElement);
            }
        }
        if (rotation != 0.0) {
            elem.setAttribute("transform", elem.getAttribute("transform") + " rotate(" + rotation + "," + cx + "," + cy + ")");
        }
        if (opacity != 100.0f) {
            String value = String.valueOf(opacity / 100.0f);
            elem.setAttribute("fill-opacity", value);
            elem.setAttribute("stroke-opacity", value);
        }
        if (mxUtils.isTrue(style, mxConstants.STYLE_DASHED)) {
            String pattern = mxUtils.getString(style, mxConstants.STYLE_DASH_PATTERN, "3, 3");
            elem.setAttribute("stroke-dasharray", pattern);
        }
        this.appendSvgElement(elem);
        return elem;
    }

    public Element drawLine(List<mxPoint> pts, Map<String, Object> style) {
        Element group = this.document.createElement("g");
        Element path = this.document.createElement("path");
        boolean rounded = mxUtils.isTrue(style, mxConstants.STYLE_ROUNDED, false);
        String strokeColor = mxUtils.getString(style, mxConstants.STYLE_STROKECOLOR);
        float tmpStroke = mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1.0f);
        float strokeWidth = (float)((double)tmpStroke * this.scale);
        if (strokeColor != null && strokeWidth > 0.0f) {
            Object marker = style.get(mxConstants.STYLE_STARTARROW);
            mxPoint pt = pts.get(1);
            mxPoint p0 = pts.get(0);
            mxPoint offset = null;
            if (marker != null) {
                float size = mxUtils.getFloat(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_MARKERSIZE);
                offset = this.drawMarker(group, marker, pt, p0, size, tmpStroke, strokeColor);
            } else {
                double dx = pt.getX() - p0.getX();
                double dy = pt.getY() - p0.getY();
                double dist = Math.max(1.0, Math.sqrt(dx * dx + dy * dy));
                double nx = dx * (double)strokeWidth / dist;
                double ny = dy * (double)strokeWidth / dist;
                offset = new mxPoint(nx / 2.0, ny / 2.0);
            }
            if (offset != null) {
                p0 = (mxPoint)p0.clone();
                p0.setX(p0.getX() + offset.getX());
                p0.setY(p0.getY() + offset.getY());
                offset = null;
            }
            marker = style.get(mxConstants.STYLE_ENDARROW);
            pt = pts.get(pts.size() - 2);
            mxPoint pe = pts.get(pts.size() - 1);
            if (marker != null) {
                float size = mxUtils.getFloat(style, mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE);
                offset = this.drawMarker(group, marker, pt, pe, size, tmpStroke, strokeColor);
            } else {
                double dx = pt.getX() - p0.getX();
                double dy = pt.getY() - p0.getY();
                double dist = Math.max(1.0, Math.sqrt(dx * dx + dy * dy));
                double nx = dx * (double)strokeWidth / dist;
                double ny = dy * (double)strokeWidth / dist;
                offset = new mxPoint(nx / 2.0, ny / 2.0);
            }
            if (offset != null) {
                pe = (mxPoint)pe.clone();
                pe.setX(pe.getX() + offset.getX());
                pe.setY(pe.getY() + offset.getY());
                offset = null;
            }
            double arcSize = mxConstants.LINE_ARCSIZE * this.scale;
            pt = p0;
            String d = "M " + pt.getX() + " " + pt.getY();
            for (int i = 1; i < pts.size() - 1; ++i) {
                mxPoint tmp = pts.get(i);
                double dx = pt.getX() - tmp.getX();
                double dy = pt.getY() - tmp.getY();
                if (rounded && i < pts.size() - 1 && (dx != 0.0 || dy != 0.0)) {
                    double dist = Math.sqrt(dx * dx + dy * dy);
                    double nx1 = dx * Math.min(arcSize, dist / 2.0) / dist;
                    double ny1 = dy * Math.min(arcSize, dist / 2.0) / dist;
                    double x1 = tmp.getX() + nx1;
                    double y1 = tmp.getY() + ny1;
                    d = d + " L " + x1 + " " + y1;
                    mxPoint next = pts.get(i + 1);
                    dx = next.getX() - tmp.getX();
                    dy = next.getY() - tmp.getY();
                    dist = Math.max(1.0, Math.sqrt(dx * dx + dy * dy));
                    double nx2 = dx * Math.min(arcSize, dist / 2.0) / dist;
                    double ny2 = dy * Math.min(arcSize, dist / 2.0) / dist;
                    double x2 = tmp.getX() + nx2;
                    double y2 = tmp.getY() + ny2;
                    d = d + " Q " + tmp.getX() + " " + tmp.getY() + " " + x2 + " " + y2;
                    tmp = new mxPoint(x2, y2);
                } else {
                    d = d + " L " + tmp.getX() + " " + tmp.getY();
                }
                pt = tmp;
            }
            d = d + " L " + pe.getX() + " " + pe.getY();
            path.setAttribute("d", d);
            path.setAttribute("stroke", strokeColor);
            path.setAttribute("fill", "none");
            path.setAttribute("stroke-width", String.valueOf(strokeWidth));
            if (mxUtils.isTrue(style, mxConstants.STYLE_DASHED)) {
                String pattern = mxUtils.getString(style, mxConstants.STYLE_DASH_PATTERN, "3, 3");
                path.setAttribute("stroke-dasharray", pattern);
            }
            group.appendChild(path);
            this.appendSvgElement(group);
        }
        return group;
    }

    public mxPoint drawMarker(Element parent, Object type, mxPoint p0, mxPoint pe, float size, float strokeWidth, String color) {
        mxPoint offset = null;
        double dx = pe.getX() - p0.getX();
        double dy = pe.getY() - p0.getY();
        double dist = Math.max(1.0, Math.sqrt(dx * dx + dy * dy));
        double absSize = (double)size * this.scale;
        double nx = dx * absSize / dist;
        double ny = dy * absSize / dist;
        pe = (mxPoint)pe.clone();
        pe.setX(pe.getX() - nx * (double)strokeWidth / (double)(2.0f * size));
        pe.setY(pe.getY() - ny * (double)strokeWidth / (double)(2.0f * size));
        nx *= 0.5 + (double)(strokeWidth / 2.0f);
        ny *= 0.5 + (double)(strokeWidth / 2.0f);
        Element path = this.document.createElement("path");
        path.setAttribute("stroke-width", String.valueOf((double)strokeWidth * this.scale));
        path.setAttribute("stroke", color);
        path.setAttribute("fill", color);
        String d = null;
        if (type.equals("classic") || type.equals("block")) {
            d = "M " + pe.getX() + " " + pe.getY() + " L " + (pe.getX() - nx - ny / 2.0) + " " + (pe.getY() - ny + nx / 2.0) + (!type.equals("classic") ? "" : " L " + (pe.getX() - nx * 3.0 / 4.0) + " " + (pe.getY() - ny * 3.0 / 4.0)) + " L " + (pe.getX() + ny / 2.0 - nx) + " " + (pe.getY() - ny - nx / 2.0) + " z";
        } else if (type.equals("open")) {
            d = "M " + (pe.getX() - (nx *= 1.2) - (ny *= 1.2) / 2.0) + " " + (pe.getY() - ny + nx / 2.0) + " L " + (pe.getX() - nx / 6.0) + " " + (pe.getY() - ny / 6.0) + " L " + (pe.getX() + ny / 2.0 - nx) + " " + (pe.getY() - ny - nx / 2.0) + " M " + pe.getX() + " " + pe.getY();
            path.setAttribute("fill", "none");
        } else if (type.equals("oval")) {
            d = "M " + (pe.getX() - (ny *= 1.2) / 2.0) + " " + (pe.getY() + (nx *= 1.2) / 2.0) + " a " + (absSize *= 1.2) / 2.0 + " " + absSize / 2.0 + " 0  1,1 " + nx / 8.0 + " " + ny / 8.0 + " z";
        } else if (type.equals("diamond")) {
            d = "M " + (pe.getX() + nx / 2.0) + " " + (pe.getY() + ny / 2.0) + " L " + (pe.getX() - ny / 2.0) + " " + (pe.getY() + nx / 2.0) + " L " + (pe.getX() - nx / 2.0) + " " + (pe.getY() - ny / 2.0) + " L " + (pe.getX() + ny / 2.0) + " " + (pe.getY() - nx / 2.0) + " z";
        }
        if (d != null) {
            path.setAttribute("d", d);
            parent.appendChild(path);
        }
        return offset;
    }

    public Object drawText(String text, int x, int y, int w, int h, Map<String, Object> style) {
        Element elem = null;
        String fontColor = mxUtils.getString(style, mxConstants.STYLE_FONTCOLOR, "black");
        String fontFamily = mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES);
        int fontSize = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * this.scale);
        if (text != null && text.length() > 0) {
            float strokeWidth = (float)((double)mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
            float opacity = mxUtils.getFloat(style, mxConstants.STYLE_TEXT_OPACITY, 100.0f);
            String bg = mxUtils.getString(style, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
            String border = mxUtils.getString(style, mxConstants.STYLE_LABEL_BORDERCOLOR);
            String transform = null;
            if (!mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
                double cx = x + w / 2;
                double cy = y + h / 2;
                transform = "rotate(270 " + cx + " " + cy + ")";
            }
            if (bg != null || border != null) {
                Element background = this.document.createElement("rect");
                background.setAttribute("x", String.valueOf(x));
                background.setAttribute("y", String.valueOf(y));
                background.setAttribute("width", String.valueOf(w));
                background.setAttribute("height", String.valueOf(h));
                if (bg != null) {
                    background.setAttribute("fill", bg);
                } else {
                    background.setAttribute("fill", "none");
                }
                if (border != null) {
                    background.setAttribute("stroke", border);
                } else {
                    background.setAttribute("stroke", "none");
                }
                background.setAttribute("stroke-width", String.valueOf(strokeWidth));
                if (opacity != 100.0f) {
                    String value = String.valueOf(opacity / 100.0f);
                    background.setAttribute("fill-opacity", value);
                    background.setAttribute("stroke-opacity", value);
                }
                if (transform != null) {
                    background.setAttribute("transform", transform);
                }
                this.appendSvgElement(background);
            }
            elem = this.document.createElement("text");
            int fontStyle = mxUtils.getInt(style, mxConstants.STYLE_FONTSTYLE);
            String weight = (fontStyle & 1) == 1 ? "bold" : "normal";
            elem.setAttribute("font-weight", weight);
            String uline = (fontStyle & 4) == 4 ? "underline" : "none";
            elem.setAttribute("font-decoration", uline);
            if ((fontStyle & 2) == 2) {
                elem.setAttribute("font-style", "italic");
            }
            elem.setAttribute("font-size", String.valueOf(fontSize));
            elem.setAttribute("font-family", fontFamily);
            elem.setAttribute("fill", fontColor);
            if (opacity != 100.0f) {
                String value = String.valueOf(opacity / 100.0f);
                elem.setAttribute("fill-opacity", value);
                elem.setAttribute("stroke-opacity", value);
            }
            int swingFontStyle = (fontStyle & 1) == 1 ? 1 : 0;
            swingFontStyle += (fontStyle & 2) == 2 ? 2 : 0;
            String[] lines = text.split("\n");
            y += fontSize + (h - lines.length * (fontSize + mxConstants.LINESPACING)) / 2 - 2;
            String align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, "center");
            String anchor = "start";
            if (align.equals("right")) {
                anchor = "end";
                x = (int)((double)x + ((double)w - (double)mxConstants.LABEL_INSET * this.scale));
            } else if (align.equals("center")) {
                anchor = "middle";
                x += w / 2;
            } else {
                x = (int)((double)x + (double)mxConstants.LABEL_INSET * this.scale);
            }
            elem.setAttribute("text-anchor", anchor);
            for (int i = 0; i < lines.length; ++i) {
                Element tspan = this.document.createElement("tspan");
                tspan.setAttribute("x", String.valueOf(x));
                tspan.setAttribute("y", String.valueOf(y));
                tspan.appendChild(this.document.createTextNode(lines[i]));
                elem.appendChild(tspan);
                y += fontSize + mxConstants.LINESPACING;
            }
            if (transform != null) {
                elem.setAttribute("transform", transform);
            }
            this.appendSvgElement(elem);
        }
        return elem;
    }
}

