/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxICanvas2D;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLightweightLabel;
import com.mxgraph.util.mxUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;

public class mxGraphicsCanvas2D
implements mxICanvas2D {
    public static int IMAGE_SCALING = 4;
    public static int JAVA_TEXT_WIDTH_DELTA = 2;
    public static int COLOR_CACHE_SIZE = 100;
    protected Graphics2D graphics;
    protected boolean textEnabled = true;
    protected transient CanvasState state = new CanvasState();
    protected transient Stack<CanvasState> stack = new Stack();
    protected transient GeneralPath currentPath;
    protected CellRendererPane rendererPane;
    protected transient Font lastFont = null;
    protected transient int lastFontStyle = 0;
    protected transient int lastFontSize = 0;
    protected transient String lastFontFamily = "";
    protected transient Stroke lastStroke = null;
    protected transient float lastStrokeWidth = 0.0f;
    protected transient int lastCap = 0;
    protected transient int lastJoin = 0;
    protected transient float lastMiterLimit = 0.0f;
    protected transient boolean lastDashed = false;
    protected transient Object lastDashPattern = "";
    protected transient LinkedHashMap<String, Color> colorCache = new LinkedHashMap<String, Color>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Color> eldest) {
            return this.size() > COLOR_CACHE_SIZE;
        }
    };

    public mxGraphicsCanvas2D(Graphics2D g) {
        this.setGraphics(g);
        this.state.g = g;
        try {
            this.rendererPane = new CellRendererPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGraphics(Graphics2D value) {
        this.graphics = value;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public boolean isTextEnabled() {
        return this.textEnabled;
    }

    public void setTextEnabled(boolean value) {
        this.textEnabled = value;
    }

    public void save() {
        this.stack.push(this.state);
        this.state = this.cloneState(this.state);
        this.state.g = (Graphics2D)this.state.g.create();
    }

    public void restore() {
        this.state.g.dispose();
        this.state = this.stack.pop();
    }

    protected CanvasState cloneState(CanvasState state) {
        try {
            return (CanvasState)state.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void scale(double value) {
        this.state.scale *= value;
    }

    public void translate(double dx, double dy) {
        this.state.dx += dx;
        this.state.dy += dy;
    }

    public void rotate(double theta, boolean flipH, boolean flipV, double cx, double cy) {
        cx += this.state.dx;
        cy += this.state.dy;
        this.state.g.rotate(Math.toRadians(theta), cx *= this.state.scale, cy *= this.state.scale);
        if (flipH && flipV) {
            theta += 180.0;
        } else if (flipH ^ flipV) {
            double tx = flipH ? cx : 0.0;
            int sx = flipH ? -1 : 1;
            double ty = flipV ? cy : 0.0;
            int sy = flipV ? -1 : 1;
            this.state.g.translate(tx, ty);
            this.state.g.scale(sx, sy);
            this.state.g.translate(-tx, -ty);
        }
        this.state.theta = theta;
        this.state.rotationCx = cx;
        this.state.rotationCy = cy;
        this.state.flipH = flipH;
        this.state.flipV = flipV;
    }

    public void setStrokeWidth(double value) {
        if (value != this.state.strokeWidth) {
            this.state.strokeWidth = value;
        }
    }

    public void setStrokeColor(String value) {
        if (this.state.strokeColorValue == null || !this.state.strokeColorValue.equals(value)) {
            this.state.strokeColorValue = value;
            this.state.strokeColor = null;
        }
    }

    public void setDashed(boolean value) {
        if (value != this.state.dashed) {
            this.state.dashed = value;
        }
    }

    public void setDashPattern(String value) {
        if (value != null && value.length() > 0) {
            this.state.dashPattern = mxUtils.parseDashPattern(value);
        }
    }

    public void setLineCap(String value) {
        if (!this.state.lineCap.equals(value)) {
            this.state.lineCap = value;
        }
    }

    public void setLineJoin(String value) {
        if (!this.state.lineJoin.equals(value)) {
            this.state.lineJoin = value;
        }
    }

    public void setMiterLimit(double value) {
        if (value != this.state.miterLimit) {
            this.state.miterLimit = value;
        }
    }

    public void setFontSize(double value) {
        if (value != this.state.fontSize) {
            this.state.fontSize = value;
        }
    }

    public void setFontColor(String value) {
        if (this.state.fontColorValue == null || !this.state.fontColorValue.equals(value)) {
            this.state.fontColorValue = value;
            this.state.fontColor = null;
        }
    }

    public void setFontBackgroundColor(String value) {
        if (this.state.fontBackgroundColorValue == null || !this.state.fontBackgroundColorValue.equals(value)) {
            this.state.fontBackgroundColorValue = value;
            this.state.fontBackgroundColor = null;
        }
    }

    public void setFontBorderColor(String value) {
        if (this.state.fontBorderColorValue == null || !this.state.fontBorderColorValue.equals(value)) {
            this.state.fontBorderColorValue = value;
            this.state.fontBorderColor = null;
        }
    }

    public void setFontFamily(String value) {
        if (!this.state.fontFamily.equals(value)) {
            this.state.fontFamily = value;
        }
    }

    public void setFontStyle(int value) {
        if (value != this.state.fontStyle) {
            this.state.fontStyle = value;
        }
    }

    public void setAlpha(double value) {
        if (this.state.alpha != value) {
            this.state.g.setComposite(AlphaComposite.getInstance(3, (float)value));
            this.state.alpha = value;
        }
    }

    public void setFillColor(String value) {
        if (this.state.fillColorValue == null || !this.state.fillColorValue.equals(value)) {
            this.state.fillColorValue = value;
            this.state.fillColor = null;
            this.state.gradientPaint = null;
        }
    }

    public void setGradient(String color1, String color2, double x, double y, double w, double h, String direction, double alpha1, double alpha2) {
        float x1 = (float)((this.state.dx + x) * this.state.scale);
        float y1 = (float)((this.state.dy + y) * this.state.scale);
        float x2 = x1;
        float y2 = y1;
        h *= this.state.scale;
        w *= this.state.scale;
        if (direction == null || direction.length() == 0 || direction.equals("south")) {
            y2 = (float)((double)y1 + h);
        } else if (direction.equals("east")) {
            x2 = (float)((double)x1 + w);
        } else if (direction.equals("north")) {
            y1 = (float)((double)y1 + h);
        } else if (direction.equals("west")) {
            x1 = (float)((double)x1 + w);
        }
        Color c1 = this.parseColor(color1);
        if (alpha1 != 1.0) {
            c1 = new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), (int)(alpha1 * 255.0));
        }
        Color c2 = this.parseColor(color2);
        if (alpha2 != 1.0) {
            c2 = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), (int)(alpha2 * 255.0));
        }
        this.state.gradientPaint = new GradientPaint(x1, y1, c1, x2, y2, c2, true);
        this.state.fillColorValue = null;
    }

    protected Color parseColor(String hex) {
        Color result = this.colorCache.get(hex);
        if (result == null) {
            result = mxUtils.parseColor(hex);
            this.colorCache.put(hex, result);
        }
        return result;
    }

    public void rect(double x, double y, double w, double h) {
        this.currentPath = new GeneralPath();
        this.currentPath.append(new Rectangle2D.Double((this.state.dx + x) * this.state.scale, (this.state.dy + y) * this.state.scale, w * this.state.scale, h * this.state.scale), false);
    }

    public void roundrect(double x, double y, double w, double h, double dx, double dy) {
        this.begin();
        this.moveTo(x + dx, y);
        this.lineTo(x + w - dx, y);
        this.quadTo(x + w, y, x + w, y + dy);
        this.lineTo(x + w, y + h - dy);
        this.quadTo(x + w, y + h, x + w - dx, y + h);
        this.lineTo(x + dx, y + h);
        this.quadTo(x, y + h, x, y + h - dy);
        this.lineTo(x, y + dy);
        this.quadTo(x, y, x + dx, y);
    }

    public void ellipse(double x, double y, double w, double h) {
        this.currentPath = new GeneralPath();
        this.currentPath.append(new Ellipse2D.Double((this.state.dx + x) * this.state.scale, (this.state.dy + y) * this.state.scale, w * this.state.scale, h * this.state.scale), false);
    }

    public void image(double x, double y, double w, double h, String src, boolean aspect, boolean flipH, boolean flipV) {
        Image img;
        if (src != null && w > 0.0 && h > 0.0 && (img = this.loadImage(src)) != null) {
            Rectangle bounds = this.getImageBounds(img, x, y, w, h, aspect);
            if ((img = this.scaleImage(img, bounds.width, bounds.height)) != null) {
                this.drawImage(this.createImageGraphics(bounds.x, bounds.y, bounds.width, bounds.height, flipH, flipV), img, bounds.x, bounds.y);
            }
        }
    }

    protected void drawImage(Graphics2D graphics, Image image, int x, int y) {
        graphics.drawImage(image, x, y, null);
    }

    protected Image loadImage(String src) {
        return mxUtils.loadImage(src);
    }

    protected final Rectangle getImageBounds(Image img, double x, double y, double w, double h, boolean aspect) {
        x = (this.state.dx + x) * this.state.scale;
        y = (this.state.dy + y) * this.state.scale;
        w *= this.state.scale;
        h *= this.state.scale;
        if (aspect) {
            Dimension size = this.getImageSize(img);
            double s = Math.min(w / (double)size.width, h / (double)size.height);
            int sw = (int)Math.round((double)size.width * s);
            int sh = (int)Math.round((double)size.height * s);
            x += (w - (double)sw) / 2.0;
            y += (h - (double)sh) / 2.0;
            w = sw;
            h = sh;
        } else {
            w = Math.round(w);
            h = Math.round(h);
        }
        return new Rectangle((int)x, (int)y, (int)w, (int)h);
    }

    protected Dimension getImageSize(Image image) {
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    protected Image scaleImage(Image img, int w, int h) {
        Dimension size = this.getImageSize(img);
        if (w == size.width && h == size.height) {
            return img;
        }
        return img.getScaledInstance(w, h, IMAGE_SCALING);
    }

    protected final Graphics2D createImageGraphics(double x, double y, double w, double h, boolean flipH, boolean flipV) {
        Graphics2D g2 = this.state.g;
        if (flipH || flipV) {
            g2 = (Graphics2D)g2.create();
            if (flipV && flipH) {
                g2.rotate(Math.toRadians(180.0), x + w / 2.0, y + h / 2.0);
            } else {
                int sx = 1;
                int sy = 1;
                int dx = 0;
                int dy = 0;
                if (flipH) {
                    sx = -1;
                    dx = (int)(-w - 2.0 * x);
                }
                if (flipV) {
                    sy = -1;
                    dy = (int)(-h - 2.0 * y);
                }
                g2.scale(sx, sy);
                g2.translate(dx, dy);
            }
        }
        return g2;
    }

    protected String createHtmlDocument(String text, String align, String valign, int w, int h, boolean wrap, String overflow, boolean clip) {
        StringBuffer css = new StringBuffer();
        css.append("display:inline;");
        css.append("font-family:" + this.state.fontFamily + ";");
        css.append("font-size:" + Math.round(this.state.fontSize) + " pt;");
        css.append("color:" + this.state.fontColorValue + ";");
        css.append("line-height:" + (mxConstants.ABSOLUTE_LINE_HEIGHT ? Math.round(this.state.fontSize * (double)mxConstants.LINE_HEIGHT) + " pt" : Float.valueOf(mxConstants.LINE_HEIGHT)) + ";");
        boolean setWidth = false;
        if ((this.state.fontStyle & 1) == 1) {
            css.append("font-weight:bold;");
        }
        if ((this.state.fontStyle & 2) == 2) {
            css.append("font-style:italic;");
        }
        if ((this.state.fontStyle & 4) == 4) {
            css.append("text-decoration:underline;");
        }
        if (align != null) {
            if (align.equals("center")) {
                css.append("text-align:center;");
            } else if (align.equals("right")) {
                css.append("text-align:right;");
            }
        }
        if (this.state.fontBackgroundColorValue != null) {
            css.append("background-color:" + this.state.fontBackgroundColorValue + ";");
        }
        if (this.state.fontBorderColorValue != null) {
            css.append("border:1pt solid " + this.state.fontBorderColorValue + ";");
        }
        if (clip) {
            css.append("overflow:hidden;");
            setWidth = true;
        } else if (overflow != null) {
            if (overflow.equals("fill")) {
                css.append("height:" + Math.round(h) + "pt;");
                setWidth = true;
            } else if (overflow.equals("width")) {
                setWidth = true;
                if (h > 0) {
                    css.append("height:" + Math.round(h) + "pt;");
                }
            }
        }
        if (wrap) {
            if (!clip) {
                setWidth = true;
            }
            css.append("white-space:normal;");
        } else {
            css.append("white-space:nowrap;");
        }
        if (setWidth && w > 0) {
            css.append("width:" + Math.round(w) + "pt;");
        }
        return this.createHtmlDocument(text, css.toString());
    }

    protected String createHtmlDocument(String text, String style) {
        return "<html><div style=\"" + style + "\">" + text + "</div></html>";
    }

    protected JLabel getTextRenderer() {
        return mxLightweightLabel.getSharedInstance();
    }

    protected Point2D getMargin(String align, String valign) {
        double dx = 0.0;
        double dy = 0.0;
        if (align != null) {
            if (align.equals("center")) {
                dx = -0.5;
            } else if (align.equals("right")) {
                dx = -1.0;
            }
        }
        if (valign != null) {
            if (valign.equals("middle")) {
                dy = -0.5;
            } else if (valign.equals("bottom")) {
                dy = -1.0;
            }
        }
        return new Point2D.Double(dx, dy);
    }

    protected void htmlText(double x, double y, double w, double h, String str, String align, String valign, boolean wrap, String format, String overflow, boolean clip, double rotation) {
        x += this.state.dx;
        y += this.state.dy;
        JLabel textRenderer = this.getTextRenderer();
        if (textRenderer != null && this.rendererPane != null) {
            AffineTransform previous = this.state.g.getTransform();
            this.state.g.scale(this.state.scale, this.state.scale);
            double rad = rotation * (Math.PI / 180);
            this.state.g.rotate(rad, x, y);
            boolean widthFill = false;
            boolean fill = false;
            String original = str;
            if (overflow != null) {
                widthFill = overflow.equals("width");
                fill = overflow.equals("fill");
            }
            str = this.createHtmlDocument(str, align, valign, widthFill || fill ? (int)Math.round(w) : 0, fill ? (int)Math.round(h) : 0, wrap, overflow, clip);
            textRenderer.setText(str);
            Dimension pref = textRenderer.getPreferredSize();
            int prefWidth = pref.width;
            int prefHeight = pref.height;
            if ((clip || wrap) && (double)prefWidth > w && w > 0.0 || clip && (double)prefHeight > h && h > 0.0) {
                int cw = (int)Math.round(w + (double)(wrap ? JAVA_TEXT_WIDTH_DELTA : 0));
                int ch = (int)Math.round(h);
                str = this.createHtmlDocument(original, align, valign, cw, ch, wrap, overflow, clip);
                textRenderer.setText(str);
                pref = textRenderer.getPreferredSize();
                prefWidth = pref.width;
                prefHeight = pref.height + 2;
            }
            if (clip && w > 0.0 && h > 0.0) {
                prefWidth = Math.min(pref.width, (int)w);
                prefHeight = Math.min(prefHeight, (int)h);
                h = prefHeight;
            } else if (!clip && wrap && w > 0.0 && h > 0.0) {
                prefWidth = pref.width;
                w = Math.max(pref.width, (int)w);
                h = prefHeight;
                prefHeight = Math.max(prefHeight, (int)h);
            } else if (!clip && !wrap) {
                if (w > 0.0 && w < (double)prefWidth) {
                    w = prefWidth;
                }
                if (h > 0.0 && h < (double)prefHeight) {
                    h = prefHeight;
                }
            }
            Point2D margin = this.getMargin(align, valign);
            x += margin.getX() * (double)prefWidth;
            y += margin.getY() * (double)prefHeight;
            if (w == 0.0) {
                w = prefWidth;
            }
            if (h == 0.0) {
                h = prefHeight;
            }
            this.rendererPane.paintComponent(this.state.g, textRenderer, this.rendererPane, (int)Math.round(x), (int)Math.round(y), (int)Math.round(w), (int)Math.round(h), true);
            this.state.g.setTransform(previous);
        }
    }

    public void text(double x, double y, double w, double h, String str, String align, String valign, boolean wrap, String format, String overflow, boolean clip, double rotation, String textDirection) {
        if (format != null && format.equals("html")) {
            this.htmlText(x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation);
        } else {
            this.plainText(x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation);
        }
    }

    public void plainText(double x, double y, double w, double h, String str, String align, String valign, boolean wrap, String format, String overflow, boolean clip, double rotation) {
        if (this.state.fontColor == null) {
            this.state.fontColor = this.parseColor(this.state.fontColorValue);
        }
        if (this.state.fontColor != null) {
            x = (this.state.dx + x) * this.state.scale;
            y = (this.state.dy + y) * this.state.scale;
            Graphics2D g2 = this.createTextGraphics(x, y, w *= this.state.scale, h *= this.state.scale, rotation, clip, align, valign);
            FontMetrics fm = g2.getFontMetrics();
            String[] lines = str.split("\n");
            int[] stringWidths = new int[lines.length];
            int textWidth = 0;
            for (int i = 0; i < lines.length; ++i) {
                stringWidths[i] = fm.stringWidth(lines[i]);
                textWidth = Math.max(textWidth, stringWidths[i]);
            }
            int textHeight = Math.round((float)lines.length * ((float)fm.getFont().getSize() * mxConstants.LINE_HEIGHT));
            if (clip && (double)textHeight > h && h > 0.0) {
                textHeight = (int)h;
            }
            Point2D margin = this.getMargin(align, valign);
            x += margin.getX() * (double)textWidth;
            y += margin.getY() * (double)textHeight;
            if (this.state.fontBackgroundColorValue != null) {
                if (this.state.fontBackgroundColor == null) {
                    this.state.fontBackgroundColor = this.parseColor(this.state.fontBackgroundColorValue);
                }
                if (this.state.fontBackgroundColor != null) {
                    g2.setColor(this.state.fontBackgroundColor);
                    g2.fillRect((int)Math.round(x), (int)Math.round(y - 1.0), textWidth + 1, textHeight + 2);
                }
            }
            if (this.state.fontBorderColorValue != null) {
                if (this.state.fontBorderColor == null) {
                    this.state.fontBorderColor = this.parseColor(this.state.fontBorderColorValue);
                }
                if (this.state.fontBorderColor != null) {
                    g2.setColor(this.state.fontBorderColor);
                    g2.drawRect((int)Math.round(x), (int)Math.round(y - 1.0), textWidth + 1, textHeight + 2);
                }
            }
            g2.setColor(this.state.fontColor);
            y += (double)(fm.getHeight() - fm.getDescent()) - (margin.getY() + 0.5);
            for (int i = 0; i < lines.length; ++i) {
                double dx = 0.0;
                if (align != null) {
                    if (align.equals("center")) {
                        dx = (textWidth - stringWidths[i]) / 2;
                    } else if (align.equals("right")) {
                        dx = textWidth - stringWidths[i];
                    }
                }
                if (!lines[i].isEmpty()) {
                    if ((this.state.fontStyle & 4) == 4) {
                        AttributedString as = new AttributedString(lines[i]);
                        as.addAttribute(TextAttribute.FONT, g2.getFont());
                        as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                        g2.drawString(as.getIterator(), (int)Math.round(x + dx), (int)Math.round(y));
                    } else {
                        g2.drawString(lines[i], (int)Math.round(x + dx), (int)Math.round(y));
                    }
                }
                y += (double)Math.round((float)fm.getFont().getSize() * mxConstants.LINE_HEIGHT);
            }
        }
    }

    protected final Graphics2D createTextGraphics(double x, double y, double w, double h, double rotation, boolean clip, String align, String valign) {
        Graphics2D g2 = this.state.g;
        this.updateFont();
        if (rotation != 0.0) {
            g2 = (Graphics2D)this.state.g.create();
            double rad = rotation * (Math.PI / 180);
            g2.rotate(rad, x, y);
        }
        if (clip && w > 0.0 && h > 0.0) {
            if (g2 == this.state.g) {
                g2 = (Graphics2D)this.state.g.create();
            }
            Point2D margin = this.getMargin(align, valign);
            g2.clip(new Rectangle2D.Double(x += margin.getX() * w, y += margin.getY() * h, w, h));
        }
        return g2;
    }

    public void begin() {
        this.currentPath = new GeneralPath();
    }

    public void moveTo(double x, double y) {
        if (this.currentPath != null) {
            this.currentPath.moveTo((float)((this.state.dx + x) * this.state.scale), (float)((this.state.dy + y) * this.state.scale));
        }
    }

    public void lineTo(double x, double y) {
        if (this.currentPath != null) {
            this.currentPath.lineTo((float)((this.state.dx + x) * this.state.scale), (float)((this.state.dy + y) * this.state.scale));
        }
    }

    public void quadTo(double x1, double y1, double x2, double y2) {
        if (this.currentPath != null) {
            this.currentPath.quadTo((float)((this.state.dx + x1) * this.state.scale), (float)((this.state.dy + y1) * this.state.scale), (float)((this.state.dx + x2) * this.state.scale), (float)((this.state.dy + y2) * this.state.scale));
        }
    }

    public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (this.currentPath != null) {
            this.currentPath.curveTo((float)((this.state.dx + x1) * this.state.scale), (float)((this.state.dy + y1) * this.state.scale), (float)((this.state.dx + x2) * this.state.scale), (float)((this.state.dy + y2) * this.state.scale), (float)((this.state.dx + x3) * this.state.scale), (float)((this.state.dy + y3) * this.state.scale));
        }
    }

    public void close() {
        if (this.currentPath != null) {
            this.currentPath.closePath();
        }
    }

    public void stroke() {
        this.paintCurrentPath(false, true);
    }

    public void fill() {
        this.paintCurrentPath(true, false);
    }

    public void fillAndStroke() {
        this.paintCurrentPath(true, true);
    }

    protected void paintCurrentPath(boolean filled, boolean stroked) {
        if (this.currentPath != null) {
            if (stroked) {
                if (this.state.strokeColor == null) {
                    this.state.strokeColor = this.parseColor(this.state.strokeColorValue);
                }
                if (this.state.strokeColor != null) {
                    this.updateStroke();
                }
            }
            if (filled && this.state.gradientPaint == null && this.state.fillColor == null) {
                this.state.fillColor = this.parseColor(this.state.fillColorValue);
            }
            if (this.state.shadow) {
                this.paintShadow(filled, stroked);
            }
            if (filled) {
                if (this.state.gradientPaint != null) {
                    this.state.g.setPaint(this.state.gradientPaint);
                    this.state.g.fill(this.currentPath);
                } else {
                    if (this.state.fillColor == null) {
                        this.state.fillColor = this.parseColor(this.state.fillColorValue);
                    }
                    if (this.state.fillColor != null) {
                        this.state.g.setColor(this.state.fillColor);
                        this.state.g.setPaint(null);
                        this.state.g.fill(this.currentPath);
                    }
                }
            }
            if (stroked && this.state.strokeColor != null) {
                this.state.g.setColor(this.state.strokeColor);
                this.state.g.draw(this.currentPath);
            }
        }
    }

    protected void paintShadow(boolean filled, boolean stroked) {
        if (this.state.shadowColor == null) {
            this.state.shadowColor = this.parseColor(this.state.shadowColorValue);
        }
        if (this.state.shadowColor != null) {
            double rad = -this.state.theta * (Math.PI / 180);
            double cos = Math.cos(rad);
            double sin = Math.sin(rad);
            double dx = this.state.shadowOffsetX * this.state.scale;
            double dy = this.state.shadowOffsetY * this.state.scale;
            if (this.state.flipH) {
                dx *= -1.0;
            }
            if (this.state.flipV) {
                dy *= -1.0;
            }
            double tx = dx * cos - dy * sin;
            double ty = dx * sin + dy * cos;
            this.state.g.setColor(this.state.shadowColor);
            this.state.g.translate(tx, ty);
            double alpha = this.state.alpha * this.state.shadowAlpha;
            Composite comp = this.state.g.getComposite();
            this.state.g.setComposite(AlphaComposite.getInstance(3, (float)alpha));
            if (filled && (this.state.gradientPaint != null || this.state.fillColor != null)) {
                this.state.g.fill(this.currentPath);
            }
            if (stroked && this.state.strokeColor != null) {
                this.state.g.draw(this.currentPath);
            }
            this.state.g.translate(-tx, -ty);
            this.state.g.setComposite(comp);
        }
    }

    public void setShadow(boolean value) {
        this.state.shadow = value;
    }

    public void setShadowColor(String value) {
        this.state.shadowColorValue = value;
    }

    public void setShadowAlpha(double value) {
        this.state.shadowAlpha = value;
    }

    public void setShadowOffset(double dx, double dy) {
        this.state.shadowOffsetX = dx;
        this.state.shadowOffsetY = dy;
    }

    protected void updateFont() {
        int size = (int)Math.round(this.state.fontSize * this.state.scale);
        int style = (this.state.fontStyle & 1) == 1 ? 1 : 0;
        if (this.lastFont == null || !this.lastFontFamily.equals(this.state.fontFamily) || size != this.lastFontSize || (style += (this.state.fontStyle & 2) == 2 ? 2 : 0) != this.lastFontStyle) {
            this.lastFont = this.createFont(this.state.fontFamily, style, size);
            this.lastFontFamily = this.state.fontFamily;
            this.lastFontStyle = style;
            this.lastFontSize = size;
        }
        this.state.g.setFont(this.lastFont);
    }

    protected Font createFont(String family, int style, int size) {
        return new Font(this.getFontName(family), style, size);
    }

    protected String getFontName(String family) {
        int comma;
        if (family != null && (comma = family.indexOf(44)) >= 0) {
            family = family.substring(0, comma);
        }
        return family;
    }

    protected void updateStroke() {
        float sw = (float)Math.max(1.0, this.state.strokeWidth * this.state.scale);
        int cap = 0;
        if (this.state.lineCap.equals("round")) {
            cap = 1;
        } else if (this.state.lineCap.equals("square")) {
            cap = 2;
        }
        int join = 0;
        if (this.state.lineJoin.equals("round")) {
            join = 1;
        } else if (this.state.lineJoin.equals("bevel")) {
            join = 2;
        }
        float miterlimit = (float)this.state.miterLimit;
        if (this.lastStroke == null || this.lastStrokeWidth != sw || this.lastCap != cap || this.lastJoin != join || this.lastMiterLimit != miterlimit || this.lastDashed != this.state.dashed || this.state.dashed && this.lastDashPattern != this.state.dashPattern) {
            float[] dash = null;
            if (this.state.dashed) {
                dash = new float[this.state.dashPattern.length];
                for (int i = 0; i < dash.length; ++i) {
                    dash[i] = this.state.dashPattern[i] * sw;
                }
            }
            this.lastStroke = new BasicStroke(sw, cap, join, miterlimit, dash, 0.0f);
            this.lastStrokeWidth = sw;
            this.lastCap = cap;
            this.lastJoin = join;
            this.lastMiterLimit = miterlimit;
            this.lastDashed = this.state.dashed;
            this.lastDashPattern = this.state.dashPattern;
        }
        this.state.g.setStroke(this.lastStroke);
    }

    protected class CanvasState
    implements Cloneable {
        protected double alpha = 1.0;
        protected double scale = 1.0;
        protected double dx = 0.0;
        protected double dy = 0.0;
        protected double theta = 0.0;
        protected double rotationCx = 0.0;
        protected double rotationCy = 0.0;
        protected boolean flipV = false;
        protected boolean flipH = false;
        protected double miterLimit = 10.0;
        protected int fontStyle = 0;
        protected double fontSize = mxConstants.DEFAULT_FONTSIZE;
        protected String fontFamily = mxConstants.DEFAULT_FONTFAMILIES;
        protected String fontColorValue = "#000000";
        protected Color fontColor;
        protected String fontBackgroundColorValue;
        protected Color fontBackgroundColor;
        protected String fontBorderColorValue;
        protected Color fontBorderColor;
        protected String lineCap = "flat";
        protected String lineJoin = "miter";
        protected double strokeWidth = 1.0;
        protected String strokeColorValue;
        protected Color strokeColor;
        protected String fillColorValue;
        protected Color fillColor;
        protected Paint gradientPaint;
        protected boolean dashed = false;
        protected float[] dashPattern = new float[]{3.0f, 3.0f};
        protected boolean shadow = false;
        protected String shadowColorValue = mxConstants.W3C_SHADOWCOLOR;
        protected Color shadowColor;
        protected double shadowAlpha = 1.0;
        protected double shadowOffsetX = mxConstants.SHADOW_OFFSETX;
        protected double shadowOffsetY = mxConstants.SHADOW_OFFSETY;
        protected transient Graphics2D g;

        protected CanvasState() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

