/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.util.ArrayUtilRt;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class Utilities {
    private Utilities() {
    }

    static String[] split(String s, String regex) {
        return Utilities.split(s, Pattern.compile(regex));
    }

    static String[] split(String s, Pattern pattern) {
        return s.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : pattern.split(s);
    }

    static String join(Collection<String> strings) {
        return Utilities.join(strings, ", ");
    }

    static String join(Collection<String> strings, String delimiter) {
        return String.join((CharSequence)delimiter, strings);
    }

    static <T> Set<T> flatten(Collection<? extends Set<T>> elements) {
        return elements.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    static <K, V> Map<K, Set<V>> merge(Collection<? extends Map<K, Set<V>>> maps) {
        return maps.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Utilities::union));
    }

    private static <T> Set<T> union(Set<? extends T> set1, Set<? extends T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.addAll(set2);
        return result;
    }

    static <T> Set<T> intersection(Set<? extends T> set1, Set<? extends T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.retainAll(set2);
        return result;
    }
}

