/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnscramblingSettings
extends JPanel {
    private static final String PROPERTY_USE_JAR = "ZKM_UNSCRAMBLER_USE_JAR";
    private static final String PROPERTY_JAR_FILE = "ZKM_UNSCRAMBLER_JAR_FILE";
    private static final String PROPERTY_JAR_FILE_HISTORY = "ZKM_UNSCRAMBLER_JAR_HISTORY";
    private static final String VALUE_SEPARATOR = ":::";
    private JBRadioButton myUseProjectClassesButton;
    private JBRadioButton myUseJarClassesButton;
    private JPanel myRootPanel;
    private JPanel myFileChooserPanel;
    private final TextFieldWithHistory myFileField;

    UnscramblingSettings() {
        this.$$$setupUI$$$();
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnscramblingSettings.this.updateFileChooser();
                UnscramblingSettings.setProperty(UnscramblingSettings.PROPERTY_USE_JAR, Boolean.toString(UnscramblingSettings.this.myUseJarClassesButton.isSelected()));
            }
        };
        if (UIUtil.isUnderWin10LookAndFeel()) {
            JBEmptyBorder emptyBorder = JBUI.Borders.empty();
            this.myUseProjectClassesButton.setBorder((Border)emptyBorder);
            this.myUseJarClassesButton.setBorder((Border)emptyBorder);
        }
        this.myUseProjectClassesButton.addActionListener(radioButtonListener);
        this.myUseJarClassesButton.addActionListener(radioButtonListener);
        this.myFileField = new TextFieldWithHistory();
        JPanel panel = GuiUtils.constructFieldWithBrowseButton((TextFieldWithHistory)this.myFileField, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooser.chooseFiles((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor(), null, (Component)UnscramblingSettings.this.myRootPanel, null, files -> {
                    UnscramblingSettings.this.myFileField.setText(FileUtil.toSystemDependentName((String)((VirtualFile)files.get(files.size() - 1)).getPath()));
                    UnscramblingSettings.this.myFileField.addCurrentTextToHistory();
                    List history = UnscramblingSettings.this.myFileField.getHistory();
                    UnscramblingSettings.setProperty(UnscramblingSettings.PROPERTY_JAR_FILE_HISTORY, history.isEmpty() ? null : StringUtil.join((Collection)history, (String)UnscramblingSettings.VALUE_SEPARATOR));
                });
            }
        });
        this.myFileChooserPanel.setLayout(new BorderLayout());
        this.myFileChooserPanel.add((Component)panel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.myRootPanel, "Center");
        this.reset();
        this.myFileField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                UnscramblingSettings.setProperty(UnscramblingSettings.PROPERTY_JAR_FILE, UnscramblingSettings.this.myFileField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/zkm/bytecode/UnscramblingSettings$3", "textChanged"));
            }
        });
    }

    @Nullable
    String getSelectedJarFilePath() {
        return this.myUseJarClassesButton.isSelected() && !this.myFileField.getText().isEmpty() ? this.myFileField.getText() : null;
    }

    private static String getProperty(String name) {
        return PropertiesComponent.getInstance().getValue(name);
    }

    private static void setProperty(String name, String value) {
        PropertiesComponent.getInstance().setValue(name, value);
    }

    private void reset() {
        String jarFileHistory;
        String useJarFileString = UnscramblingSettings.getProperty(PROPERTY_USE_JAR);
        if (useJarFileString != null) {
            this.myUseJarClassesButton.setSelected(Boolean.parseBoolean(useJarFileString));
        }
        List history = (jarFileHistory = UnscramblingSettings.getProperty(PROPERTY_JAR_FILE_HISTORY)) == null ? Collections.emptyList() : StringUtil.split((String)jarFileHistory, (String)VALUE_SEPARATOR);
        this.myFileField.setHistorySize(10);
        this.myFileField.setHistory(history);
        String jarFile = UnscramblingSettings.getProperty(PROPERTY_JAR_FILE);
        this.myFileField.setText(jarFile == null ? "" : jarFile);
        this.updateFileChooser();
    }

    private void updateFileChooser() {
        GuiUtils.enableChildren((Component)this.myFileChooserPanel, (boolean)this.myUseJarClassesButton.isSelected(), (JComponent[])new JComponent[0]);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseProjectClassesButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        jBRadioButton2.setText("Project classes");
        jBRadioButton2.setMnemonic('P');
        jBRadioButton2.setDisplayedMnemonicIndex(0);
        jBRadioButton2.setToolTipText("Use compiled project classes as a bytecode source (must match the stacktrace version)");
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myUseJarClassesButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Classes in a JAR file:");
        jBRadioButton.setMnemonic('J');
        jBRadioButton.setDisplayedMnemonicIndex(13);
        jBRadioButton.setToolTipText("Use JAR archive as a bytecode source");
        jPanel2.add((Component)jBRadioButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myFileChooserPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 2, 1, 1, 0, 3, 7, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

