/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.BytecodeImpl;
import com.intellij.zkm.bytecode.Changelog;
import com.intellij.zkm.bytecode.ChangelogReader;
import com.intellij.zkm.bytecode.InvocationReaderImpl;
import com.intellij.zkm.bytecode.JarArchive;
import com.intellij.zkm.bytecode.SignatureReaderImpl;
import com.intellij.zkm.bytecode.Translator;
import com.intellij.zkm.bytecode.TranslatorImpl;
import com.intellij.zkm.bytecode.TypeFactory;
import com.intellij.zkm.bytecode.TypeFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

class TranslatorFactory {
    private static SoftReference<TypeFactory> ourTypeFactory;
    private static final Map<File, SoftReference<Translator>> ourTranslators;

    TranslatorFactory() {
    }

    @NotNull
    public static Translator create(@NotNull File logFile, @NotNull File bytecodeFile) throws IOException {
        Translator translator;
        SoftReference<Translator> reference;
        if (logFile == null) {
            TranslatorFactory.$$$reportNull$$$0(0);
        }
        if (bytecodeFile == null) {
            TranslatorFactory.$$$reportNull$$$0(1);
        }
        if ((reference = ourTranslators.get(logFile)) != null && (translator = reference.get()) != null) {
            Translator translator2 = translator;
            if (translator2 == null) {
                TranslatorFactory.$$$reportNull$$$0(2);
            }
            return translator2;
        }
        translator = TranslatorFactory.doCreate(logFile, bytecodeFile);
        ourTranslators.put(logFile, new SoftReference<Translator>(translator));
        Translator translator3 = translator;
        if (translator3 == null) {
            TranslatorFactory.$$$reportNull$$$0(3);
        }
        return translator3;
    }

    private static Translator doCreate(File logFile, File bytecodeFile) throws IOException {
        Changelog changelog;
        TypeFactory typeFactory = TranslatorFactory.getTypeFactory();
        try (ZipFile zip = new ZipFile(logFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(zip.getEntry("ChangeLog.txt")), StandardCharsets.UTF_8));){
            changelog = new ChangelogReader(typeFactory).read(reader);
        }
        BytecodeImpl bytecode = new BytecodeImpl(new JarArchive(bytecodeFile), new SignatureReaderImpl(typeFactory), new InvocationReaderImpl(typeFactory));
        return new TranslatorImpl(changelog, bytecode);
    }

    @NotNull
    private static TypeFactory getTypeFactory() {
        TypeFactory typeFactory;
        TypeFactory typeFactory2 = typeFactory = ourTypeFactory == null ? null : ourTypeFactory.get();
        if (typeFactory == null) {
            typeFactory = new TypeFactoryImpl();
            ourTypeFactory = new SoftReference<TypeFactory>(typeFactory);
        }
        TypeFactory typeFactory3 = typeFactory;
        if (typeFactory3 == null) {
            TranslatorFactory.$$$reportNull$$$0(4);
        }
        return typeFactory3;
    }

    static {
        ourTranslators = new HashMap<File, SoftReference<Translator>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytecodeFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/TranslatorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/TranslatorFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

