/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Modifier;
import com.intellij.zkm.bytecode.Named;
import com.intellij.zkm.bytecode.Type;
import com.intellij.zkm.bytecode.Utilities;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class Signature
implements Named {
    private final Set<Modifier> myModifiers;
    private final Type myReturnType;
    private final String myName;
    private final List<Type> myParameterTypes;

    Signature(@NotNull Set<Modifier> modifiers, @NotNull Type returnType, @NotNull String name, @NotNull List<Type> parameterTypes) {
        if (modifiers == null) {
            Signature.$$$reportNull$$$0(0);
        }
        if (returnType == null) {
            Signature.$$$reportNull$$$0(1);
        }
        if (name == null) {
            Signature.$$$reportNull$$$0(2);
        }
        if (parameterTypes == null) {
            Signature.$$$reportNull$$$0(3);
        }
        this.myModifiers = modifiers;
        this.myReturnType = returnType;
        this.myName = name;
        this.myParameterTypes = parameterTypes;
    }

    @NotNull
    Set<Modifier> getModifiers() {
        Set<Modifier> set = Collections.unmodifiableSet(this.myModifiers);
        if (set == null) {
            Signature.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    Type getReturnType() {
        Type type = this.myReturnType;
        if (type == null) {
            Signature.$$$reportNull$$$0(5);
        }
        return type;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Signature.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    List<Type> getParameterTypes() {
        List<Type> list = Collections.unmodifiableList(this.myParameterTypes);
        if (list == null) {
            Signature.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature that = (Signature)o;
        if (!this.myModifiers.equals(that.myModifiers)) {
            return false;
        }
        if (!this.myReturnType.equals(that.myReturnType)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myParameterTypes.equals(that.myParameterTypes);
    }

    public int hashCode() {
        int result = this.myModifiers.hashCode();
        result = 31 * result + this.myReturnType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myParameterTypes.hashCode();
        return result;
    }

    public String toString() {
        List<String> modifiers = Named.namesOf(this.myModifiers).stream().sorted().collect(Collectors.toList());
        return String.format("%s %s %s(%s)", Utilities.join(modifiers, " "), this.myReturnType, this.myName, Utilities.join(Named.namesOf(this.myParameterTypes)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/Signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/Signature";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

