/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.zkm.bytecode.ClassData;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassDataImpl
implements ClassData {
    private final Map<String, ? extends ClassData> myClasses;
    private String myClassName;
    private String mySourceFile;
    private final Map<String, Set<Signature>> mySignatures;

    ClassDataImpl(@NotNull Map<String, ? extends ClassData> classes) {
        if (classes == null) {
            ClassDataImpl.$$$reportNull$$$0(0);
        }
        this.mySignatures = new HashMap<String, Set<Signature>>();
        this.myClasses = classes;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    void setClassName(@Nullable String originalName) {
        this.myClassName = originalName;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.mySourceFile;
    }

    void setSourceFile(@Nullable String sourceFile) {
        this.mySourceFile = sourceFile;
    }

    @Override
    @NotNull
    public Set<Signature> getSignatures(@NotNull String methodName) {
        if (methodName == null) {
            ClassDataImpl.$$$reportNull$$$0(1);
        }
        Set<Signature> set = Optional.ofNullable(this.mySignatures.get(methodName)).map(this::translate).map(Collections::unmodifiableSet).orElse(Collections.emptySet());
        if (set == null) {
            ClassDataImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    void add(@NotNull String methodName, @NotNull Signature signature) {
        if (methodName == null) {
            ClassDataImpl.$$$reportNull$$$0(3);
        }
        if (signature == null) {
            ClassDataImpl.$$$reportNull$$$0(4);
        }
        this.mySignatures.computeIfAbsent(methodName, k -> new HashSet()).add(signature);
    }

    private Set<Signature> translate(Set<Signature> signatures) {
        return signatures.stream().map(signature -> new Signature(signature.getModifiers(), this.translate(signature.getReturnType()), signature.getName(), ContainerUtil.map(signature.getParameterTypes(), this::translate))).collect(Collectors.toSet());
    }

    private Type translate(Type type) {
        if (type.isPrimitive()) {
            return type;
        }
        ClassData data = this.myClasses.get(type.getClassName());
        if (data == null || data.getClassName() == null || type.getClassName().equals(data.getClassName())) {
            return type;
        }
        return new Type(data.getClassName(), type.isArray());
    }

    @Override
    public int getLineNumber(int lineNumber) {
        return lineNumber;
    }

    boolean isEmpty() {
        return this.myClassName == null && this.mySourceFile == null && this.mySignatures.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/ClassDataImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/ClassDataImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSignatures";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

