/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.zkm.ClassInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class ZKMLog {
    private final Map<String, ClassInfo> myScrambledNameToInfoMap = new HashMap<String, ClassInfo>();
    private Project myProject;
    public static final String AT = "at ";
    public static final String TAB_AT = "\tat ";
    static final String SPACE_AT = " at";
    static final String AT_SPACE = "at ";
    private static final String XXX = "XXX";

    public ZKMLog(ClassInfo[] classes) {
        for (ClassInfo classInfo : classes) {
            this.myScrambledNameToInfoMap.put(classInfo.getScrambledName(), classInfo);
        }
    }

    private void appendUnscrambledLine(StringBuffer buffer, String scrambledLine) {
        int methodNameSeparatorIndex;
        int atIndex = scrambledLine.indexOf("at ");
        if (atIndex == -1) {
            atIndex = scrambledLine.indexOf(TAB_AT);
        }
        if (atIndex == -1) {
            buffer.append(scrambledLine);
            return;
        }
        String prefix = scrambledLine.substring(0, atIndex + 3);
        String line = scrambledLine.substring(atIndex + 3).trim();
        int lineNumber = -1;
        int parIndex = line.indexOf(40);
        if (parIndex != -1) {
            try {
                String numberStr = line.substring(line.lastIndexOf(58) + 1, line.lastIndexOf(41));
                line = line.substring(0, parIndex);
                lineNumber = Integer.parseInt(numberStr);
            }
            catch (Exception numberStr) {
                // empty catch block
            }
        }
        if ((methodNameSeparatorIndex = line.lastIndexOf(46)) == -1) {
            buffer.append(scrambledLine);
            return;
        }
        String scrambledClassName = line.substring(0, methodNameSeparatorIndex);
        ClassInfo classInfo = this.myScrambledNameToInfoMap.get(scrambledClassName);
        if (classInfo == null) {
            buffer.append(scrambledLine);
            return;
        }
        String originalName = classInfo.getOriginalName();
        int unscrambledLineNumber = classInfo.unscrambleLineNumber(lineNumber);
        String sourceFile = classInfo.getSourceFile();
        buffer.append(prefix);
        buffer.append(originalName);
        buffer.append('.');
        buffer.append(ZKMLog.findMethodName(this.myProject, originalName, unscrambledLineNumber));
        buffer.append('(');
        buffer.append(sourceFile);
        if (unscrambledLineNumber > 0) {
            buffer.append(':');
            buffer.append(unscrambledLineNumber);
        }
        buffer.append(')');
    }

    public String unscrambleStackTrace(String stackTrace) {
        stackTrace = StringUtil.replace((String)stackTrace, (String)"\r\n", (String)"\n");
        StringTokenizer tokenizer = new StringTokenizer(stackTrace, "\n");
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreElements()) {
            String line = (String)tokenizer.nextElement();
            this.appendUnscrambledLine(buffer, line);
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    private static String findMethodName(Project project, String className, int lineNumber) {
        PsiMethod method;
        int offset;
        if (project == null) {
            return XXX;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        int index = className.indexOf(36);
        String qualifiedName = index != -1 ? className.substring(0, index) : className;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)project));
        if (psiClass == null) {
            return XXX;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return XXX;
        }
        Document editorDocument = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (editorDocument == null) {
            return XXX;
        }
        try {
            offset = editorDocument.getLineStartOffset(lineNumber);
        }
        catch (Exception e) {
            return XXX;
        }
        PsiElement elementAt = psiFile.findElementAt(offset);
        if (elementAt != null && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiMethod.class)) != null) {
            return method.getName();
        }
        return XXX;
    }
}

