/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.model.messaging;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.messaging.model.SpringMessagingType;
import com.intellij.spring.messaging.model.UrlPointer;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.websocket.model.xml.MessageBroker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringWebSocketPrefixes {
    private static final String MESSAGE_BROKER_REGISTRY = "org.springframework.messaging.simp.config.MessageBrokerRegistry";
    private static final String SET_APPLICATION_PREFIXES = "setApplicationDestinationPrefixes";
    private static final String SET_USER_PREFIX = "setUserDestinationPrefix";
    @NotNull
    private final Module myModule;
    @NotNull
    private final MultiMap<SpringMessagingType, UrlPointer> myPrefixes;

    SpringWebSocketPrefixes(@NotNull Module module) {
        if (module == null) {
            SpringWebSocketPrefixes.$$$reportNull$$$0(0);
        }
        this.myPrefixes = new MultiMap();
        this.myModule = module;
        this.initDefaultPrefixValues();
        this.getPrefixesFromJavaConfiguration();
        this.getPrefixesFromXmlConfiguration();
    }

    Collection<UrlPointer> get(@NotNull SpringMessagingType type) {
        if (type == null) {
            SpringWebSocketPrefixes.$$$reportNull$$$0(1);
        }
        return this.myPrefixes.get((Object)type);
    }

    private void initDefaultPrefixValues() {
        this.setPrefixes(SpringMessagingType.values(), new UrlPointer(null, ""));
        this.setPrefixes(SpringMessagingType.APP_PREFIX_TYPES, new UrlPointer(null, "/app"));
        this.setPrefixes(SpringMessagingType.USER_PREFIX_TYPES, new UrlPointer(null, "/user"));
    }

    private void getPrefixesFromXmlConfiguration() {
        PsiClass messageBrokerConfiguration = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)"org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration");
        if (messageBrokerConfiguration == null) {
            return;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)messageBrokerConfiguration).withInheritors();
        SpringModel model = SpringManager.getInstance((Project)this.myModule.getProject()).getCombinedModel(this.myModule);
        List messageBrokerConfigurations = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        for (SpringBeanPointer beanPointer : messageBrokerConfigurations) {
            String userPrefix;
            CommonSpringBean bean = SpringBeanPomTargetUtils.getSpringBean((PsiElement)beanPointer.getPsiElement());
            if (!(bean instanceof MessageBroker)) continue;
            MessageBroker messageBroker = (MessageBroker)bean;
            String appPrefixes = messageBroker.getApplicationDestinationPrefix().getStringValue();
            if (appPrefixes != null) {
                this.setPrefixes(SpringMessagingType.APP_PREFIX_TYPES, UrlPointer.create(messageBroker.getApplicationDestinationPrefix(), (boolean)true));
            }
            if ((userPrefix = messageBroker.getUserDestinationPrefix().getStringValue()) == null) continue;
            this.setPrefixes(SpringMessagingType.USER_PREFIX_TYPES, UrlPointer.create(messageBroker.getUserDestinationPrefix(), (boolean)false));
        }
    }

    private void getPrefixesFromJavaConfiguration() {
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)MESSAGE_BROKER_REGISTRY);
        if (configurerClass == null) {
            return;
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)false);
        for (MethodAndPrefixes methodAndPrefixes : MethodAndPrefixes.values()) {
            PsiMethod method = SpringWebSocketPrefixes.getMethodIfOneExists(configurerClass, methodAndPrefixes.methodName);
            if (method == null) continue;
            MethodReferencesSearch.search((PsiMethod)method, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMethodCallExpression.class);
                if (methodCallExpression != null) {
                    List arguments = ContainerUtil.mapNotNull((Object[])methodCallExpression.getArgumentList().getExpressions(), expression -> new UrlPointer((PsiElement)expression, StringUtil.trimEnd((String)StringUtil.unquoteString((String)expression.getText()), (String)"/")));
                    if (arguments.isEmpty()) {
                        this.setPrefixes(methodAndPrefixes.prefixTypes, new UrlPointer((PsiElement)methodCallExpression.getArgumentList(), ""));
                    } else {
                        this.setPrefixes(methodAndPrefixes.prefixTypes, arguments);
                    }
                }
                return true;
            });
        }
    }

    private void setPrefixes(SpringMessagingType @NotNull [] types, @NotNull List<UrlPointer> prefixes) {
        if (prefixes == null) {
            SpringWebSocketPrefixes.$$$reportNull$$$0(2);
        }
        if (types == null) {
            SpringWebSocketPrefixes.$$$reportNull$$$0(3);
        }
        for (SpringMessagingType type : types) {
            this.myPrefixes.remove((Object)type);
            this.myPrefixes.putValues((Object)type, prefixes);
        }
    }

    private void setPrefixes(SpringMessagingType @NotNull [] types, @NotNull UrlPointer prefixPointer) {
        if (prefixPointer == null) {
            SpringWebSocketPrefixes.$$$reportNull$$$0(4);
        }
        if (types == null) {
            SpringWebSocketPrefixes.$$$reportNull$$$0(5);
        }
        for (SpringMessagingType type : types) {
            this.myPrefixes.remove((Object)type);
            this.myPrefixes.putValue((Object)type, (Object)prefixPointer);
        }
    }

    @Nullable
    private static PsiMethod getMethodIfOneExists(@NotNull PsiClass aClass, @NotNull String methodName) {
        PsiMethod[] methods;
        if (aClass == null) {
            SpringWebSocketPrefixes.$$$reportNull$$$0(6);
        }
        if (methodName == null) {
            SpringWebSocketPrefixes.$$$reportNull$$$0(7);
        }
        if ((methods = aClass.findMethodsByName(methodName, false)).length != 1) {
            return null;
        }
        return methods[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixPointer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/websocket/model/messaging/SpringWebSocketPrefixes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setPrefixes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodIfOneExists";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum MethodAndPrefixes {
        APP("setApplicationDestinationPrefixes", SpringMessagingType.APP_PREFIX_TYPES),
        USER("setUserDestinationPrefix", SpringMessagingType.USER_PREFIX_TYPES);

        public final String methodName;
        public final SpringMessagingType[] prefixTypes;

        private MethodAndPrefixes(String name, SpringMessagingType[] types) {
            this.methodName = name;
            this.prefixTypes = types;
        }
    }
}

