/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.errors.a;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.P;
import com.android.tools.r8.utils.Y;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JdkClassFileProvider
implements ClassFileResourceProvider,
Closeable {
    static final /* synthetic */ boolean f;
    private Origin a;
    private final Set<String> b;
    private final Map<String, String> c;
    private URLClassLoader d;
    private FileSystem e;

    public static ClassFileResourceProvider fromSystemJdk() throws IOException {
        return new JdkClassFileProvider();
    }

    public static ClassFileResourceProvider fromSystemModulesJdk(Path path) throws IOException {
        Path path2 = path.resolve("lib").resolve("jrt-fs.jar");
        if (Files.exists(path2, new LinkOption[0])) {
            return new JdkClassFileProvider(path);
        }
        throw new NoSuchFileException(path2.toString());
    }

    public static ClassFileResourceProvider fromJdkHome(Path path) throws IOException {
        if (Files.exists(path.resolve("lib").resolve("jrt-fs.jar"), new LinkOption[0])) {
            return JdkClassFileProvider.fromSystemModulesJdk(path);
        }
        Path path2 = path.resolve("jre").resolve("lib").resolve("rt.jar");
        if (Files.exists(path2, new LinkOption[0])) {
            return JdkClassFileProvider.fromJavaRuntimeJar(path2);
        }
        path2 = path.resolve("lib").resolve("rt.jar");
        if (Files.exists(path2, new LinkOption[0])) {
            return JdkClassFileProvider.fromJavaRuntimeJar(path2);
        }
        throw new IOException("Path " + path + " does not look like a Java home");
    }

    public static ClassFileResourceProvider fromJavaRuntimeJar(Path path) throws IOException {
        return new ArchiveClassFileProvider(path);
    }

    private JdkClassFileProvider() throws IOException {
        JdkClassFileProvider jdkClassFileProvider = this;
        jdkClassFileProvider.b = new HashSet<String>();
        jdkClassFileProvider.c = new HashMap<String, String>();
        jdkClassFileProvider.a = Origin.unknown();
        jdkClassFileProvider.a(FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap()));
    }

    private JdkClassFileProvider(Path path) throws IOException {
        JdkClassFileProvider jdkClassFileProvider;
        ((JdkClassFileProvider)((Object)map)).b = new HashSet<String>();
        ((JdkClassFileProvider)((Object)map)).c = new HashMap<String, String>();
        ((JdkClassFileProvider)((Object)map)).a = new PathOrigin(path);
        path = path.resolve("lib").resolve("jrt-fs.jar");
        if (!f && !Files.exists(path, new LinkOption[0])) {
            throw new AssertionError();
        }
        ((JdkClassFileProvider)((Object)map)).d = new URLClassLoader(new URL[]{path.toUri().toURL()});
        JdkClassFileProvider jdkClassFileProvider2 = map;
        Map map = Collections.emptyMap();
        jdkClassFileProvider.a(FileSystems.newFileSystem(URI.create("jrt:/"), map, (ClassLoader)jdkClassFileProvider2.d));
    }

    private void a(FileSystem fileSystem) throws IOException {
        this.e = fileSystem;
        Files.walk(fileSystem.getPath("/modules", new String[0]), new FileVisitOption[0]).forEach(object -> {
            if (Y.b((Path)object)) {
                JdkClassFileProvider jdkClassFileProvider = this;
                Object object2 = this = P.t(object.toString());
                object = ((P.b)object2).a();
                jdkClassFileProvider.c.put((String)object, ((P.b)object2).b());
                jdkClassFileProvider.b.add(((P.b)this).a());
            }
        });
    }

    static {
        f = JdkClassFileProvider.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Collections.unmodifiableSet(this.b);
    }

    @Override
    public ProgramResource getProgramResource(String object) {
        ProgramResource.Kind kind;
        JdkClassFileProvider jdkClassFileProvider;
        String string;
        Origin origin;
        if (!((JdkClassFileProvider)((Object)string2)).b.contains(object)) {
            return null;
        }
        try {
            origin = Origin.unknown();
            string = object;
            jdkClassFileProvider = string2;
            kind = ProgramResource.Kind.CF;
        }
        catch (IOException iOException) {
            JdkClassFileProvider jdkClassFileProvider2 = string2;
            String string2 = "Failed to read '" + (String)object;
            object = jdkClassFileProvider2.a;
            throw new a(string2, null, (Origin)object);
        }
        FileSystem fileSystem = jdkClassFileProvider.e;
        String[] stringArray = new String[2];
        stringArray[0] = ((JdkClassFileProvider)((Object)string2)).c.get(object);
        int n4 = 1;
        stringArray[n4] = P.p((String)object);
        byte[] byArray = Files.readAllBytes(fileSystem.getPath("modules", stringArray));
        Set<String> set = Collections.singleton(string);
        return ProgramResource.fromBytes(origin, kind, byArray, set);
    }

    protected void finalize() throws Throwable {
        JdkClassFileProvider jdkClassFileProvider = this;
        jdkClassFileProvider.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        JdkClassFileProvider jdkClassFileProvider = closeable;
        jdkClassFileProvider.e.close();
        Closeable closeable = jdkClassFileProvider.d;
        if (closeable != null) {
            ((URLClassLoader)closeable).close();
        }
    }
}

