/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web.jsr45;

import com.intellij.DynamicBundle;
import com.intellij.j2ee.web.jsr45.JSR45Model;
import com.intellij.j2ee.web.jsr45.Jsr45DebugBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class JSR45RunConfigurationEditor
extends SettingsEditor<CommonModel>
implements PanelWithAnchor {
    private JPanel myPanel;
    private JTextField myJSPPackage;
    private JTextField myPort;
    private JTextField myVMOptions;
    private JCheckBox myWebSphere51ModelCheckBox;
    private JBLabel myVMOptionsLabel;
    private JBLabel myPortLabel;
    private JBLabel myJSPSPackageLabel;
    private final boolean myLocal;
    private JComponent anchor;

    public JSR45RunConfigurationEditor(boolean local) {
        this.myLocal = local;
        this.$$$setupUI$$$();
        this.myPort.setVisible(this.myLocal);
        this.myPortLabel.setVisible(this.myLocal);
        this.myVMOptions.setVisible(this.myLocal);
        this.myVMOptionsLabel.setVisible(this.myLocal);
        this.setAnchor((JComponent)(this.myVMOptionsLabel.isVisible() ? this.myVMOptionsLabel : this.myJSPSPackageLabel));
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            JSR45RunConfigurationEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void applyEditorTo(@NotNull CommonModel runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            JSR45RunConfigurationEditor.$$$reportNull$$$0(1);
        }
        JSR45Model jsr45Model = (JSR45Model)runConfiguration.getServerModel();
        jsr45Model.JSP_PACKAGE = this.myJSPPackage.getText();
        jsr45Model.USE_WEBSPHERE51_LINEMAPPING_MODEL = this.myWebSphere51ModelCheckBox.isSelected();
        if (this.myLocal) {
            jsr45Model.VM_OPTS = this.myVMOptions.getText();
            try {
                jsr45Model.LOCAL_PORT = Integer.parseInt(this.myPort.getText());
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(Jsr45DebugBundle.message("message.text.invalid.port.value", this.myPort.getText()));
            }
        }
    }

    public void resetEditorFrom(@NotNull CommonModel runConfiguration) {
        if (runConfiguration == null) {
            JSR45RunConfigurationEditor.$$$reportNull$$$0(2);
        }
        JSR45Model jsr45Model = (JSR45Model)runConfiguration.getServerModel();
        this.myWebSphere51ModelCheckBox.setSelected(jsr45Model.USE_WEBSPHERE51_LINEMAPPING_MODEL);
        this.myJSPPackage.setText(jsr45Model.JSP_PACKAGE);
        if (this.myLocal) {
            this.myPort.setText(String.valueOf(jsr45Model.LOCAL_PORT));
            this.myVMOptions.setText(jsr45Model.VM_OPTS);
        }
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myJSPSPackageLabel.setAnchor(anchor);
        this.myPortLabel.setAnchor(anchor);
        this.myVMOptionsLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2ee/web/jsr45/JSR45RunConfigurationEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2ee/web/jsr45/JSR45RunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JBLabel jBLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JBLabel jBLabel3;
        JTextField jTextField3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 10, 0), -1, -1, false, false));
        this.myPort = jTextField3 = new JTextField();
        jTextField3.setColumns(4);
        jPanel.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myJSPSPackageLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/Jsr45DebugBundle", JSR45RunConfigurationEditor.class).getString("label.configuration.jsps.package"));
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJSPPackage = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(100, 20), null));
        this.myVMOptions = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVMOptionsLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/Jsr45DebugBundle", JSR45RunConfigurationEditor.class).getString("vm.options.variable"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWebSphere51ModelCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/Jsr45DebugBundle", JSR45RunConfigurationEditor.class).getString("checkbox.use.websphere51.line.mapping.model.text"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myPortLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/Jsr45DebugBundle", JSR45RunConfigurationEditor.class).getString("label.configuration.port"));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel3.setLabelFor(jTextField2);
        jBLabel2.setLabelFor(jTextField);
        jBLabel.setLabelFor(jTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

