/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.utils;

import com.intellij.beanValidation.constants.BvAnnoConstants;
import com.intellij.beanValidation.model.xml.Bean;
import com.intellij.beanValidation.model.xml.Element;
import com.intellij.beanValidation.model.xml.ValidationConfig;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Query;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BVUtils {
    private BVUtils() {
    }

    @NotNull
    public static Collection<PsiClass> getConstraintClasses(@NotNull Module module) {
        if (module == null) {
            BVUtils.$$$reportNull$$$0(0);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)BvAnnoConstants.CONSTRAINT.fqn(module));
        if (collection == null) {
            BVUtils.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public static boolean isBeanValidationAvailable(Project project) {
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)BvAnnoConstants.CONSTRAINT.javax()) || JavaLibraryUtils.hasLibraryClass((Project)project, (String)BvAnnoConstants.CONSTRAINT.jakarta());
    }

    public static boolean isBeanValidationDefined(@Nullable Module module) {
        return module != null && JavaLibraryUtils.hasLibraryClass((Module)module, (String)BvAnnoConstants.CONSTRAINT.fqn(module));
    }

    public static boolean isInLibrary(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex().isInLibraryClasses(virtualFile);
    }

    public static Collection<PsiClass> getConstraintValidators(@NotNull Module module) {
        if (module == null) {
            BVUtils.$$$reportNull$$$0(2);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(BvAnnoConstants.CONSTRAINT_VALIDATOR.fqn(module), searchScope);
        if (psiClass == null) {
            return Collections.emptyList();
        }
        Query query = ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)searchScope, (boolean)true, (boolean)true, (boolean)false);
        return query.findAll();
    }

    @Nullable
    public static PsiClass getBeanClass(ConvertContext context) {
        Bean bean = (Bean)context.getInvocationElement().getParentOfType(Bean.class, true);
        return bean == null ? null : (PsiClass)bean.getClassAttr().getValue();
    }

    @Nullable
    public static PsiMethod getAnnotationMethod(ConvertContext context) {
        Element element = (Element)context.getInvocationElement().getParentOfType(Element.class, false);
        return element == null ? null : (PsiMethod)element.getName().getValue();
    }

    @Nullable
    public static XmlFile getValidationXml(Module module) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            PsiFile file;
            VirtualFile config;
            VirtualFile metaInf = root.findChild("META-INF");
            if (metaInf == null || (config = metaInf.findChild("validation.xml")) == null || !((file = PsiManager.getInstance((Project)module.getProject()).findFile(config)) instanceof XmlFile)) continue;
            return (XmlFile)file;
        }
        return null;
    }

    public static XmlFile[] getConstraintFiles(Module module) {
        DomFileElement domFileElement;
        XmlFile config = BVUtils.getValidationXml(module);
        if (config != null && (domFileElement = DomManager.getDomManager((Project)module.getProject()).getFileElement(config, ValidationConfig.class)) != null) {
            ValidationConfig root = (ValidationConfig)domFileElement.getRootElement();
            ArrayList<XmlFile> files = new ArrayList<XmlFile>();
            for (GenericDomValue<XmlFile> domValue : root.getConstraintMappings()) {
                XmlFile file = (XmlFile)domValue.getValue();
                if (file == null) continue;
                files.add(file);
            }
            return files.toArray(XmlFile.EMPTY_ARRAY);
        }
        return XmlFile.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/utils/BVUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/utils/BVUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConstraintClasses";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConstraintValidators";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

