/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.providers;

import com.intellij.beanValidation.constants.BvAnnoConstants;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import icons.BVCoreIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;

public final class BvConstraintLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @GutterName
    @NotNull
    public String getName() {
        String string = BVBundle.message("bv.classes.gutter.name", new Object[0]);
        if (string == null) {
            BvConstraintLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = BVCoreIcons.BeanValidation;
        if (icon == null) {
            BvConstraintLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            BvConstraintLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            BvConstraintLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            BvConstraintLineMarkerProvider.$$$reportNull$$$0(4);
        }
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            BvConstraintLineMarkerProvider.annotate(psiElement, result);
        }
    }

    private static void annotate(PsiElement psiElement, Collection<? super LineMarkerInfo<?>> result) {
        block10: {
            Module module;
            String className;
            PsiClass psiClass;
            PsiElement sourcePsi;
            Project project;
            block12: {
                block11: {
                    project = psiElement.getProject();
                    if (BvConstraintLineMarkerProvider.getToolWindow(project) == null) {
                        return;
                    }
                    UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
                    if (uParent == null) {
                        return;
                    }
                    if (!(uParent instanceof UClass)) break block10;
                    UClass uClass = (UClass)uParent;
                    UElement anchor = uClass.getUastAnchor();
                    if (anchor == null) {
                        return;
                    }
                    sourcePsi = anchor.getSourcePsi();
                    if (sourcePsi == null) {
                        return;
                    }
                    psiClass = uClass.getJavaPsi();
                    className = uClass.getName();
                    if (className == null) {
                        return;
                    }
                    if (!uClass.isAnnotationType()) break block11;
                    for (UAnnotation uAnnotation : uClass.getUAnnotations()) {
                        if (!BvAnnoConstants.CONSTRAINT.isFqn(uAnnotation.getQualifiedName())) continue;
                        result.add(BvConstraintLineMarkerProvider.createLineMarker(sourcePsi, project));
                        return;
                    }
                    break block10;
                }
                if (psiClass.isInterface() || psiClass.isEnum() || psiClass.isRecord()) break block10;
                PsiClass superClass = psiClass.getSuperClass();
                if (superClass != null && psiClass.getImplementsListTypes().length == 0 && "java.lang.Object".equals(superClass.getQualifiedName())) {
                    return;
                }
                module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                if (module == null || !BVUtils.isBeanValidationDefined(module)) break block12;
                PsiClass constraintPsiClass = JavaPsiFacade.getInstance((Project)project).findClass(BvAnnoConstants.CONSTRAINT_VALIDATOR.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
                if (constraintPsiClass == null || !psiClass.isInheritor(constraintPsiClass, true)) break block10;
                result.add(BvConstraintLineMarkerProvider.createLineMarker(sourcePsi, project));
                break block10;
            }
            if (module == null && className.contains("Validator")) {
                for (String validatorFqn : BvAnnoConstants.CONSTRAINT_VALIDATOR.all()) {
                    PsiClass[] constrainPsiClasses;
                    for (PsiClass constraintPsiClass : constrainPsiClasses = JavaPsiFacade.getInstance((Project)project).findClasses(validatorFqn, GlobalSearchScope.allScope((Project)project))) {
                        if (!psiClass.isInheritor(constraintPsiClass, true)) continue;
                        result.add(BvConstraintLineMarkerProvider.createLineMarker(sourcePsi, project));
                        return;
                    }
                }
            }
        }
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(PsiElement psiElement, Project project) {
        return new LineMarkerInfo(psiElement, psiElement.getTextRange(), BVCoreIcons.Gutter.BeanValidation, el -> BVBundle.message("bv.open.tool.window", new Object[0]), (e, elt) -> {
            ToolWindow toolWindow = BvConstraintLineMarkerProvider.getToolWindow(project);
            if (toolWindow != null) {
                toolWindow.activate(null);
            }
        }, GutterIconRenderer.Alignment.RIGHT, BVBundle.messagePointer("bv.open.tool.window", new Object[0]));
    }

    @Nullable
    public static ToolWindow getToolWindow(Project project) {
        return ToolWindowManager.getInstance((Project)project).getToolWindow("Bean Validation");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/providers/BvConstraintLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/providers/BvConstraintLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

