/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.model.converters;

import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BvConstraintMappingConverter
extends ResolvingConverter<XmlFile>
implements CustomReferenceConverter {
    public String toString(@Nullable XmlFile xml, ConvertContext context) {
        if (xml == null) {
            return null;
        }
        VirtualFile file = xml.getVirtualFile();
        if (file == null) {
            return null;
        }
        VirtualFile root = BvConstraintMappingConverter.getRootForFile(file, context);
        if (root == null) {
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
    }

    @Nullable
    private static VirtualFile getRootForFile(VirtualFile file, ConvertContext context) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)context.getPsiManager().getProject()).getFileIndex();
        VirtualFile root = projectFileIndex.getSourceRootForFile(file);
        if (root == null) {
            root = projectFileIndex.getContentRootForFile(file);
        }
        return root;
    }

    public XmlFile fromString(@Nullable @NonNls String value, ConvertContext context) {
        if (value == null) {
            return null;
        }
        XmlElement xmlElement = context.getReferenceXmlElement();
        if (xmlElement == null) {
            return null;
        }
        PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)xmlElement, context);
        if (references.length == 0) {
            return null;
        }
        PsiElement element = references[references.length - 1].resolve();
        return element instanceof XmlFile ? (XmlFile)element : null;
    }

    @NotNull
    public Collection<? extends XmlFile> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            BvConstraintMappingConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    public PsiElement resolve(XmlFile psiFile, ConvertContext context) {
        if (context.getFile().equals(psiFile)) {
            return null;
        }
        return BvConstraintMappingConverter.isFileAccepted((PsiFile)psiFile) ? super.resolve((Object)psiFile, context) : null;
    }

    public PsiReference @NotNull [] createReferences(@NotNull GenericDomValue genericDomValue, @NotNull PsiElement element, @NotNull ConvertContext context) {
        String s;
        if (genericDomValue == null) {
            BvConstraintMappingConverter.$$$reportNull$$$0(1);
        }
        if (element == null) {
            BvConstraintMappingConverter.$$$reportNull$$$0(2);
        }
        if (context == null) {
            BvConstraintMappingConverter.$$$reportNull$$$0(3);
        }
        if ((s = genericDomValue.getStringValue()) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                BvConstraintMappingConverter.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        PsiReference[] psiReferenceArray = new FilePathReferenceProvider(){

            protected boolean isPsiElementAccepted(PsiElement element) {
                return super.isPsiElementAccepted(element) && (!(element instanceof PsiFile) || BvConstraintMappingConverter.isFileAccepted((PsiFile)element));
            }
        }.getReferencesByElement(element, s, offset, true);
        if (psiReferenceArray == null) {
            BvConstraintMappingConverter.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    private static boolean isFileAccepted(@NotNull PsiFile file) {
        XmlTag rootTag;
        XmlFile xmlFile;
        XmlDocument document;
        if (file == null) {
            BvConstraintMappingConverter.$$$reportNull$$$0(6);
        }
        if (file instanceof XmlFile && (document = (xmlFile = (XmlFile)file).getDocument()) != null && (rootTag = document.getRootTag()) != null) {
            return "constraint-mappings".equals(rootTag.getName());
        }
        return false;
    }

    public String getErrorMessage(@Nullable String value, ConvertContext context) {
        if (Objects.equals(context.getFile().getName(), value)) {
            return BVBundle.message("constraint.mapping.converter.recursive.inclusion.error", new Object[0]);
        }
        return BVBundle.message("constraint.mapping.converter.resolve.error", value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericDomValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

