/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.fixes;

import com.intellij.beanValidation.constants.BvAnnoConstants;
import com.intellij.beanValidation.highlighting.fixes.BaseBVQuickFix;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CreateConstraintValidatorFix
extends BaseBVQuickFix
implements IntentionAction {
    @NotNull
    private final @NotNull SmartPsiElementPointer<@NotNull PsiJavaCodeReferenceElement> myRef;
    @NotNull
    private final @NotNull SmartPsiElementPointer<@NotNull PsiClass> myConstraint;

    public CreateConstraintValidatorFix(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiClass constraint) {
        if (ref == null) {
            CreateConstraintValidatorFix.$$$reportNull$$$0(0);
        }
        if (constraint == null) {
            CreateConstraintValidatorFix.$$$reportNull$$$0(1);
        }
        super(BVInspectionBundle.message("create.constraint.validator", ref.getCanonicalText()));
        this.myRef = SmartPointerManager.createPointer((PsiElement)ref);
        this.myConstraint = SmartPointerManager.createPointer((PsiElement)constraint);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            CreateConstraintValidatorFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateConstraintValidatorFix.$$$reportNull$$$0(3);
        }
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        PsiClass constraintElement = (PsiClass)this.myConstraint.getElement();
        return element != null && element.isValid() && constraintElement != null && constraintElement.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateConstraintValidatorFix.$$$reportNull$$$0(4);
        }
        if (!this.isAvailable(project, editor, file)) {
            return;
        }
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        if (element == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element)) {
            return;
        }
        PsiClass aClass = CreateFromUsageUtils.createClass((PsiJavaCodeReferenceElement)element, (CreateClassKind)CreateClassKind.CLASS, null);
        if (aClass == null) {
            return;
        }
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)aClass, (JavaeeClass)BvAnnoConstants.CONSTRAINT_VALIDATOR);
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(aClass.getContainingFile());
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            try {
                element.bindToElement((PsiElement)aClass);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            StringBuilder template = new StringBuilder();
            int nameOffset = aClass.getNameIdentifier().getTextOffset() + aClass.getNameIdentifier().getTextLength();
            int leftBraceOffset = aClass.getLBrace().getTextOffset();
            template.append(" implements ").append(BvAnnoConstants.CONSTRAINT_VALIDATOR.fqn(javaeeType)).append("<").append(((PsiClass)this.myConstraint.getElement()).getQualifiedName()).append(", $type$> {");
            template.append("\n   public void initialize(").append(((PsiClass)this.myConstraint.getElement()).getQualifiedName()).append(" constraint) {\n   }\n\n").append("   public boolean isValid($type$ $name$, ").append(BvAnnoConstants.CONSTRAINT_VALIDATOR_CONTEXT.fqn(javaeeType)).append(" context) {\n      return false;\n   }");
            IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, aClass.getContainingFile().getVirtualFile(), aClass.getTextOffset());
            String fqn = aClass.getQualifiedName();
            Editor editor1 = FileEditorManager.getInstance((Project)aClass.getProject()).openTextEditor(descriptor, true);
            editor1.getSelectionModel().setSelection(nameOffset, leftBraceOffset + 1);
            Template temp = TemplateManager.getInstance((Project)project).createTemplate("", "", template.toString());
            temp.addVariable("type", "\"String\"", "String", true);
            temp.addVariable("name", "\"obj\"", "obj", true);
            TemplateManager.getInstance((Project)project).startTemplate(editor1, "", temp);
            PsiExpression expression = JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(fqn + ".class", (PsiElement)((PsiClass)this.myConstraint.getElement()).getModifierList());
            ((PsiClass)this.myConstraint.getElement()).getModifierList().findAnnotation(BvAnnoConstants.CONSTRAINT.fqn(javaeeType)).findAttributeValue("validatedBy").replace((PsiElement)expression);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CreateConstraintValidatorFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            CreateConstraintValidatorFix.$$$reportNull$$$0(6);
        }
        this.invoke(project, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/highlighting/fixes/CreateConstraintValidatorFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/highlighting/fixes/CreateConstraintValidatorFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

