/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.constants.BvAnnoConstants;
import com.intellij.beanValidation.highlighting.BaseBeanValidationInspection;
import com.intellij.beanValidation.highlighting.fixes.CreateConstraintValidatorFix;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.NotNull;

public class ConstraintValidatorCreator
extends BaseBeanValidationInspection {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiModifierList modifierList;
        if (aClass == null) {
            ConstraintValidatorCreator.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ConstraintValidatorCreator.$$$reportNull$$$0(1);
        }
        if ((modifierList = aClass.getModifierList()) == null) {
            return null;
        }
        PsiAnnotation anno = modifierList.findAnnotation(BvAnnoConstants.CONSTRAINT.fqn((PsiElement)aClass));
        if (anno == null) {
            return null;
        }
        PsiAnnotationMemberValue value = anno.findAttributeValue("validatedBy");
        if (value instanceof PsiClassObjectAccessExpression) {
            value = ((PsiClassObjectAccessExpression)value).getOperand().getFirstChild();
        }
        if (value instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)value).resolve() == null) {
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)value, BVInspectionBundle.message("constraint.validator.does.not.exist", new Object[0]), (LocalQuickFix)new CreateConstraintValidatorFix((PsiJavaCodeReferenceElement)value, aClass), ProblemHighlightType.ERROR, isOnTheFly)};
        }
        return super.checkClass(aClass, manager, isOnTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/beanValidation/highlighting/ConstraintValidatorCreator";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

