/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

public class ComposeFileServicesIndex
extends ScalarIndexExtension<String> {
    private static final ID<String, Void> INDEX_NAME = ID.create((String)"docker.compose.services");
    private static final String SYNTHETIC_IS_COMPOSE_FILE_FLAG = "type: docker-compose:";

    public static boolean isDockerComposeFile(@NotNull YAMLFile yamlFile) {
        VirtualFile theOnlyFile;
        if (yamlFile == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(0);
        }
        if ((theOnlyFile = yamlFile.getOriginalFile().getVirtualFile()) == null) {
            return false;
        }
        return FileBasedIndex.getInstance().getFileData(INDEX_NAME, theOnlyFile, yamlFile.getProject()).containsKey(SYNTHETIC_IS_COMPOSE_FILE_FLAG);
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = INDEX_NAME;
        if (iD == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer dataIndexer = ComposeFileServicesIndex::doIndex;
        if (dataIndexer == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(2);
        }
        return dataIndexer;
    }

    @NotNull
    private static Map<String, Void> doIndex(FileContent content) {
        THashMap result = new THashMap();
        content.getPsiFile().accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor((Map)result){
            final /* synthetic */ Map val$result;
            {
                this.val$result = map;
            }

            public void visitDocument(@NotNull YAMLDocument document) {
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                Optional.ofNullable(document.getTopLevelValue()).map(x$0 -> ComposeFileServicesIndex.asYamlMapping(x$0)).ifPresent(this::visitTopMapping);
            }

            private void visitTopMapping(@NotNull YAMLMapping topMapping) {
                if (topMapping == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (topMapping.getKeyValueByKey("version") == null) {
                    return;
                }
                YAMLKeyValue servicesRoot = topMapping.getKeyValueByKey("services");
                if (servicesRoot == null) {
                    return;
                }
                this.val$result.put(ComposeFileServicesIndex.SYNTHETIC_IS_COMPOSE_FILE_FLAG, null);
                ((Collection)Optional.ofNullable(servicesRoot.getValue()).map(x$0 -> ComposeFileServicesIndex.asYamlMapping(x$0)).map(YAMLMapping::getKeyValues).orElse(Collections.emptyList())).stream().map(YAMLKeyValue::getKeyText).filter(name -> !StringUtil.isEmptyOrSpaces((String)name)).forEach(name -> this.val$result.put(name, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "topMapping";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileServicesIndex$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDocument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTopMapping";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        THashMap tHashMap = result;
        if (tHashMap == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(3);
        }
        return tHashMap;
    }

    @Nullable
    private static YAMLMapping asYamlMapping(@NotNull YAMLValue value) {
        if (value == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(4);
        }
        return (YAMLMapping)ObjectUtils.tryCast((Object)value, YAMLMapping.class);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(5);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = YAMLUtil.YAML_INPUT_FILTER;
        if (inputFilter == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(6);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/composeFile/ComposeFileServicesIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileServicesIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDockerComposeFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "asYamlMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

