/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.utils;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.lang.ThymeleafExpressionsFileType;
import com.intellij.thymeleaf.lang.injectors.ThymeleafExpressionsInjector;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesPathTemplateSelector;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateName;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateNameSelectorExpression;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateSelectionExpression;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafRenameableImplicitVariable;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.references.ThymeleafFakeRenameableReferenceProvider;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafCommonUtil {
    public static boolean hasThymeleafLibrary(Project project) {
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.thymeleaf.dialect.IDialect");
    }

    public static String @NotNull [] getThymeleafNamespaces(@NotNull Project project) {
        if (project == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(0);
        }
        HashSet uris = new HashSet();
        for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(project)) {
            ContainerUtil.addAll(uris, (Object[])dialect.getNamespaces());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(uris);
        if (stringArray == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public static ThymesElExpression findObjectExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(2);
        }
        return ThymeleafCommonUtil.findParentTagExpression(expression, "object");
    }

    @NotNull
    public static Collection<ThymesElExpression> findEachExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(3);
        }
        return ThymeleafCommonUtil.findAllParentTagExpressions(expression, "each");
    }

    @Nullable
    public static ThymesElExpression findFragmentExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(4);
        }
        return ThymeleafCommonUtil.findParentTagExpression(expression, "fragment");
    }

    @Nullable
    public static ThymesElExpression findFirstParentTagsExpression(@NotNull PsiElement expression, String ... attrNames) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(5);
        }
        if (attrNames == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(6);
        }
        CommonProcessors.FindFirstProcessor findFirst = new CommonProcessors.FindFirstProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, Arrays.asList(attrNames), (Processor<? super ThymesElExpression>)findFirst);
        return (ThymesElExpression)findFirst.getFoundValue();
    }

    @NotNull
    public static Collection<ThymesElExpression> findWithExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(7);
        }
        return ThymeleafCommonUtil.findAllParentTagExpressions(expression, "with");
    }

    @Nullable
    public static ThymesElExpression findParentTagExpression(@NotNull PsiElement expression, @NotNull String attrName) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(8);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(9);
        }
        CommonProcessors.FindFirstProcessor findFirst = new CommonProcessors.FindFirstProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, Collections.singleton(attrName), (Processor<? super ThymesElExpression>)findFirst);
        return (ThymesElExpression)findFirst.getFoundValue();
    }

    @NotNull
    private static Collection<ThymesElExpression> findAllParentTagExpressions(@NotNull PsiElement expression, @NotNull String attrName) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(10);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(11);
        }
        CommonProcessors.CollectProcessor findFirst = new CommonProcessors.CollectProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, Collections.singleton(attrName), (Processor<? super ThymesElExpression>)findFirst);
        Collection collection = findFirst.getResults();
        if (collection == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static boolean processParentTagExpressions(@NotNull PsiElement expression, @NotNull Collection<String> attrNames, @NotNull Processor<? super ThymesElExpression> processor) {
        XmlTag xmlTag;
        XmlAttribute contextAttribute;
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(13);
        }
        if (attrNames == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(15);
        }
        if ((contextAttribute = ThymeleafCommonUtil.getContextAttribute(expression)) != null && (xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)contextAttribute, XmlTag.class)) != null) {
            XmlTag parentTag;
            XmlTag xmlTag2 = parentTag = attrNames.contains(ThymeleafCommonUtil.getLocalName(contextAttribute)) ? xmlTag.getParentTag() : xmlTag;
            while (parentTag != null) {
                for (String attrName : attrNames) {
                    ThymesElExpression thymesElExpression;
                    XmlAttribute attribute = ThymeleafCommonUtil.getAttribute(attrName, parentTag);
                    if (attribute == null || (thymesElExpression = ThymeleafCommonUtil.getAttributeExpression(attribute, ThymesElExpression.class)) == null || processor.process((Object)thymesElExpression)) continue;
                    return false;
                }
                parentTag = parentTag.getParentTag();
            }
        }
        return true;
    }

    @Nullable
    public static XmlAttribute getContextAttribute(@NotNull PsiElement expression) {
        PsiElement context;
        PsiFile containingFile;
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(16);
        }
        if ((containingFile = expression.getContainingFile()) != null && (context = containingFile.getContext()) != null) {
            return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
        }
        return null;
    }

    private static String getLocalName(@NotNull XmlAttribute contextAttribute) {
        String attrNameHtml5;
        if (contextAttribute == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(17);
        }
        return (attrNameHtml5 = ThymeleafExpressionsInjector.getThymeleafAttrNameHtml5(contextAttribute)) != null ? attrNameHtml5 : contextAttribute.getLocalName();
    }

    @Nullable
    public static XmlAttribute getAttribute(@NotNull String attrName, @NotNull XmlTag xmlTag) {
        XmlAttribute attribute;
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(18);
        }
        if (xmlTag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(19);
        }
        if ((attribute = ThymeleafCommonUtil.findThymeleafAttribute(xmlTag, attrName)) != null) {
            return attribute;
        }
        String prefixByNamespace = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(xmlTag);
        if (prefixByNamespace != null) {
            return xmlTag.getAttribute("data-" + prefixByNamespace + "-" + attrName);
        }
        return null;
    }

    @Nullable
    public static <T> T getAttributeExpression(@NotNull XmlAttribute attribute, Class<T> expressionOfType) {
        if (attribute == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(20);
        }
        Ref ref = Ref.create();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)attribute.getProject());
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement != null) {
            manager.enumerate((PsiElement)valueElement, (injectedPsi, places) -> {
                if (injectedPsi.getFileType() instanceof ThymeleafExpressionsFileType) {
                    PsiElement[] children;
                    for (PsiElement child : children = injectedPsi.getChildren()) {
                        if (!expressionOfType.isInstance(child)) continue;
                        ref.set((Object)child);
                        break;
                    }
                }
            });
        }
        return (T)ref.get();
    }

    @NotNull
    public static List<PsiFile> findIncludedFiles(@NotNull XmlFile templateFile) {
        if (templateFile == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(21);
        }
        SmartList files = new SmartList();
        for (ThymesTemplateSelectionExpression expression : ThymeleafCommonUtil.collectTemplateSelections(templateFile)) {
            for (ThymesElExpression elExpression : expression.getElExpressionList()) {
                PsiElement resolve;
                ThymesTemplateName reference;
                if (!(elExpression instanceof ThymesTemplateNameSelectorExpression) || (reference = ThymeleafCommonUtil.getTemplateNameReference(((ThymesTemplateNameSelectorExpression)elExpression).getPathTemplateSelector())) == null || !((resolve = reference.resolve()) instanceof PsiFile)) continue;
                files.add((PsiFile)resolve);
            }
        }
        SmartList smartList = files;
        if (smartList == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(22);
        }
        return smartList;
    }

    @Nullable
    private static ThymesTemplateName getTemplateNameReference(@Nullable ThymesPathTemplateSelector templateSelector) {
        if (templateSelector == null) {
            return null;
        }
        List<ThymesTemplateName> templateNameList = templateSelector.getTemplateNameList();
        if (templateNameList.size() > 0) {
            return templateNameList.get(templateNameList.size() - 1);
        }
        return null;
    }

    @NotNull
    private static List<ThymesTemplateSelectionExpression> collectTemplateSelections(@NotNull XmlFile templateFile) {
        if (templateFile == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(23);
        }
        final ArrayList<ThymesTemplateSelectionExpression> templateSelectExpressions = new ArrayList<ThymesTemplateSelectionExpression>();
        templateFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (this.isThymeleafTemplateSelectAttribute(attribute, "include") || this.isThymeleafTemplateSelectAttribute(attribute, "replace") || this.isThymeleafTemplateSelectAttribute(attribute, "insert")) {
                    ContainerUtil.addIfNotNull((Collection)templateSelectExpressions, (Object)ThymeleafCommonUtil.getAttributeExpression(attribute, ThymesTemplateSelectionExpression.class));
                }
            }

            private boolean isThymeleafTemplateSelectAttribute(XmlAttribute attribute, String inclusionType) {
                String localName = attribute.getLocalName();
                return (localName.equals(inclusionType) || localName.endsWith("-" + inclusionType)) && inclusionType.equals(ThymeleafExpressionsInjector.getThymeleafAttrName(attribute));
            }
        });
        ArrayList<ThymesTemplateSelectionExpression> arrayList = templateSelectExpressions;
        if (arrayList == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    public static Map<String, ThymeleafVariable> getInitVariables(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(25);
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)psiMethod, () -> {
            @NotNull ConcurrentHashMap<K, V> set = new ConcurrentHashMap();
            MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)GlobalSearchScope.allScope((Project)psiMethod.getProject()), (boolean)true).forEach(psiReference -> {
                Pair evaluatedExpression;
                PsiExpression[] expressions;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
                if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length == 2 && (evaluatedExpression = StringExpressionHelper.evaluateExpression((PsiElement)expressions[0])) != null) {
                    PsiElement psiExpression = (PsiElement)evaluatedExpression.getFirst();
                    String name = (String)evaluatedExpression.getSecond();
                    PsiType type = expressions[1].getType();
                    if (name != null && type != null) {
                        if (psiExpression instanceof PsiLiteral) {
                            RenameableFakePsiElement renamebaleElement = ThymeleafFakeRenameableReferenceProvider.getOrCreateRenamebaleFakeElement((PsiLiteral)psiExpression);
                            set.put(name, new ThymeleafRenameableImplicitVariable(name, type, renamebaleElement));
                        } else {
                            set.put(name, new ThymeleafVariable(name, type, psiExpression));
                        }
                    }
                }
                return true;
            });
            return CachedValueProvider.Result.create(set, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static String getPrefixByThymeleafNamespace(@NotNull XmlTag tag) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(26);
        }
        for (String uri : ThymeleafCommonUtil.getThymeleafNamespaces(tag.getProject())) {
            String prefixByNamespace = tag.getPrefixByNamespace(uri);
            if (prefixByNamespace == null) continue;
            return prefixByNamespace;
        }
        return ThymeleafCommonUtil.getDefaultPrefixIfThymeleafPrologDefined(tag);
    }

    @Nullable
    private static String getDefaultPrefixIfThymeleafPrologDefined(XmlTag tag) {
        XmlProlog prolog;
        XmlDocument document;
        PsiFile file = tag.getContainingFile();
        if (file instanceof XmlFile && (document = ((XmlFile)file).getDocument()) != null && (prolog = document.getProlog()) != null && prolog.getText().contains("www.thymeleaf.org")) {
            return "th";
        }
        return null;
    }

    @Nullable
    public static String getPrefixByThymeleafNamespace(@NotNull XmlTag tag, String ... uris) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(27);
        }
        if (uris == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(28);
        }
        for (String uri : uris) {
            String prefixByNamespace = tag.getPrefixByNamespace(uri);
            if (prefixByNamespace == null) continue;
            return prefixByNamespace;
        }
        return null;
    }

    public static boolean isThymeleafPrefix(XmlTag context, String prefixByQualifiedName) {
        String namespaceByPrefix = context.getNamespaceByPrefix(prefixByQualifiedName);
        return ThymeleafCommonUtil.isThymeleafNamespace(namespaceByPrefix, context.getProject()) || "th".equals(prefixByQualifiedName) && StringUtil.isEmptyOrSpaces((String)namespaceByPrefix) && ThymeleafCommonUtil.hasThymeleafLibrary(context.getProject());
    }

    public static boolean isThymeleafNamespace(@NotNull String ns, @Nullable Project project) {
        if (ns == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(29);
        }
        if (project != null && !DumbService.isDumb((Project)project)) {
            for (String uri : ThymeleafCommonUtil.getThymeleafNamespaces(project)) {
                if (!uri.equals(ns)) continue;
                return true;
            }
        }
        return ThymeleafDialects.getImplicitNamespaces().contains(ns);
    }

    @Nullable
    public static XmlAttribute findThymeleafAttribute(@NotNull XmlTag tag, @NotNull String attrName) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(30);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(31);
        }
        return ThymeleafCommonUtil.findThymeleafAttribute(tag, attrName, ThymeleafNamespaceConstants.THYMELEAF_URIS);
    }

    @Nullable
    public static XmlAttribute findThymeleafAttribute(@NotNull XmlTag tag, @NotNull String attrName, String ... uris) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(32);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(33);
        }
        for (String uri : uris) {
            XmlAttribute attribute = tag.getAttribute(attrName, uri);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrNames";
                break;
            }
            case 9: 
            case 11: 
            case 18: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextAttribute";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 26: 
            case 27: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uris";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThymeleafNamespaces";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllParentTagExpressions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findIncludedFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTemplateSelections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThymeleafNamespaces";
                break;
            }
            case 1: 
            case 12: 
            case 22: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findObjectExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findEachExpressions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFragmentExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFirstParentTagsExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findWithExpressions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParentTagExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAllParentTagExpressions";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processParentTagExpressions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContextAttribute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocalName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findIncludedFiles";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectTemplateSelections";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInitVariables";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixByThymeleafNamespace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isThymeleafNamespace";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findThymeleafAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

