/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.lang.ThymeleafExpressionsFileType;
import com.intellij.thymeleaf.lang.ThymeleafPsiFile;
import com.intellij.thymeleaf.lang.psi.ThymeleafTemplateFragmentReference;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesPathTemplateSelector;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateFragment;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateName;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateNameSelectorExpression;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateSelectionExpression;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafFragmentPomTarget;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafPsiCompositeElementImpl;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafTemplateNameReferenceImpl;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import icons.ThymeleafIcons;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThymeleafTemplateFragmentReferenceImpl
extends ThymeleafPsiCompositeElementImpl
implements ThymeleafTemplateFragmentReference {
    private static final Function<XmlTag, XmlAttribute> FRAGMENT = tag -> ThymeleafCommonUtil.findThymeleafAttribute(tag, "fragment");
    private static final Function<XmlTag, XmlAttribute> ID_REF = tag -> tag.getAttribute("id");

    public ThymeleafTemplateFragmentReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public PsiElement getElement() {
        ThymeleafTemplateFragmentReferenceImpl thymeleafTemplateFragmentReferenceImpl = this;
        if (thymeleafTemplateFragmentReferenceImpl == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(1);
        }
        return thymeleafTemplateFragmentReferenceImpl;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        return new TextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ThymeleafTemplateFragmentReference newFragmentReference;
        if (newElementName == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(3);
        }
        if (this.getText().startsWith("#")) {
            newElementName = "#" + (String)newElementName;
        }
        if ((newFragmentReference = ThymeleafTemplateFragmentReferenceImpl.createTemplateFragmentReference((String)newElementName, this.getProject())) != null) {
            this.replace(newFragmentReference);
        }
        return this;
    }

    @Nullable
    private static ThymeleafTemplateFragmentReference createTemplateFragmentReference(@NotNull String name, @NotNull Project project) {
        PsiElement element;
        ThymeleafPsiFile psiFile;
        PsiElement deepestElement;
        if (name == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(5);
        }
        if ((deepestElement = (psiFile = (ThymeleafPsiFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.thymes", (FileType)ThymeleafExpressionsFileType.TEMPLATES_EXPRESSIONS, (CharSequence)("foo::" + name))).findElementAt(7)) != null && (element = deepestElement.getParent()) instanceof ThymeleafTemplateFragmentReference) {
            return (ThymeleafTemplateFragmentReference)element;
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiFile) {
            return this.handleElementRename(((PsiFile)element).getName());
        }
        return element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(7);
        }
        PsiElement resolve = this.resolve();
        return element.equals(resolve);
    }

    public Object @NotNull [] getVariants() {
        final HashSet results = new HashSet();
        XmlFile templateFile = this.getTemplateFile();
        if (templateFile != null) {
            templateFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    this.addLookupElement((XmlAttribute)ID_REF.fun((Object)tag), "#");
                    this.addLookupElement((XmlAttribute)FRAGMENT.fun((Object)tag), "");
                    super.visitXmlTag(tag);
                }

                private void addLookupElement(@Nullable XmlAttribute attribute, String prefix) {
                    if (attribute != null && StringUtil.isNotEmpty((String)attribute.getValue())) {
                        results.add(LookupElementBuilder.create((String)(prefix + attribute.getValue())).bold().withIcon(ThymeleafIcons.Thymeleaf));
                    }
                }
            });
        }
        Object[] objectArray = ArrayUtil.toObjectArray(results);
        if (objectArray == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(8);
        }
        return objectArray;
    }

    public boolean isSoft() {
        PsiElement element = this.getElement();
        ThymesTemplateNameSelectorExpression selectionExpression = (ThymesTemplateNameSelectorExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ThymesTemplateNameSelectorExpression.class);
        if (selectionExpression != null) {
            ThymesPathTemplateSelector templateSelector = selectionExpression.getPathTemplateSelector();
            return templateSelector != null && !this.isSimpleSelector(templateSelector);
        }
        return false;
    }

    public boolean isSimpleSelector(@NotNull ThymesPathTemplateSelector templateSelector) {
        if (templateSelector == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(9);
        }
        return templateSelector.getTemplateNameList().size() == 1;
    }

    public PsiElement resolve() {
        String fragmentName = this.getText();
        XmlFile templateFile = this.getTemplateFile();
        if (templateFile != null) {
            String fragmentRef = fragmentName.startsWith("#") && fragmentName.length() > 1 ? fragmentName.substring(1) : fragmentName;
            PsiElement element = ThymeleafTemplateFragmentReferenceImpl.resolveTemplateFragment(templateFile, fragmentRef, fragmentName.startsWith("#") ? ID_REF : FRAGMENT);
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveTemplateFragment(@NotNull XmlFile file, final @NotNull String fragmentId, final Function<XmlTag, XmlAttribute> function) {
        if (file == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(10);
        }
        if (fragmentId == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(11);
        }
        final Ref result = new Ref();
        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                XmlAttribute attribute = (XmlAttribute)function.fun((Object)tag);
                if (attribute != null) {
                    ThymesTemplateFragment templateFragment = ThymeleafCommonUtil.getAttributeExpression(attribute, ThymesTemplateFragment.class);
                    if (templateFragment != null) {
                        if (fragmentId.equals(templateFragment.getText())) {
                            result.set((Object)PomService.convertToPsi((Project)tag.getProject(), (PomTarget)new ThymeleafFragmentPomTarget(templateFragment)));
                            return;
                        }
                    } else if (fragmentId.equals(attribute.getValue())) {
                        result.set((Object)attribute.getValueElement());
                    }
                }
                super.visitXmlTag(tag);
            }
        });
        return (PsiElement)result.get();
    }

    @Nullable
    public XmlFile getTemplateFile() {
        PsiElement element = this.getElement();
        ThymesTemplateSelectionExpression selectionExpression = (ThymesTemplateSelectionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ThymesTemplateSelectionExpression.class);
        if (selectionExpression != null) {
            ThymesTemplateNameSelectorExpression tnse = ThymeleafTemplateFragmentReferenceImpl.findThymesTemplateNameSelectorExpression(selectionExpression);
            if (tnse != null) {
                ThymesPathTemplateSelector pathTemplateSelector = tnse.getPathTemplateSelector();
                if (pathTemplateSelector != null) {
                    PsiElement templateFile;
                    List<ThymesTemplateName> list = pathTemplateSelector.getTemplateNameList();
                    if (list.isEmpty()) {
                        return null;
                    }
                    ThymesTemplateName templateName = list.get(list.size() - 1);
                    if (templateName != null && (templateFile = templateName.resolve()) instanceof XmlFile) {
                        return (XmlFile)templateFile;
                    }
                }
            } else {
                PsiFile file = ThymeleafTemplateNameReferenceImpl.getOriginalContainingFile(this.getContainingFile());
                return file instanceof XmlFile ? (XmlFile)file : null;
            }
        }
        return null;
    }

    @Nullable
    private static ThymesTemplateNameSelectorExpression findThymesTemplateNameSelectorExpression(ThymesTemplateSelectionExpression expression) {
        for (ThymesElExpression elExpression : expression.getElExpressionList()) {
            if (!(elExpression instanceof ThymesTemplateNameSelectorExpression)) continue;
            return (ThymesTemplateNameSelectorExpression)elExpression;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateFragmentReferenceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateSelector";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateFragmentReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateFragmentReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleSelector";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveTemplateFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

