/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafPsiCompositeElementImpl;
import com.intellij.thymeleaf.lang.support.ThymeleafBundleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThymeleafMessageReferenceImpl
extends ThymeleafPsiCompositeElementImpl {
    public ThymeleafMessageReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            ThymeleafMessageReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PsiReference getReference() {
        return new PropertyReference(this.getText(), this, null, false){

            @Nullable
            protected List<PropertiesFile> getPropertiesFiles() {
                HashSet<PropertiesFile> files = new HashSet<PropertiesFile>();
                for (ThymeleafBundleProvider provider : ThymeleafBundleProvider.EP_NAME.getExtensionList()) {
                    files.addAll(provider.getPropertiesFile(ThymeleafMessageReferenceImpl.this));
                }
                return new ArrayList<PropertiesFile>(files);
            }

            public Object @NotNull [] getVariants() {
                THashSet allVariants = new THashSet();
                List<PropertiesFile> files = this.getPropertiesFiles();
                if (files != null) {
                    for (PropertiesFile propertiesFile : files) {
                        PropertiesPsiCompletionUtil.addVariantsFromFile((PropertyReferenceBase)this, (PropertiesFile)propertiesFile, (Set)allVariants);
                    }
                }
                HashMap<String, LookupElementBuilder> filtered = new HashMap<String, LookupElementBuilder>();
                for (Object variant : allVariants) {
                    IProperty property;
                    String propertyKey;
                    if (variant instanceof String) {
                        filtered.put((String)variant, LookupElementBuilder.create((String)((String)variant)).withIcon(PlatformIcons.PROPERTY_ICON));
                    }
                    if (!(variant instanceof IProperty) || (propertyKey = (property = (IProperty)variant).getKey()) == null) continue;
                    filtered.put(propertyKey, LookupElementBuilder.create((String)propertyKey).withIcon(PlatformIcons.PROPERTY_ICON));
                }
                Object[] objectArray = ArrayUtil.toObjectArray(filtered.values());
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            public LocalQuickFix[] getQuickFixes() {
                return new LocalQuickFix[]{PropertiesQuickFixFactory.getInstance().createCreatePropertyFix(this.myElement, this.myKey, this.getPropertiesFiles())};
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(1);
                }
                return super.handleElementRename(newElementName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/thymeleaf/lang/psi/impl/ThymeleafMessageReferenceImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/thymeleaf/lang/psi/impl/ThymeleafMessageReferenceImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafMessageReferenceImpl", "<init>"));
    }
}

