/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.injectors;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafExpressionsInjector
implements MultiHostInjector {
    private static Condition<String> createUrlExpressionCondition() {
        return s -> s != null && s.trim().startsWith("@{");
    }

    private static Condition<String> createAttrNameCondition(String ... attrNames) {
        return localName -> {
            for (String name : attrNames) {
                if (!localName.equals(name)) continue;
                return true;
            }
            return false;
        };
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        int endOffset;
        if (registrar == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(0);
        }
        if (host == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(1);
        }
        if (!ThymeleafCommonUtil.hasThymeleafLibrary(host.getProject())) {
            return;
        }
        ThymeleafLanguage languageToInject = this.getLanguageToInject((XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)host, XmlAttribute.class));
        if (languageToInject != null && (endOffset = host.getTextLength() - 1) > 0) {
            registrar.startInjecting((Language)languageToInject).addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.create((int)1, (int)endOffset)).doneInjecting();
        }
    }

    @Nullable
    public ThymeleafLanguage getLanguageToInject(@Nullable XmlAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            return null;
        }
        String attrName = ThymeleafExpressionsInjector.getThymeleafAttrName(xmlAttribute);
        if (attrName != null) {
            for (Map.Entry<Condition<String>, ThymeleafLanguage> entry : Holder.attrNameInjectors.entrySet()) {
                if (!entry.getKey().value((Object)attrName)) continue;
                return entry.getValue();
            }
            String namespace = xmlAttribute.getNamespace();
            for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(xmlAttribute.getProject())) {
                for (String ns : dialect.getNamespaces()) {
                    if (!ns.equals(namespace)) continue;
                    return dialect.getLanguage();
                }
            }
            String string = xmlAttribute.getValue();
            if (StringUtil.isNotEmpty((String)string)) {
                for (Map.Entry<Condition<String>, ThymeleafLanguage> valueConditions : Holder.attrValueInjectors.entrySet()) {
                    if (!valueConditions.getKey().value((Object)string)) continue;
                    return valueConditions.getValue();
                }
            }
            return ThymeleafLanguage.EXPRESSIONS;
        }
        return null;
    }

    @Nullable
    public static String getThymeleafAttrName(@NotNull XmlAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(2);
        }
        String localName = xmlAttribute.getLocalName();
        String namespace = xmlAttribute.getNamespace();
        if (ThymeleafCommonUtil.isThymeleafNamespace(namespace, xmlAttribute.getProject()) || StringUtil.isEmptyOrSpaces((String)namespace) && "th".equals(xmlAttribute.getNamespacePrefix())) {
            return localName;
        }
        return ThymeleafExpressionsInjector.getThymeleafAttrNameHtml5(xmlAttribute);
    }

    @Nullable
    public static String getThymeleafAttrNameHtml5(@NotNull XmlAttribute xmlAttribute) {
        String prefix;
        String prefixByNamespace;
        if (xmlAttribute == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(3);
        }
        String localName = xmlAttribute.getLocalName();
        XmlTag tag = xmlAttribute.getParent();
        if (tag != null && (prefixByNamespace = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(tag)) != null && localName.startsWith(prefix = "data-" + prefixByNamespace + "-")) {
            return localName.substring(prefix.length());
        }
        return null;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlAttributeValue>> list = Collections.singletonList(XmlAttributeValue.class);
        if (list == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThymeleafAttrName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThymeleafAttrNameHtml5";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final Map<Condition<String>, ThymeleafLanguage> attrNameInjectors = new HashMap<Condition<String>, ThymeleafLanguage>();
        private static final Map<Condition<String>, ThymeleafLanguage> attrValueInjectors = new HashMap<Condition<String>, ThymeleafLanguage>();

        private Holder() {
        }

        static {
            attrNameInjectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("each"), ThymeleafLanguage.EACH_EXPRESSIONS);
            attrNameInjectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("href", "src", "action"), ThymeleafLanguage.URL_EXPRESSIONS);
            attrNameInjectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("include", "remove", "replace", "substituteby", "insert"), ThymeleafLanguage.TEMPLATES_EXPRESSIONS);
            attrNameInjectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("fragment"), ThymeleafLanguage.TEMPLATES_FRAGMENT_EXPRESSIONS);
            attrValueInjectors.put(ThymeleafExpressionsInjector.createUrlExpressionCondition(), ThymeleafLanguage.URL_EXPRESSIONS);
        }
    }
}

