/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.html5;

import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.dialects.ThymeleafElementProcessor;
import com.intellij.thymeleaf.html5.ThymeleafXmlElementDescriptor;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafNamespaceDescriptorProvider
implements ImplicitNamespaceDescriptorProvider {
    @Nullable
    public XmlNSDescriptor getNamespaceDescriptor(@Nullable Module module, @NotNull String ns, @Nullable PsiFile file) {
        if (ns == null) {
            ThymeleafNamespaceDescriptorProvider.$$$reportNull$$$0(0);
        }
        if (ThymeleafCommonUtil.isThymeleafNamespace(ns, module != null ? module.getProject() : null)) {
            return new ThymeleafNamespaceDescriptor();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptorProvider", "getNamespaceDescriptor"));
    }

    private static class ThymeleafNamespaceDescriptor
    extends XmlNSDescriptorImpl {
        private ThymeleafNamespaceDescriptor() {
        }

        public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument doc) {
            if (doc == null) {
                if (XmlElementDescriptor.EMPTY_ARRAY == null) {
                    ThymeleafNamespaceDescriptor.$$$reportNull$$$0(0);
                }
                return XmlElementDescriptor.EMPTY_ARRAY;
            }
            Set<XmlElementDescriptor> descriptors = this.getAllDescriptors(doc.getRootTag());
            XmlElementDescriptor[] xmlElementDescriptorArray = descriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
            if (xmlElementDescriptorArray == null) {
                ThymeleafNamespaceDescriptor.$$$reportNull$$$0(1);
            }
            return xmlElementDescriptorArray;
        }

        @NotNull
        public Set<XmlElementDescriptor> getAllDescriptors(@Nullable XmlTag tag) {
            HashSet<XmlElementDescriptor> descriptors = new HashSet<XmlElementDescriptor>();
            if (tag != null) {
                final PsiFile containingFile = tag.getContainingFile();
                for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(tag.getProject())) {
                    String prefix;
                    if (!dialect.isSupported(tag.getProject()) || (prefix = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(tag, dialect.getNamespaces())) == null) continue;
                    for (ThymeleafElementProcessor elementProcessor : dialect.getElementProcessors()) {
                        String name = elementProcessor.getName();
                        if (!StringUtil.isNotEmpty((String)name)) continue;
                        descriptors.add(new ThymeleafXmlElementDescriptor((XmlNSDescriptor)this, prefix, name){

                            @Override
                            public PsiElement getDeclaration() {
                                return containingFile;
                            }
                        });
                    }
                }
            }
            HashSet<XmlElementDescriptor> hashSet = descriptors;
            if (hashSet == null) {
                ThymeleafNamespaceDescriptor.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
            String ns;
            if (tag == null) {
                ThymeleafNamespaceDescriptor.$$$reportNull$$$0(3);
            }
            if (ThymeleafCommonUtil.isThymeleafNamespace(ns = tag.getNamespace(), tag.getProject())) {
                Set<XmlElementDescriptor> descriptors = this.getAllDescriptors(tag);
                for (XmlElementDescriptor descriptor : descriptors) {
                    if (!tag.getName().equals(descriptor.getDefaultName())) continue;
                    return descriptor;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptorProvider$ThymeleafNamespaceDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootElementsDescriptors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllDescriptors";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptorProvider$ThymeleafNamespaceDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementDescriptor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

