/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.thymeleaf.highlighting.fixes.DeclareThymeleafVarInCommentFix;
import com.intellij.thymeleaf.lang.psi.ThymesELSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesOgnlExpression;
import com.intellij.thymeleaf.lang.psi.ThymesVisitor;
import com.intellij.thymeleaf.resources.ThymeleafBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ThymeleafVariablesResolveInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "ThymeleafVariablesResolveInspection";

    @NotNull
    public String getGroupDisplayName() {
        String string = ThymeleafBundle.message("thymeleaf.inspection.group", new Object[0]);
        if (string == null) {
            ThymeleafVariablesResolveInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ThymeleafVariablesResolveInspection.$$$reportNull$$$0(1);
        }
        return new ThymesVisitor(){

            @Override
            public void visitELVariable(@NotNull ThymesELVariable variable) {
                PsiReference reference;
                if (variable == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((reference = variable.getReference()) == null || reference.isSoft()) {
                    return;
                }
                PsiElement results = reference.resolve();
                if (results == null) {
                    holder.registerProblem((PsiElement)variable, ThymeleafBundle.message("ThymeleafVariablesResolveInspection.cannot.resolve.variable", variable.getText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.getFixes(variable));
                }
            }

            public LocalQuickFix[] getFixes(ThymesELVariable variable) {
                PsiElement parent = variable.getParent();
                if (parent instanceof ThymesELSelectExpression || parent instanceof ThymesOgnlExpression) {
                    return new LocalQuickFix[]{new DeclareThymeleafVarInCommentFix(variable.getText())};
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection$1", "visitELVariable"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

