/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml.pom;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamHeader;
import com.intellij.spring.integration.model.jam.SpringMessagingHeader;
import com.intellij.spring.integration.model.jam.SpringMessagingJamHeader;
import com.intellij.spring.integration.model.xml.core.Chain;
import com.intellij.spring.integration.model.xml.core.Gateway;
import com.intellij.spring.integration.model.xml.core.GatewayMethod;
import com.intellij.spring.integration.model.xml.core.Header;
import com.intellij.spring.integration.model.xml.core.HeaderEnricherType;
import com.intellij.spring.integration.model.xml.core.HeaderSubElement;
import com.intellij.spring.integration.model.xml.core.HeaderValueRouterType;
import com.intellij.spring.integration.model.xml.core.InboundChannelAdapter;
import com.intellij.spring.integration.model.xml.core.UserDefinedHeader;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.CommonProcessors;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringIntegrationHeadersFactory {
    private static final NullableFunction<SpringMessagingHeader, String> HEADER_NAME_FUNCTION = springIntegrationHeader -> {
        String name = springIntegrationHeader.getName();
        return StringUtil.isEmptyOrSpaces((String)name) ? null : name;
    };
    private static final CommonSpringModelVisitorContext.Exec<String> DOM_HEADER_NAMES = (m, p) -> {
        if (!(m instanceof LocalXmlModel)) {
            return true;
        }
        DomFileElement beansFileElement = ((LocalXmlModel)m).getRoot();
        if (beansFileElement == null) {
            return true;
        }
        Beans beans = (Beans)beansFileElement.getRootElement();
        for (Gateway gateway : DomUtil.getChildrenOfType((DomElement)beans, Gateway.class)) {
            for (GatewayMethod gatewayMethod : gateway.getMethods()) {
                for (Header header : gatewayMethod.getHeaders()) {
                    if (SpringIntegrationHeadersFactory.processIfNotNull((Processor<String>)p, header.getName().getStringValue())) continue;
                    return false;
                }
            }
        }
        for (InboundChannelAdapter adapter : DomUtil.getChildrenOfType((DomElement)beans, InboundChannelAdapter.class)) {
            for (HeaderSubElement headerSubElement : adapter.getHeaders()) {
                if (SpringIntegrationHeadersFactory.processIfNotNull((Processor<String>)p, headerSubElement.getName().getStringValue())) continue;
                return false;
            }
        }
        for (Chain chain : DomUtil.getChildrenOfType((DomElement)beans, Chain.class)) {
            for (HeaderValueRouterType headerValueRouterType : chain.getHeaderValueRouters()) {
                if (SpringIntegrationHeadersFactory.processIfNotNull((Processor<String>)p, headerValueRouterType.getHeaderName().getStringValue())) continue;
                return false;
            }
            for (HeaderEnricherType headerEnricherType : chain.getHeaderEnrichers()) {
                for (UserDefinedHeader userDefinedHeader : headerEnricherType.getHeaders()) {
                    if (SpringIntegrationHeadersFactory.processIfNotNull((Processor<String>)p, userDefinedHeader.getName().getStringValue())) continue;
                    return false;
                }
            }
        }
        for (HeaderEnricherType headerEnricherType : DomUtil.getChildrenOfType((DomElement)beans, HeaderEnricherType.class)) {
            for (UserDefinedHeader userDefinedHeader : headerEnricherType.getHeaders()) {
                if (SpringIntegrationHeadersFactory.processIfNotNull((Processor<String>)p, userDefinedHeader.getName().getStringValue())) continue;
                return false;
            }
        }
        return true;
    };

    private SpringIntegrationHeadersFactory() {
    }

    public static Set<String> getHeaders(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(1);
        }
        HashSet<String> headers = new HashSet<String>();
        SpringIntegrationHeadersFactory.addDomConfiguredHeaders(headers, module);
        SpringIntegrationHeadersFactory.addJamHeaders(headers, module, scope);
        return headers;
    }

    private static void addJamHeaders(@NotNull Set<String> headers, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (headers == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(2);
        }
        if (module == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(4);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List integrationHeaders = jamService.getJamParameterElements(SpringIntegrationJamHeader.META.getJamKey(), "org.springframework.integration.annotation.Header", scope);
        List messagingHeaders = jamService.getJamParameterElements(SpringMessagingJamHeader.META.getJamKey(), "org.springframework.messaging.handler.annotation.Header", scope);
        headers.addAll(ContainerUtil.mapNotNull((Collection)ContainerUtil.concat((List)integrationHeaders, (List)messagingHeaders), HEADER_NAME_FUNCTION));
    }

    private static void addDomConfiguredHeaders(@NotNull Set<String> headers, @NotNull Module module) {
        if (headers == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SpringIntegrationHeadersFactory.$$$reportNull$$$0(6);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(headers);
        SpringModelVisitors.visitRelatedModels((CommonSpringModel)SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module), (CommonSpringModelVisitorContext)CommonSpringModelVisitorContext.context((Processor)processor, DOM_HEADER_NAMES));
    }

    private static boolean processIfNotNull(Processor<String> processor, @Nullable String headerName) {
        return headerName == null || processor.process((Object)headerName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/integration/model/xml/pom/SpringIntegrationHeadersFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHeaders";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addJamHeaders";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addDomConfiguredHeaders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

