/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections.jam;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.inspections.jam.SpringIntegrationJamModelInspectionBase;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamInboundChannelAdapter;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamPoller;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamPollingMethodEndpoint;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationMethodEndpointInconsistencyInspection
extends SpringIntegrationJamModelInspectionBase {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        if (aClass == null) {
            SpringIntegrationMethodEndpointInconsistencyInspection.$$$reportNull$$$0(0);
        }
        SemService semService = SemService.getSemService((Project)aClass.getProject());
        for (PsiMethod psiMethod : aClass.getMethods()) {
            List endpoints = semService.getSemElements(SpringIntegrationJamPollingMethodEndpoint.POLLING_ENDPOINT_JAM_KEY, (PsiElement)psiMethod);
            for (SpringIntegrationJamPollingMethodEndpoint endpoint : endpoints) {
                SpringIntegrationMethodEndpointInconsistencyInspection.checkPollingEndpoint(endpoint, psiMethod, holder);
            }
        }
    }

    private static void checkPollingEndpoint(SpringIntegrationJamPollingMethodEndpoint endpoint, PsiMethod psiMethod, ProblemsHolder holder) {
        List<SpringIntegrationJamPoller> pollers = endpoint.getPollers();
        for (SpringIntegrationJamPoller poller : pollers) {
            SpringIntegrationMethodEndpointInconsistencyInspection.checkPoller(poller, holder);
        }
        if (pollers.size() > 1) {
            SpringIntegrationMethodEndpointInconsistencyInspection.registerProblem(endpoint, holder, SpringIntegrationBundle.message("SpringIntegrationMethodEndpointInconsistencyInspection.multiple.pollers", new Object[0]));
        }
        if (endpoint instanceof SpringIntegrationJamInboundChannelAdapter) {
            CommonSpringModel model;
            SpringIntegrationMethodEndpointInconsistencyInspection.checkInboundChannelAdapterMethod(psiMethod, holder);
            if (pollers.isEmpty() && SpringModelSearchers.findBean((CommonSpringModel)(model = SpringModelUtils.getInstance().getSpringModel((PsiElement)psiMethod)), (String)"org.springframework.integration.context.defaultPollerMetadata") == null) {
                SpringIntegrationMethodEndpointInconsistencyInspection.registerProblem(endpoint, holder, SpringIntegrationBundle.message("SpringIntegrationMethodEndpointInconsistencyInspection.no.poller", new Object[0]));
            }
        }
    }

    private static void registerProblem(SpringIntegrationJamPollingMethodEndpoint endpoint, ProblemsHolder holder, @InspectionMessage String message) {
        PsiAnnotation psiAnnotation = endpoint.getAnnotation();
        if (psiAnnotation == null) {
            return;
        }
        PsiJavaCodeReferenceElement elementToReport = psiAnnotation.getNameReferenceElement();
        if (elementToReport == null) {
            elementToReport = psiAnnotation;
        }
        holder.registerProblem((PsiElement)elementToReport, message, new LocalQuickFix[0]);
    }

    private static void checkPoller(SpringIntegrationJamPoller poller, ProblemsHolder holder) {
        PsiAnnotation psiAnnotation = (PsiAnnotation)poller.getPsiElement().getPsiElement();
        if (psiAnnotation == null) {
            return;
        }
        PsiJavaCodeReferenceElement elementToReport = psiAnnotation.getNameReferenceElement();
        if (elementToReport == null) {
            elementToReport = psiAnnotation;
        }
        if (!StringUtil.isEmptyOrSpaces((String)poller.getValue())) {
            if (!(StringUtil.isEmptyOrSpaces((String)poller.getTrigger()) && StringUtil.isEmptyOrSpaces((String)poller.getTaskExecutor()) && StringUtil.isEmptyOrSpaces((String)poller.getMaxMessagesPerPoll()) && StringUtil.isEmptyOrSpaces((String)poller.getFixedDelay()) && StringUtil.isEmptyOrSpaces((String)poller.getFixedRate()) && StringUtil.isEmptyOrSpaces((String)poller.getCron()))) {
                holder.registerProblem((PsiElement)elementToReport, SpringIntegrationBundle.message("SpringIntegrationMethodEndpointInconsistencyInspection.mutually.exclusive.attrs", "value"), new LocalQuickFix[0]);
            }
        } else if (!StringUtil.isEmptyOrSpaces((String)poller.getTrigger())) {
            if (!(StringUtil.isEmptyOrSpaces((String)poller.getFixedDelay()) && StringUtil.isEmptyOrSpaces((String)poller.getFixedRate()) && StringUtil.isEmptyOrSpaces((String)poller.getCron()))) {
                holder.registerProblem((PsiElement)elementToReport, SpringIntegrationBundle.message("SpringIntegrationMethodEndpointInconsistencyInspection.mutually.exclusive.attrs", "trigger"), new LocalQuickFix[0]);
            }
        } else if (!StringUtil.isEmptyOrSpaces((String)poller.getCron())) {
            if (!StringUtil.isEmptyOrSpaces((String)poller.getFixedDelay()) || !StringUtil.isEmptyOrSpaces((String)poller.getFixedRate())) {
                holder.registerProblem((PsiElement)elementToReport, SpringIntegrationBundle.message("SpringIntegrationMethodEndpointInconsistencyInspection.mutually.exclusive.attrs", "cron"), new LocalQuickFix[0]);
            }
        } else if (!StringUtil.isEmptyOrSpaces((String)poller.getFixedDelay()) && !StringUtil.isEmptyOrSpaces((String)poller.getFixedRate())) {
            holder.registerProblem((PsiElement)elementToReport, SpringIntegrationBundle.message("SpringIntegrationMethodEndpointInconsistencyInspection.mutually.exclusive.attrs", "fixedDelay"), new LocalQuickFix[0]);
        }
    }

    private static void checkInboundChannelAdapterMethod(PsiMethod psiMethod, ProblemsHolder holder) {
        PsiIdentifier psiIdentifier = psiMethod.getNameIdentifier();
        if (psiIdentifier == null) {
            return;
        }
        if (PsiType.VOID.equals((Object)psiMethod.getReturnType())) {
            holder.registerProblem((PsiElement)psiIdentifier, SpringIntegrationBundle.message("SpringIntegrationMethodEndpointInconsistencyInspection.void.inbound.channel", new Object[0]), new LocalQuickFix[0]);
        }
        if (!psiMethod.getParameterList().isEmpty()) {
            holder.registerProblem((PsiElement)psiIdentifier, SpringIntegrationBundle.message("SpringIntegrationMethodEndpointInconsistencyInspection.inbound.channel.adapter.with.params", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/integration/inspections/jam/SpringIntegrationMethodEndpointInconsistencyInspection", "checkClass"));
    }
}

