/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.injection.el;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.DefiniteLightVariable;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.JspImplicitVariableWithCustomResolve;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class SpringIntegrationELContextVariables
extends SpringElContextsExtension {
    private static final List<String> ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.messaging.handler.annotation.Payload", "org.springframework.integration.annotation.Payload"});

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement psiElement) {
        PsiElement context;
        if (psiElement == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(0);
        }
        if ((context = psiElement.getContext()) == null || !SpringIntegrationELContextVariables.isIntegrationAnnotation(context)) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringIntegrationELContextVariables.$$$reportNull$$$0(1);
            }
            return list;
        }
        SmartList variables = new SmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
        if (method != null) {
            variables.addAll(Arrays.asList(method.getParameterList().getParameters()));
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)context, PsiAnnotation.class);
            if (annotation != null) {
                SpringIntegrationELContextVariables.addPayloadVariables(annotation, (Collection<? super PsiVariable>)variables, method);
            }
        }
        SmartList smartList = variables;
        if (smartList == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static void addPayloadVariables(@NotNull PsiAnnotation annotation, @NotNull Collection<? super PsiVariable> variables, @NotNull PsiMethod method) {
        if (annotation == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(3);
        }
        if (variables == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(4);
        }
        if (method == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(5);
        }
        if (ANNOTATIONS.contains(annotation.getQualifiedName())) {
            PsiType returnType = method.getReturnType();
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnType != null && returnTypeElement != null) {
                variables.add((PsiVariable)new DefiniteLightVariable("return", returnType, (PsiElement)returnTypeElement).setBaseIcon(SpringApiIcons.Spring));
                variables.add((PsiVariable)new ArgsImplicitVariable(method));
            }
        }
    }

    private static boolean isIntegrationAnnotation(@NotNull PsiElement context) {
        UElement element;
        if (context == null) {
            SpringIntegrationELContextVariables.$$$reportNull$$$0(6);
        }
        if ((element = UastContextKt.toUElement((PsiElement)context)) == null) {
            return false;
        }
        UAnnotation annotation = (UAnnotation)UastUtils.getParentOfType((UElement)element, UAnnotation.class);
        return annotation != null && ANNOTATIONS.contains(annotation.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/injection/el/SpringIntegrationELContextVariables";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/injection/el/SpringIntegrationELContextVariables";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPayloadVariables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIntegrationAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArgsImplicitVariable
    extends LightVariableBuilder
    implements JspImplicitVariableWithCustomResolve {
        private final PsiMethod myMethod;

        ArgsImplicitVariable(PsiMethod method) {
            super("args", "java.util.Map", (PsiElement)method.getParameterList());
            this.myMethod = method;
            this.setBaseIcon(SpringApiIcons.Spring);
        }

        public boolean process(ELExpression element, ELElementProcessor processor) {
            for (PsiParameter variable : this.myMethod.getParameterList().getParameters()) {
                if (!processor.processVariable((PsiVariable)variable)) break;
            }
            return true;
        }
    }
}

