/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.converters;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.model.xml.http.HttpMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class HttpMethodListConverter
extends DelimitedListConverter<HttpMethod> {
    public HttpMethodListConverter() {
        super(", ");
    }

    protected HttpMethod convertString(@Nullable String string, ConvertContext context) {
        for (HttpMethod method : HttpMethod.values()) {
            if (!method.name().equals(string)) continue;
            return method;
        }
        return null;
    }

    protected String toString(@Nullable HttpMethod method) {
        return method != null ? method.name() : null;
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<? extends List<HttpMethod>> genericDomValue) {
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(HttpMethod.values().length);
        for (HttpMethod method : HttpMethod.values()) {
            variants.add(LookupElementBuilder.create((String)method.name()));
        }
        return ArrayUtil.toObjectArray(variants);
    }

    protected PsiElement resolveReference(@Nullable HttpMethod method, ConvertContext context) {
        return method != null ? context.getXmlElement() : null;
    }

    protected String getUnresolvedMessage(String value) {
        return SpringIntegrationBundle.message("http.method.unresolved.message", value);
    }
}

