/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ReverseListIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class SequenceExtent<T extends Item<?>>
implements GroundedValue<T> {
    private List<T> value;

    public SequenceExtent(T[] items) {
        this.value = Arrays.asList(items);
    }

    public SequenceExtent(SequenceExtent<T> ext, int start, int length) {
        this.value = ext.value.subList(start, start + length);
    }

    public SequenceExtent(List<T> list) {
        this.value = list;
    }

    public SequenceExtent(SequenceIterator<T> iter) throws XPathException {
        int len = (iter.getProperties() & 2) == 0 ? 20 : ((LastPositionFinder)((Object)iter)).getLength();
        ArrayList<T> list = new ArrayList<T>(len);
        iter.forEachOrFail(list::add);
        this.value = list;
    }

    public static <T extends Item<?>> GroundedValue<? extends T> makeSequenceExtent(SequenceIterator<T> iter) throws XPathException {
        return iter.materialize();
    }

    public static <T extends Item<?>> GroundedValue<T> fromIterator(SequenceIterator<T> iter) throws XPathException {
        return new SequenceExtent<T>(iter).reduce();
    }

    public static <T extends Item<?>> GroundedValue<T> makeResidue(SequenceIterator<T> iter) throws XPathException {
        if ((iter.getProperties() & 1) != 0) {
            return ((GroundedIterator)iter).getResidue();
        }
        SequenceExtent<T> extent = new SequenceExtent<T>(iter);
        return extent.reduce();
    }

    public static <T extends Item<?>> GroundedValue<T> makeSequenceExtent(List<T> input) {
        int len = input.size();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return (GroundedValue)input.get(0);
        }
        return new SequenceExtent<T>(input);
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public T head() {
        return this.itemAt(0);
    }

    @Override
    public int getLength() {
        return this.value.size();
    }

    public int getCardinality() {
        switch (this.value.size()) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    @Override
    public T itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return (T)((Item)this.value.get(n));
    }

    @Override
    public ListIterator<T> iterate() {
        return new ListIterator<T>(this.value);
    }

    public UnfailingIterator<T> reverseIterate() {
        return new ReverseListIterator<T>(this.value);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        int len = this.getLength();
        if (len == 0) {
            return false;
        }
        Item first = (Item)this.value.get(0);
        if (first instanceof NodeInfo) {
            return true;
        }
        if (len == 1 && first instanceof AtomicValue) {
            return first.effectiveBooleanValue();
        }
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public GroundedValue<T> subsequence(int start, int length) {
        int newEnd;
        int end = this.value.size();
        if (start < 0) {
            start = 0;
        } else if (start >= end) {
            return EmptySequence.getInstance();
        }
        int newStart = start;
        if (length > end) {
            newEnd = end;
        } else {
            if (length < 0) {
                return EmptySequence.getInstance();
            }
            newEnd = newStart + length;
            if (newEnd > end) {
                newEnd = end;
            }
        }
        return new SequenceExtent<T>(this.value.subList(newStart, newEnd));
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        for (int i = 0; i < this.value.size(); ++i) {
            fsb.append(i == 0 ? "(" : ", ");
            fsb.append(((Item)this.value.get(i)).toString());
        }
        fsb.append(')');
        return fsb.toString();
    }

    @Override
    public GroundedValue<T> reduce() {
        int len = this.getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return this.itemAt(0);
        }
        return this;
    }

    @Override
    public Iterable<T> asIterable() {
        return this.value;
    }

    @Override
    public Iterator<T> iterator() {
        return this.value.iterator();
    }
}

