/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.plugins.webDeployment.WDBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeploymentNotifier {
    private static final NotificationGroup BALLOON_GROUP = NotificationGroup.balloonGroup((String)"FTP/SFTP Connectivity", (String)DeploymentNotifier.getWebDeploymentBalloonGroup());

    private DeploymentNotifier() {
    }

    public static void notifyWithBalloon(@Nullable @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message, NotificationType messageType, @Nullable NotificationListener listener, Project project, @Nullable ToolWindowIdProvider toolWindowIdProvider) {
        ToolWindow toolWindow = null;
        if (toolWindowIdProvider != null && project != null && !project.isDefault()) {
            ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project);
            toolWindow = mgr.getToolWindow(toolWindowIdProvider.getId());
        }
        if (toolWindow == null) {
            BALLOON_GROUP.createNotification(StringUtil.notNullize((String)title), message, messageType, listener).notify(project);
            return;
        }
        ToolWindowManager.getInstance((Project)project).invokeLater(() -> toolWindowIdProvider.getGroup().createNotification(StringUtil.notNullize((String)title), message, messageType, listener).notify(project));
    }

    @NlsContexts.NotificationTitle
    private static String getWebDeploymentBalloonGroup() {
        return WDBundle.message("web.deployment.balloon.group.id", new Object[0]);
    }

    public static class ToolWindowIdProvider {
        @NotNull
        @NonNls
        private final String myId;
        private final Supplier<@Nls String> myToolwindowTitleSupplier;

        public ToolWindowIdProvider(@NonNls @NotNull String toolWindowId, Supplier<@Nls String> toolwindowTitleSupplier) {
            if (toolWindowId == null) {
                ToolWindowIdProvider.$$$reportNull$$$0(0);
            }
            this.myId = toolWindowId;
            this.myToolwindowTitleSupplier = toolwindowTitleSupplier;
        }

        @NonNls
        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                ToolWindowIdProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        public NotificationGroup getGroup() {
            return NotificationGroup.toolWindowGroup((String)(BALLOON_GROUP.getDisplayId() + ": " + this.myToolwindowTitleSupplier.get()), (String)this.myId, (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/DeploymentNotifier$ToolWindowIdProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/DeploymentNotifier$ToolWindowIdProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

