/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class CompositeDiffElement
extends DiffElement
implements AsyncDiffElement {
    private static final Logger LOG = Logger.getInstance(CompositeDiffElement.class);
    private final PublishConfig myConfig;
    private final Deployable myServer;
    private final DirDiffSettings myDiffSettings;
    private final List<DiffRoot> myDirectories;
    private final boolean myLocal;
    private DiffElement[] myChildren;
    @NotNull
    protected final Project myProject;
    protected final RemoteConnection myConnection;
    private boolean myContainsDirs;
    private boolean myContainsFiles;

    public static DiffElement createRootLocalDiffElement(@NotNull List<DiffRoot> files, @NotNull PublishConfig config, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project) throws FileSystemException {
        DiffRoot pair;
        if (files == null) {
            CompositeDiffElement.$$$reportNull$$$0(0);
        }
        if (config == null) {
            CompositeDiffElement.$$$reportNull$$$0(1);
        }
        if (server == null) {
            CompositeDiffElement.$$$reportNull$$$0(2);
        }
        if (diffSettings == null) {
            CompositeDiffElement.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CompositeDiffElement.$$$reportNull$$$0(4);
        }
        if (files.size() == 1 && (pair = files.get(0)).getLocal() != null && pair.getLocal().isDirectory() && pair.getRemote().exists()) {
            VirtualFile localItem = pair.getLocal();
            boolean excluded = SyncUtils.isExcludedLocalOrCorresponding(localItem.getPath(), pair.getMapping(), server, config, diffSettings);
            return new LocalItemDiffElement(localItem, pair.getMapping(), config, server, excluded, diffSettings, project, true);
        }
        try {
            return new LocalCompositeDiffElement(files, config, server, diffSettings, project);
        }
        catch (FileSystemException e) {
            LOG.error("No exceptions should occur here", (Throwable)e);
            return null;
        }
    }

    public static DiffElement createRootRemoteDiffElement(@NotNull List<DiffRoot> files, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project, @NotNull RemoteConnection connection) throws FileSystemException {
        DiffRoot pair;
        if (files == null) {
            CompositeDiffElement.$$$reportNull$$$0(5);
        }
        if (server == null) {
            CompositeDiffElement.$$$reportNull$$$0(6);
        }
        if (diffSettings == null) {
            CompositeDiffElement.$$$reportNull$$$0(7);
        }
        if (project == null) {
            CompositeDiffElement.$$$reportNull$$$0(8);
        }
        if (connection == null) {
            CompositeDiffElement.$$$reportNull$$$0(9);
        }
        PublishConfig config = PublishConfig.getInstance(project);
        if (files.size() == 1 && (pair = files.get(0)).getLocal() != null && pair.getLocal().isDirectory() && pair.getRemote().exists()) {
            FileObject remoteItem = files.get(0).getRemote();
            boolean excluded = SyncUtils.isExcludedRemoteOrCorresponding(remoteItem, pair.getMapping(), server, config, diffSettings);
            return new RemoteItemDiffElement(connection, server, remoteItem, project, config, excluded, pair.getMapping(), diffSettings, true);
        }
        return new RemoteCompositeDiffElement(files, server, diffSettings, project, connection);
    }

    private CompositeDiffElement(@NotNull List<DiffRoot> directories, boolean local, @NotNull PublishConfig config, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project, @Nullable RemoteConnection connection) throws FileSystemException {
        if (directories == null) {
            CompositeDiffElement.$$$reportNull$$$0(10);
        }
        if (config == null) {
            CompositeDiffElement.$$$reportNull$$$0(11);
        }
        if (server == null) {
            CompositeDiffElement.$$$reportNull$$$0(12);
        }
        if (diffSettings == null) {
            CompositeDiffElement.$$$reportNull$$$0(13);
        }
        if (project == null) {
            CompositeDiffElement.$$$reportNull$$$0(14);
        }
        this.myConfig = config;
        this.myServer = server;
        this.myDiffSettings = diffSettings;
        this.myProject = project;
        this.myConnection = connection;
        this.myDirectories = directories;
        this.myLocal = local;
        this.initializeChildren();
        this.initializeContainedTypes();
    }

    private void initializeChildren() throws FileSystemException {
        MultiMap defaultNames = new MultiMap();
        for (DiffRoot entry : this.myDirectories) {
            boolean bl = this.myLocal ? entry.getLocal() != null && entry.getLocal().exists() : entry.getRemote().exists();
            boolean add = bl;
            if (!add) continue;
            defaultNames.putValue((Object)this.getRootName(entry, false), (Object)entry);
        }
        Map<String, DiffRoot> namedRoots = this.makeRootNamesDifferent((MultiMap<String, DiffRoot>)defaultNames);
        ArrayList<AsyncDiffElement> children = new ArrayList<AsyncDiffElement>(this.myDirectories.size());
        for (Map.Entry<String, DiffRoot> entry : namedRoots.entrySet()) {
            DiffRoot diffRoot = entry.getValue();
            boolean excluded = this.myLocal ? SyncUtils.isExcludedLocalOrCorresponding(diffRoot.getLocal().getPath(), diffRoot.getMapping(), this.myServer, this.myConfig, this.myDiffSettings) : SyncUtils.isExcludedRemoteOrCorresponding(diffRoot.getRemote(), diffRoot.getMapping(), this.myServer, this.myConfig, this.myDiffSettings);
            AsyncDiffElement element = this.myLocal ? new LocalItemDiffElement(diffRoot.getLocal(), diffRoot.getMapping(), this.myConfig, this.myServer, excluded, this.myDiffSettings, entry.getKey(), this.myProject, false) : new RemoteItemDiffElement(this.myConnection, this.myServer, diffRoot.getRemote(), this.myProject, this.myConfig, excluded, diffRoot.getMapping(), this.myDiffSettings, entry.getKey(), false);
            children.add(element);
        }
        this.myChildren = children.toArray(DiffElement.EMPTY_ARRAY);
    }

    private Map<String, DiffRoot> makeRootNamesDifferent(MultiMap<String, DiffRoot> rootNames) {
        HashMap<String, DiffRoot> namedRoots = new HashMap<String, DiffRoot>();
        for (Map.Entry entry : rootNames.entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                namedRoots.put((String)entry.getKey(), (DiffRoot)((Collection)entry.getValue()).iterator().next());
                continue;
            }
            for (DiffRoot root : (Collection)entry.getValue()) {
                namedRoots.put(this.getRootName(root, true), root);
            }
        }
        return namedRoots;
    }

    @NotNull
    private String getRootName(DiffRoot root, boolean forceLongName) {
        FileObject remote;
        if (this.myLocal) {
            VirtualFile local = root.getLocal();
            if (forceLongName || local.isDirectory()) {
                String localPath = local.getPath();
                return CompositeDiffElement.getRelativePathOfProjectFileInProject(localPath, this.myProject);
            }
        } else {
            remote = root.getRemote();
            if (forceLongName || ServerTreeNode.getFileType(remote).hasChildren()) {
                String localPath = root.getMapping().mapToLocalPath(remote, (Mappable)this.myServer);
                localPath = FileUtil.toSystemIndependentName((String)localPath);
                return CompositeDiffElement.getRelativePathOfProjectFileInProject(localPath, this.myProject);
            }
        }
        remote = root.getRemote();
        String simpleRemoteName = CompositeDiffElement.getSimpleRootName(remote);
        String localPath = root.getMapping().mapToLocalPath(remote, (Mappable)this.myServer);
        String simpleLocalName = StringUtil.getShortName((String)(localPath = FileUtil.toSystemIndependentName((String)localPath)), (char)'/');
        if (!simpleRemoteName.equals(simpleLocalName)) {
            String string = simpleLocalName + " -> " + simpleRemoteName;
            if (string == null) {
                CompositeDiffElement.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = simpleRemoteName;
        if (string == null) {
            CompositeDiffElement.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String getSimpleRootName(VirtualFile local) {
        String string = local.getName();
        if (string == null) {
            CompositeDiffElement.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static String getSimpleRootName(FileObject remote) {
        return remote.getName().getBaseName();
    }

    @NotNull
    private static String getRelativePathOfProjectFileInProject(@NotNull String localPath, Project project) {
        VirtualFile[] contentRoots;
        String path;
        VirtualFile baseDir;
        if (localPath == null) {
            CompositeDiffElement.$$$reportNull$$$0(18);
        }
        if ((baseDir = project.getBaseDir()) != null && (path = DeploymentPathUtils.getPathRemainder(baseDir.getPath(), localPath, baseDir.isCaseSensitive())) != null) {
            if (path.isEmpty()) {
                return CompositeDiffElement.getDistinguishableFromContentRootPath(baseDir.getName(), localPath);
            }
            return CompositeDiffElement.getDistinguishableFromContentRootPath(path, localPath);
        }
        for (VirtualFile root : contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            path = DeploymentPathUtils.getPathRemainder(root.getPath(), localPath, SystemInfo.isFileSystemCaseSensitive);
            if (path == null) continue;
            String name = root.getName();
            for (VirtualFile contentRoot : contentRoots) {
                if (!name.equals(contentRoot.getName()) || contentRoot.equals(root)) continue;
                String string = localPath;
                if (string == null) {
                    CompositeDiffElement.$$$reportNull$$$0(19);
                }
                return string;
            }
            String string = path.isEmpty() ? WDBundle.message("0.in.angle.brackets", root.getName()) : WDBundle.message("path.in.root.0.1", root.getName(), path);
            if (string == null) {
                CompositeDiffElement.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = localPath;
        if (string == null) {
            CompositeDiffElement.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String getDistinguishableFromContentRootPath(@NotNull String shortenedPath, @NotNull String fullDefaultPath) {
        if (shortenedPath == null) {
            CompositeDiffElement.$$$reportNull$$$0(22);
        }
        if (fullDefaultPath == null) {
            CompositeDiffElement.$$$reportNull$$$0(23);
        }
        if (!shortenedPath.startsWith("<")) {
            String string = shortenedPath;
            if (string == null) {
                CompositeDiffElement.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = fullDefaultPath;
        if (string == null) {
            CompositeDiffElement.$$$reportNull$$$0(25);
        }
        return string;
    }

    private void initializeContainedTypes() throws FileSystemException {
        this.myContainsDirs = false;
        this.myContainsFiles = false;
        for (DiffRoot pair : this.myDirectories) {
            if (pair.getLocal() != null) {
                this.myContainsDirs |= pair.getLocal().isDirectory();
                this.myContainsFiles |= !pair.getLocal().isDirectory();
            } else {
                FileType fileType = pair.getRemote().getType();
                this.myContainsDirs |= fileType == FileType.FOLDER;
                this.myContainsFiles |= fileType == FileType.FILE;
            }
            if (!this.myContainsDirs || !this.myContainsFiles) continue;
            return;
        }
    }

    public String getPath() {
        if (this.myDirectories.size() == 1) {
            DiffRoot pair = this.myDirectories.get(0);
            if (this.myLocal) {
                if (pair.getLocal() != null) {
                    return pair.getLocal().getPresentableUrl();
                }
                return pair.getMapping().mapToLocalPath(pair.getRemote(), (Mappable)this.myServer);
            }
            return this.myServer.getPresentablePath(pair.getRemote());
        }
        int state = 0;
        state += this.myContainsDirs ? 1 : 0;
        return WDBundle.message("composite.diff.element.name", state += this.myContainsFiles ? 2 : 0, this.myLocal ? 1 : 0);
    }

    @NotNull
    public String getName() {
        return "";
    }

    public long getSize() {
        return -1L;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public boolean isContainer() {
        return true;
    }

    public DiffElement[] getChildren() {
        if (!SyncLocalVsRemoteAction.isExcludedFileHidden(this.myDiffSettings)) {
            return this.myChildren;
        }
        ArrayList<DiffElement> elements = new ArrayList<DiffElement>();
        for (DiffElement element : this.myChildren) {
            if ((!(element instanceof LocalItemDiffElement) || ((LocalItemDiffElement)element).isExcluded()) && (!(element instanceof RemoteItemDiffElement) || ((RemoteItemDiffElement)element).isExcluded())) continue;
            elements.add(element);
        }
        return elements.toArray(DiffElement.EMPTY_ARRAY);
    }

    public byte[] getContent() {
        return null;
    }

    @Nullable
    public Object getValue() {
        return null;
    }

    public void refresh(boolean userInitiated) throws IOException {
        if (this.myLocal) {
            this.localRefreshFiles(userInitiated);
        } else {
            this.remoteRefreshFiles(userInitiated);
        }
        this.initializeChildren();
        this.initializeContainedTypes();
    }

    private void remoteRefreshFiles(boolean userInitiated) throws IOException {
        if (!userInitiated) {
            return;
        }
        for (DiffRoot pair : this.myDirectories) {
            FileObject file = pair.getRemote();
            try {
                this.myConnection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> file.refresh()), null);
            }
            catch (FileSystemException e) {
                LOG.warn((Throwable)e);
                throw new IOException(PublishUtils.getMessage(e, true), e);
            }
        }
    }

    private void localRefreshFiles(boolean userInitiated) {
        ArrayList<DiffRoot> freshDirectories = new ArrayList<DiffRoot>(this.myDirectories.size());
        for (DiffRoot diffRoot : this.myDirectories) {
            String localPath = diffRoot.getMapping().mapToLocalPath(diffRoot.getRemote(), (Mappable)this.myServer);
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(localPath);
            if (vFile != null) {
                VirtualFileDiffElement.refreshFile((boolean)userInitiated, (VirtualFile)vFile);
            }
            freshDirectories.add(DiffRoot.create(vFile, diffRoot.getRemote(), diffRoot.getMapping()));
        }
        this.myDirectories.clear();
        this.myDirectories.addAll(freshDirectories);
    }

    public String getPresentablePath() {
        if (this.myDirectories.size() == 1) {
            if (this.myLocal) {
                return this.getPath();
            }
            return WDBundle.message("remote.diff.title.0.on.server.1", this.myServer.getPresentablePath(this.myDirectories.get(0).getRemote()), this.myServer.getName());
        }
        int state = 0;
        state += this.myContainsDirs ? 1 : 0;
        return WDBundle.message("composite.diff.element.presentable.path", this.myLocal ? 1 : 0, state += this.myContainsFiles ? 2 : 0, this.myLocal ? "" : this.myServer.getName());
    }

    public boolean isOperationsEnabled() {
        return true;
    }

    @NotNull
    public Promise<DiffElement> copyToAsync(@NotNull DiffElement container, @Nullable DiffElement target, @NotNull String relativePath) {
        if (container == null) {
            CompositeDiffElement.$$$reportNull$$$0(26);
        }
        if (relativePath == null) {
            CompositeDiffElement.$$$reportNull$$$0(27);
        }
        throw new IllegalStateException("It's container diff element, and it shouldn't be copied itself.");
    }

    @NotNull
    public Promise<Void> deleteAsync() {
        throw new IllegalStateException("It's container diff element, and it shouldn't be deleted itself.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffSettings";
                break;
            }
            case 4: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortenedPath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullDefaultPath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleRootName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePathOfProjectFileInProject";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistinguishableFromContentRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRootLocalDiffElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRootRemoteDiffElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfProjectFileInProject";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDistinguishableFromContentRootPath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copyToAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RemoteCompositeDiffElement
    extends CompositeDiffElement
    implements RemoteDiffElement {
        private RemoteCompositeDiffElement(@NotNull List<DiffRoot> directories, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project, @NotNull RemoteConnection connection) throws FileSystemException {
            if (directories == null) {
                RemoteCompositeDiffElement.$$$reportNull$$$0(0);
            }
            if (server == null) {
                RemoteCompositeDiffElement.$$$reportNull$$$0(1);
            }
            if (diffSettings == null) {
                RemoteCompositeDiffElement.$$$reportNull$$$0(2);
            }
            if (project == null) {
                RemoteCompositeDiffElement.$$$reportNull$$$0(3);
            }
            if (connection == null) {
                RemoteCompositeDiffElement.$$$reportNull$$$0(4);
            }
            super(directories, false, PublishConfig.getInstance(project), server, diffSettings, project, connection);
        }

        @Override
        @NotNull
        public RemoteConnection getConnection() {
            RemoteConnection remoteConnection = this.myConnection;
            if (remoteConnection == null) {
                RemoteCompositeDiffElement.$$$reportNull$$$0(5);
            }
            return remoteConnection;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                RemoteCompositeDiffElement.$$$reportNull$$$0(6);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directories";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffSettings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnection";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class LocalCompositeDiffElement
    extends CompositeDiffElement {
        private LocalCompositeDiffElement(@NotNull List<DiffRoot> directories, @NotNull PublishConfig config, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project) throws FileSystemException {
            if (directories == null) {
                LocalCompositeDiffElement.$$$reportNull$$$0(0);
            }
            if (config == null) {
                LocalCompositeDiffElement.$$$reportNull$$$0(1);
            }
            if (server == null) {
                LocalCompositeDiffElement.$$$reportNull$$$0(2);
            }
            if (diffSettings == null) {
                LocalCompositeDiffElement.$$$reportNull$$$0(3);
            }
            if (project == null) {
                LocalCompositeDiffElement.$$$reportNull$$$0(4);
            }
            super(directories, true, config, server, diffSettings, project, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directories";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "server";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "diffSettings";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$LocalCompositeDiffElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

