/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformIcons;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class AddServerForm {
    private static final Dimension PREFERRED_DESCRIPTION_LABEL_SIZE;
    private JLabel myIconLabel;
    private JTextField myNameField;
    private ComboBox<AccessType> myAccessTypeCombo;
    private JPanel myContentPane;
    private JLabel myAccessTypeDescriptionLabel;
    private JLabel myUpDownHint;
    private final EventDispatcher<Listener> myEventDispatcher;
    private final boolean myGlobalServersOnly;

    private void createUIComponents() {
        this.myAccessTypeDescriptionLabel = ComponentPanelBuilder.createCommentComponent((String)"", (boolean)true);
    }

    public AddServerForm(boolean remoteServersOnly, boolean globalServersOnly) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myGlobalServersOnly = globalServersOnly;
        this.myIconLabel.setIcon(Messages.getQuestionIcon());
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((Listener)AddServerForm.this.myEventDispatcher.getMulticaster()).nameChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/AddServerForm$1", "textChanged"));
            }
        });
        ArrayList<AccessType> types = new ArrayList<AccessType>();
        for (AccessType type : AccessType.values()) {
            if (!PublishUtils.needsTransfer(type) && remoteServersOnly) continue;
            types.add(type);
        }
        this.myAccessTypeCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(types, (Object)((AccessType)((Object)types.get(0)))));
        this.myAccessTypeCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            if (value != null) {
                label.setText(value.getTitle());
                label.setIcon(value.getIcon());
            }
        }));
        this.myAccessTypeDescriptionLabel.setText(((AccessType)((Object)this.myAccessTypeCombo.getSelectedItem())).getDescription());
        this.myAccessTypeDescriptionLabel.setPreferredSize(PREFERRED_DESCRIPTION_LABEL_SIZE);
        this.myAccessTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddServerForm.this.myAccessTypeDescriptionLabel.setText(((AccessType)((Object)AddServerForm.this.myAccessTypeCombo.getSelectedItem())).getDescription());
            }
        });
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.registerUpDownHint();
    }

    private void registerUpDownHint() {
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    this.scrollBy(code == 40 ? 1 : (code == 38 ? -1 : 0));
                }
            }

            private void scrollBy(int delta) {
                if (delta == 0) {
                    return;
                }
                int size = AddServerForm.this.myAccessTypeCombo.getModel().getSize();
                int next = AddServerForm.this.myAccessTypeCombo.getSelectedIndex() + delta;
                if (next < 0 || next >= size) {
                    if (!UISettings.getInstance().getCycleScrolling()) {
                        return;
                    }
                    next = (next + size) % size;
                }
                AddServerForm.this.myAccessTypeCombo.setSelectedIndex(next);
                AddServerForm.this.myAccessTypeCombo.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/AddServerForm$3", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{38, 40}), (JComponent)this.myNameField);
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public String getName() {
        return this.myNameField.getText();
    }

    private AccessType getAccessType() {
        return (AccessType)((Object)this.myAccessTypeCombo.getSelectedItem());
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    public WebServerConfig getResult() {
        WebServerConfig result = new WebServerConfig(WebServerConfig.getNextId());
        result.initializeNewCreatedServer(this.myGlobalServersOnly);
        result.setName(this.getName());
        result.getFileTransferConfig().setAccessType(this.getAccessType());
        result.getFileTransferConfig().setPort(this.getAccessType().getDefaultPort());
        return result;
    }

    static {
        double preferredWidth = 0.0;
        double preferredHeight = 0.0;
        MultiLineLabel label = new MultiLineLabel();
        for (AccessType accessType : AccessType.values()) {
            label.setText(accessType.getDescription());
            Dimension dimension = label.getPreferredSize();
            preferredWidth = Math.max(preferredWidth, dimension.getWidth());
            preferredHeight = Math.max(preferredHeight, dimension.getHeight());
        }
        PREFERRED_DESCRIPTION_LABEL_SIZE = new Dimension();
        PREFERRED_DESCRIPTION_LABEL_SIZE.setSize(preferredWidth, preferredHeight);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        ComboBox comboBox;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WDBundle", AddServerForm.class).getString("server.name.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIconLabel = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 3, 1, 9, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/WDBundle", AddServerForm.class).getString("server.type.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAccessTypeCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(3, 1, 1, 2, 0, 1, 0, 2, null, new Dimension(150, -1), null));
        JLabel jLabel5 = this.myAccessTypeDescriptionLabel;
        ((Component)jLabel5).setForeground(SystemColor.textInactiveText);
        jLabel5.setText("---");
        jLabel5.setVerticalAlignment(1);
        jLabel5.setVerticalTextPosition(1);
        jPanel.add((Component)jLabel5, new GridConstraints(4, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myUpDownHint = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/WDBundle").getString("add.server.arrows.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Listener
    extends EventListener {
        public void nameChanged();
    }
}

