/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.legacy.AuthAgentIdentityRepositoryFactory;
import com.intellij.ssh.legacy.SftpIdentityRepositoryFactory;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jetbrains.plugins.webDeployment.connections.IdentityRepositoryFactoryAdapter;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil$WhenMappings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\t\u001a\u0014\u0010\r\u001a\u00020\u0006*\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\t\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getSshBackendLibraryForWebDeployment", "Lcom/intellij/ssh/SshBackendLibrary;", "setSshBackendLibraryForWebDeployment", "", "sshBackendLibrary", "unwrap", "Lcom/intellij/ssh/legacy/SftpIdentityRepositoryFactory;", "factory", "Lorg/apache/commons/vfs2/provider/sftp/IdentityRepositoryFactory;", "wrap", "setIdentityRepositoryFactory", "Lcom/intellij/ssh/SessionConfig;", "intellij.webDeployment"})
@JvmName(name="SftpUtil")
public final class SftpUtil {
    private static final Logger LOG;

    @Nullable
    public static final IdentityRepositoryFactory wrap(@Nullable SftpIdentityRepositoryFactory factory) {
        return factory != null ? (IdentityRepositoryFactory)new IdentityRepositoryFactoryAdapter(factory) : null;
    }

    @Nullable
    public static final SftpIdentityRepositoryFactory unwrap(@Nullable IdentityRepositoryFactory factory) {
        return factory == null ? null : (factory instanceof IdentityRepositoryFactoryAdapter ? ((IdentityRepositoryFactoryAdapter)factory).getOriginal$intellij_webDeployment() : (SftpIdentityRepositoryFactory)new SftpIdentityRepositoryFactory(factory){
            final /* synthetic */ IdentityRepositoryFactory $factory;

            @Nullable
            public IdentityRepository create(@Nullable JSch jsch) {
                return this.$factory.create(jsch);
            }
            {
                this.$factory = $captured_local_variable$0;
            }
        });
    }

    public static final void setIdentityRepositoryFactory(@NotNull SessionConfig $this$setIdentityRepositoryFactory, @Nullable SftpIdentityRepositoryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)$this$setIdentityRepositoryFactory, (String)"$this$setIdentityRepositoryFactory");
        SftpIdentityRepositoryFactory sftpIdentityRepositoryFactory = factory;
        if (sftpIdentityRepositoryFactory != null) {
            if (sftpIdentityRepositoryFactory instanceof AuthAgentIdentityRepositoryFactory) {
                $this$setIdentityRepositoryFactory.setAgentProxyConnectorFactory(((AuthAgentIdentityRepositoryFactory)factory).getAgentProxyConnectorFactory());
            } else {
                LOG.error("Can't map VFS identity repository " + factory + " to SessionConfig");
            }
        }
    }

    @NotNull
    public static final SshBackendLibrary getSshBackendLibraryForWebDeployment() {
        SshBackendLibrary sshBackendLibrary;
        boolean bl = Registry.get((String)"ide.ssh.library.backend.webDeployment.use.sshj").asBoolean();
        if (bl) {
            sshBackendLibrary = SshBackendLibrary.SSHJ;
        } else if (!bl) {
            sshBackendLibrary = SshBackendLibrary.JSCH;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sshBackendLibrary;
    }

    @TestOnly
    public static final void setSshBackendLibraryForWebDeployment(@NotNull SshBackendLibrary sshBackendLibrary) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sshBackendLibrary, (String)"sshBackendLibrary");
        RegistryValue registryValue = Registry.get((String)"ide.ssh.library.backend.webDeployment.use.sshj");
        switch (SftpUtil$WhenMappings.$EnumSwitchMapping$0[sshBackendLibrary.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        registryValue.setValue(bl);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.jetbrains.plugins.webDeployment");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026s.plugins.webDeployment\")");
        LOG = logger;
    }
}

