/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.ide.plugins.CannotUnloadPluginException;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.LegacyConnectionOwnerUtil;
import com.jetbrains.plugins.webDeployment.LogWrapper;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManagerImpl;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionPool;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionManager
implements DeploymentConfigChangeListener,
Disposable {
    @NonNls
    public static final String DEFAULT_IDE_FTP_SYSTEM_TYPE = "UNIX default system type provided by IDE";
    private static final Logger LOG = Logger.getInstance(RemoteConnectionManager.class);
    private final Collection<Object> myBlockingPluginUnloadElements = new ConcurrentLinkedQueue<Object>();
    private final Object LOCK = new Object();
    private final Map<ConnectionKey, RemoteConnectionPool> myPools = new TreeMap<ConnectionKey, RemoteConnectionPool>();
    private DefaultFileSystemManager myFilesystemManager;

    public static RemoteConnectionManager getInstance() {
        return (RemoteConnectionManager)ApplicationManager.getApplication().getService(RemoteConnectionManager.class);
    }

    public RemoteConnectionManager() {
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect().subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)this);
        if (System.getProperty("org.apache.commons.net.ftp.systemType.default") == null) {
            System.setProperty("org.apache.commons.net.ftp.systemType.default", DEFAULT_IDE_FTP_SYSTEM_TYPE);
        }
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        appConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void checkUnloadPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) throws CannotUnloadPluginException {
                PluginId pluginId;
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pluginId = pluginDescriptor.getPluginId()) != null && "com.jetbrains.plugins.webDeployment".equals(pluginId.getIdString()) && !RemoteConnectionManager.this.myBlockingPluginUnloadElements.isEmpty()) {
                    throw new CannotUnloadPluginException("Plugin is not unload-safe because of deployment tasks are currently running");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager$1", "checkUnloadPlugin"));
            }
        });
        RemoteConnectionManager.updateProvider();
        this.deploymentConfigChanged();
    }

    public RemoteConnection openConnection(@NotNull com.intellij.ssh.interaction.ConnectionOwner connectionOwner, @NotNull String title, @NotNull Connectable connectable, @NotNull FileTransferConfig.Origin origin, @Nullable EventDispatcher<ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        if (connectionOwner == null) {
            RemoteConnectionManager.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RemoteConnectionManager.$$$reportNull$$$0(1);
        }
        if (connectable == null) {
            RemoteConnectionManager.$$$reportNull$$$0(2);
        }
        if (origin == null) {
            RemoteConnectionManager.$$$reportNull$$$0(3);
        }
        return this.openConnection(LegacyConnectionOwnerUtil.adapt(connectionOwner), title, connectable, origin, forceDisconnectDispatcher, pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public RemoteConnection openConnection(@NotNull ConnectionOwner connectionOwner, @NotNull String title, @NotNull Connectable connectable, @NotNull FileTransferConfig.Origin origin, @Nullable EventDispatcher<ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        RemoteConnectionPool pool;
        if (connectionOwner == null) {
            RemoteConnectionManager.$$$reportNull$$$0(4);
        }
        if (title == null) {
            RemoteConnectionManager.$$$reportNull$$$0(5);
        }
        if (connectable == null) {
            RemoteConnectionManager.$$$reportNull$$$0(6);
        }
        if (origin == null) {
            RemoteConnectionManager.$$$reportNull$$$0(7);
        }
        final ConnectionKey key = new ConnectionKey(connectable.getRootUri(), connectable.getConnectionOptions(connectionOwner, title, origin, forceDisconnectDispatcher, pi));
        Object object = this.LOCK;
        synchronized (object) {
            pool = this.myPools.get(key);
            if (pool == null) {
                try {
                    connectionOwner.checkDisposed();
                }
                catch (IllegalStateException e) {
                    throw new FileSystemException((Throwable)e);
                }
                pool = new RemoteConnectionPool(connectable, connectionOwner, title, origin, forceDisconnectDispatcher);
                this.myPools.put(key, pool);
                Disposable disposable = new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        RemoteConnectionPool pool;
                        Object object = RemoteConnectionManager.this.LOCK;
                        synchronized (object) {
                            pool = RemoteConnectionManager.this.myPools.remove(key);
                        }
                        if (pool != null) {
                            pool.close();
                        }
                    }
                };
                connectionOwner.registerDisposable(disposable);
                Project project = connectionOwner.getProjectForDialogCreation();
                Disposer.register((Disposable)GroupedServersConfigManager.getInstance(project), (Disposable)disposable);
            }
        }
        return pool.createConnection(forceDisconnectDispatcher, pi);
    }

    @Override
    public void deploymentConfigChanged() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            @NotNull List<@NotNull Pair<@NotNull WebServerConfig, @Nullable Project>> newServers = GroupedServersConfigManagerImpl.getServersWithProjectsFromAllOpenProjects(false);
            RemoteConnectionPool[] remoteConnectionPoolArray = this.LOCK;
            synchronized (this.LOCK) {
                RemoteConnectionPool[] pools = this.myPools.values().toArray(new RemoteConnectionPool[0]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (RemoteConnectionPool pool : pools) {
                    pool.notifyServersUpdated(newServers);
                }
                return;
            }
        });
    }

    private static void updateProvider() {
        if (SftpUtil.getSshBackendLibraryForWebDeployment() == SshBackendLibrary.SSHJ || SshBackendLibrary.get() == SshBackendLibrary.SSHJ) {
            return;
        }
        boolean enabled = Registry.get((String)"deployment.BouncyCastleJCE").asBoolean();
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        LOG.debug("Extended JCE " + (enabled ? "on" : "off"));
        if (enabled) {
            int index = Security.insertProviderAt((Provider)bouncyCastleProvider, 1);
            LOG.debug("BouncyCastleJCE installed at " + index + ", providers " + Arrays.toString(Security.getProviders()));
        } else {
            Security.removeProvider(bouncyCastleProvider.getName());
        }
    }

    public void dispose() {
        this.myFilesystemManager = null;
    }

    @NotNull
    public synchronized FileSystemManager getManager() {
        if (this.myFilesystemManager == null) {
            this.myFilesystemManager = new StandardFileSystemManager(){

                public void init() throws FileSystemException {
                    this.setConfiguration(PublishUtils.class.getResource("commons-vfs-providers.xml"));
                    this.setCacheStrategy(PublishUtils.DISABLE_FILESYSTEM_CACHE ? CacheStrategy.ON_RESOLVE : CacheStrategy.MANUAL);
                    this.setFilesCache((FilesCache)new SoftRefFilesCache(){

                        protected boolean shouldCloseFilesystemOnClear(Map files) {
                            return false;
                        }
                    });
                    super.init();
                }
            };
            try {
                ClassLoaderUtil.runWithClassLoader((ClassLoader)RemoteConnectionManager.class.getClassLoader(), () -> this.myFilesystemManager.init());
            }
            catch (FileSystemException e) {
                throw new IllegalStateException("Failed to initialize filesystem manager", e);
            }
            this.myFilesystemManager.setLogger((Log)new LogWrapper(LOG));
        }
        DefaultFileSystemManager defaultFileSystemManager = this.myFilesystemManager;
        if (defaultFileSystemManager == null) {
            RemoteConnectionManager.$$$reportNull$$$0(8);
        }
        return defaultFileSystemManager;
    }

    public void registerBlockingPluginUnloadElement(@NotNull Object element) {
        if (element == null) {
            RemoteConnectionManager.$$$reportNull$$$0(9);
        }
        this.myBlockingPluginUnloadElements.add(element);
    }

    public void unregisterBlockingPluginUnloadElement(@NotNull Object element) {
        if (element == null) {
            RemoteConnectionManager.$$$reportNull$$$0(10);
        }
        this.myBlockingPluginUnloadElements.remove(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectable";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openConnection";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerBlockingPluginUnloadElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterBlockingPluginUnloadElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ConnectionKey
    implements Comparable<ConnectionKey> {
        private final String myUri;
        private final FileSystemOptions myFileSystemOptions;

        private ConnectionKey(String uri, FileSystemOptions fileSystemOptions) {
            this.myUri = uri;
            this.myFileSystemOptions = fileSystemOptions;
        }

        @Override
        public int compareTo(ConnectionKey o) {
            int i = this.myUri.compareTo(o.myUri);
            if (i == 0) {
                i = this.myFileSystemOptions.compareTo(o.myFileSystemOptions);
            }
            return i;
        }
    }
}

