/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.remote.AuthType;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.StrictHostKeyChecking;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.interaction.PlatformSshPasswordProvider;
import com.intellij.ssh.interaction.SshPasswordProvider;
import com.intellij.ssh.sockets.MySftpSocketFactory;
import com.intellij.util.EventDispatcher;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.SocketFactory;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystemConfigBuilder;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchedSftpClientFactory {
    private PatchedSftpClientFactory() {
    }

    @NotNull
    public static SessionConfig configConnection(String hostname, int port, char[] username, char[] password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return PatchedSftpClientFactory.configConnection(hostname, port, username, password, fileSystemOptions, SftpUtil.getSshBackendLibraryForWebDeployment());
    }

    @NotNull
    public static SessionConfig configConnection(String hostname, int port, char @NotNull [] username, char[] password, FileSystemOptions fileSystemOptions, SshBackendLibrary sshBackendLibrary) throws FileSystemException {
        SessionConfig sessionConfig;
        if (username == null) {
            PatchedSftpClientFactory.$$$reportNull$$$0(0);
        }
        PlatformSftpFileSystemConfigBuilder builder = PlatformSftpFileSystemConfigBuilder.getInstance();
        File knownHostsFile = builder.getKnownHosts(fileSystemOptions);
        IdentityInfo[] identities = builder.getIdentityInfo(fileSystemOptions);
        IdentityRepositoryFactory repositoryFactory = builder.getIdentityRepositoryFactory(fileSystemOptions);
        try {
            EventDispatcher<ForceDisconnectListener> disconnectListener;
            String proxyHost;
            String compression;
            String preferredAuthentications;
            SessionConfig sessionConfig2 = SessionConfig.Factory.createSessionConfig(new String(username), hostname, port);
            sessionConfig2.setKnownHostsFile(knownHostsFile);
            if (identities != null) {
                for (IdentityInfo identity : identities) {
                    sessionConfig2.getPrivateKeys().add(identity.getPrivateKey().toPath());
                }
            }
            SftpUtil.setIdentityRepositoryFactory(sessionConfig2, SftpUtil.unwrap(repositoryFactory));
            AuthType authType = (AuthType)builder.getAuthType(fileSystemOptions);
            Optional<IdentityInfo> firstIdentity = Optional.ofNullable(identities).map(i -> ((IdentityInfo[])i).length != 0 ? i[0] : null);
            sessionConfig2.setSshPasswordProvider((SshPasswordProvider)new PlatformSshPasswordProvider(hostname, port, new String(username), () -> firstIdentity.map(IdentityInfo::getPrivateKey).map(File::toString).orElse(null), () -> firstIdentity.map(IdentityInfo::getPassPhrase).map(p -> new String((byte[])p, StandardCharsets.UTF_8)).orElse(null), () -> password != null ? new String(password) : null));
            if (authType == AuthType.OPEN_SSH) {
                sessionConfig2.setOpenSSHConfig(OpenSSHConfigService.getInstance().getConfig());
            } else if (authType == AuthType.KEY_PAIR) {
                sessionConfig2.setPreferredAuthentications(Collections.singletonList(SessionConfig.AuthMethod.PUBLIC_KEY));
            } else {
                sessionConfig2.setPreferredAuthentications(Arrays.asList(SessionConfig.AuthMethod.KEYBOARD_INTERACTIVE, SessionConfig.AuthMethod.PASSWORD));
            }
            @Nullable Integer timeout = builder.getTimeout(fileSystemOptions);
            sessionConfig2.setTimeout(timeout);
            @NonNls Properties config = new Properties();
            String strictHostKeyChecking = builder.getStrictHostKeyChecking(fileSystemOptions);
            if (strictHostKeyChecking != null) {
                sessionConfig2.setHostKeyVerifier((SshHostKeyVerifier)new OpenSshLikeHostKeyVerifier(null, StrictHostKeyChecking.fromOpenSshConfigOption((String)strictHostKeyChecking), null));
            }
            if ((preferredAuthentications = builder.getPreferredAuthentications(fileSystemOptions)) != null) {
                config.setProperty("PreferredAuthentications", preferredAuthentications);
            }
            if ((compression = builder.getCompression(fileSystemOptions)) != null) {
                config.setProperty("compression.s2c", compression);
                config.setProperty("compression.c2s", compression);
            }
            if ((proxyHost = builder.getProxyHost(fileSystemOptions)) != null) {
                int proxyPort = builder.getProxyPort(fileSystemOptions);
                SftpFileSystemConfigBuilder.ProxyType proxyType = builder.getProxyType(fileSystemOptions);
                ProxyHTTP proxy = null;
                if (SftpFileSystemConfigBuilder.PROXY_HTTP.equals((Object)proxyType)) {
                    proxy = SftpClientFactory.createProxyHTTP((String)proxyHost, (int)proxyPort);
                } else if (SftpFileSystemConfigBuilder.PROXY_SOCKS5.equals((Object)proxyType)) {
                    proxy = SftpClientFactory.createProxySOCKS5((String)proxyHost, (int)proxyPort);
                } else if (SftpFileSystemConfigBuilder.PROXY_STREAM.equals((Object)proxyType)) {
                    config.setProperty("ProxyCommand", "nc -q 0 %s %d");
                }
                if (proxy != null) {
                    sessionConfig2.setProxy((Proxy)proxy);
                }
            }
            if (config.size() > 0) {
                sessionConfig2.setConfig(config);
            }
            if ((disconnectListener = builder.getForceDisconnectListenerDispatcher(fileSystemOptions)) != null) {
                sessionConfig2.setSocketFactory((SocketFactory)new MySftpSocketFactory(disconnectListener));
            }
            sessionConfig2.setDisconnectTrigger(disconnectListener);
            @Nullable Integer keepAliveTimeout = builder.getKeepAliveTimeout(fileSystemOptions);
            sessionConfig2.setServerAliveInterval(keepAliveTimeout);
            @Nullable Integer keepAliveCountMax = builder.getKeepAliveMaxCount(fileSystemOptions);
            sessionConfig2.setServerAliveCountMax(keepAliveCountMax);
            sessionConfig2.setDaemonThread(true);
            sessionConfig2.setSshBackendLibrary(sshBackendLibrary);
            sessionConfig = sessionConfig2;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Throwable)exc, new Object[]{hostname});
        }
        if (sessionConfig == null) {
            PatchedSftpClientFactory.$$$reportNull$$$0(1);
        }
        return sessionConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/connections/PatchedSftpClientFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/connections/PatchedSftpClientFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "configConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configConnection";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

