/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config.sftp;

import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystemConfigBuilder;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.jetbrains.annotations.NonNls;

public enum HostKeyCheckingLevel {
    ASK("ask", WDBundle.messagePointer("host.key.checking.level.ask", new Object[0])),
    NO("no", WDBundle.messagePointer("host.key.checking.level.always", new Object[0])),
    YES("yes", WDBundle.messagePointer("host.key.checking.level.never", new Object[0]));

    private final String property;
    private final Supplier<@NlsContexts.Label String> presentableNameSupplier;

    private HostKeyCheckingLevel(String property, Supplier<String> presentableNameSupplier) {
        this.property = property;
        this.presentableNameSupplier = presentableNameSupplier;
    }

    @NlsContexts.Label
    public String getPresentableName() {
        return this.presentableNameSupplier.get();
    }

    @NonNls
    public String getProperty() {
        return this.property;
    }

    public void apply(FileSystemOptions options) throws FileSystemException {
        PlatformSftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(options, this.property);
    }
}

