/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.text.StringKt;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.OldStorageCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper$WhenMappings;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u001a$\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0000\u001a \u0010\u0018\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e\u001a.\u0010\u0018\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\u001a\u001c\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"EMPTY_PASSWORD_PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "copyServerCredentials", "", "from", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "to", "createAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "server", "isPasswordMemoryOnly", "", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "getCredentialsAndMemoryOnlyStatus", "Lkotlin/Pair;", "getRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "patchCredentialsAfterReading", "credentials", "patchCredentialsBeforeSaving", "saveCredentials", "userName", "password", "syncWithPasswordSafe", "servers", "", "provider", "Lcom/jetbrains/plugins/webDeployment/config/OldStorageCredentialProvider;", "intellij.webDeployment"})
@JvmName(name="WebDeploymentCredentialHelper")
public final class WebDeploymentCredentialHelper {
    @NotNull
    public static final String EMPTY_PASSWORD_PREFIX = "IntelliJ deployment empty password";

    @JvmOverloads
    public static final void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password, boolean isPasswordMemoryOnly) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        WebDeploymentCredentialHelper.saveCredentials(server, isPasswordMemoryOnly, new Credentials(StringKt.nullize((String)userName, (boolean)true), password));
    }

    public static /* synthetic */ void saveCredentials$default(WebServerConfig webServerConfig, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        WebDeploymentCredentialHelper.saveCredentials(webServerConfig, string, string2, bl);
    }

    @JvmOverloads
    public static final void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password) {
        WebDeploymentCredentialHelper.saveCredentials$default(server, userName, password, false, 8, null);
    }

    public static final void saveCredentials(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly, @Nullable Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        PasswordSafe.Companion.getInstance().set(attributes, WebDeploymentCredentialHelper.patchCredentialsBeforeSaving(credentials));
    }

    @Nullable
    public static final Credentials getCredentials(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        Credentials credentials = PasswordSafe.Companion.getInstance().get(attributes);
        return WebDeploymentCredentialHelper.patchCredentialsAfterReading(credentials);
    }

    @NotNull
    public static final Pair<Credentials, Boolean> getCredentialsAndMemoryOnlyStatus(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        Credentials credentials = PasswordSafe.Companion.getInstance().get(attributes);
        boolean memoryOnly = false;
        memoryOnly = credentials == null ? true : PasswordSafe.Companion.getInstance().isPasswordStoredOnlyInMemory(attributes, credentials);
        return new Pair((Object)WebDeploymentCredentialHelper.patchCredentialsAfterReading(credentials), (Object)memoryOnly);
    }

    public static final void syncWithPasswordSafe(@NotNull List<? extends WebServerConfig> servers, @NotNull OldStorageCredentialProvider provider) {
        Intrinsics.checkNotNullParameter(servers, (String)"servers");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        for (WebServerConfig webServerConfig : servers) {
            Credentials credentials;
            String string;
            FileTransferConfig fileTransferConfig = webServerConfig.getFileTransferConfig();
            Intrinsics.checkNotNullExpressionValue((Object)fileTransferConfig, (String)"server.fileTransferConfig");
            switch (WebDeploymentCredentialHelper$WhenMappings.$EnumSwitchMapping$0[fileTransferConfig.getAuthType().ordinal()]) {
                case 1: {
                    string = provider.getPassphrase(webServerConfig);
                    break;
                }
                case 2: {
                    string = provider.getPassword(webServerConfig);
                    break;
                }
                default: {
                    string = null;
                }
            }
            String password = StringKt.nullize$default((String)string, (boolean)false, (int)1, null);
            String userName = StringKt.nullize$default((String)provider.getUser(webServerConfig), (boolean)false, (int)1, null);
            if (userName == null && password == null || (credentials = WebDeploymentCredentialHelper.getCredentials(webServerConfig, false)) != null && (credentials.getPasswordAsString() != null || password == null)) continue;
            WebDeploymentCredentialHelper.saveCredentials(webServerConfig, false, new Credentials(userName, password));
        }
    }

    private static final CredentialAttributes createAttributes(WebServerConfig server, boolean isPasswordMemoryOnly) {
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"Deployment", (String)String.valueOf(server.getId())), null, null, isPasswordMemoryOnly, 6, null);
    }

    @Nullable
    public static final RemoteCredentials getRemoteCredentials(@NotNull WebServerConfig server, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        RemoteCredentialsHolder remoteCredentials = new RemoteCredentialsHolder();
        FileTransferConfig fileTransferConfig = server.getFileTransferConfig();
        Intrinsics.checkNotNullExpressionValue((Object)fileTransferConfig, (String)"server.fileTransferConfig");
        PresentableId presentableId = fileTransferConfig.getSshPresentableId();
        if (presentableId != null) {
            SshUiData sshUiData = SshConfigManager.getInstance((Project)project).findCurrentData(presentableId);
            if (sshUiData == null) {
                return null;
            }
            remoteCredentials.copyFrom((RemoteCredentials)sshUiData);
            return (RemoteCredentials)remoteCredentials;
        }
        Deployable deployable = Deployable.create(server, project);
        deployable.copyToCredentials((MutableRemoteCredentials)remoteCredentials);
        return (RemoteCredentials)remoteCredentials;
    }

    public static final void copyServerCredentials(@NotNull WebServerConfig from, @NotNull WebServerConfig to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(from, false);
        Credentials credentials = passwordSafe.get(attributes);
        if (!(credentials == null || StringUtil.isEmptyOrSpaces((String)credentials.getUserName()) && StringUtil.isEmptyOrSpaces((String)credentials.getPasswordAsString()))) {
            boolean isMemoryOnly = passwordSafe.isPasswordStoredOnlyInMemory(attributes, credentials);
            CredentialAttributes cloneAttributes = WebDeploymentCredentialHelper.createAttributes(to, false);
            passwordSafe.set(cloneAttributes, credentials, isMemoryOnly);
        }
    }

    @Nullable
    public static final Credentials patchCredentialsBeforeSaving(@Nullable Credentials credentials) {
        if (credentials == null) {
            return null;
        }
        String password = credentials.getPasswordAsString();
        if (password != null) {
            CharSequence charSequence = password;
            boolean bl = false;
            if (charSequence.length() == 0 || StringsKt.startsWith$default((String)password, (String)EMPTY_PASSWORD_PREFIX, (boolean)false, (int)2, null)) {
                return new Credentials(credentials.getUserName(), EMPTY_PASSWORD_PREFIX + password);
            }
        }
        return credentials;
    }

    @Nullable
    public static final Credentials patchCredentialsAfterReading(@Nullable Credentials credentials) {
        if (credentials == null) {
            return null;
        }
        String password = credentials.getPasswordAsString();
        if (password == null) {
            return credentials;
        }
        CharSequence charSequence = password;
        int n = 0;
        if (charSequence.length() == 0) {
            return new Credentials(credentials.getUserName(), (String)null);
        }
        if (!StringsKt.startsWith$default((String)password, (String)EMPTY_PASSWORD_PREFIX, (boolean)false, (int)2, null)) {
            return credentials;
        }
        String string = credentials.getUserName();
        charSequence = password;
        n = EMPTY_PASSWORD_PREFIX.length();
        boolean bl = false;
        String string2 = ((String)charSequence).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        return new Credentials(string, string2);
    }
}

