/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.legacy.SftpIdentityRepositoryFactory;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystemConfigBuilder;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.concurrent.TimeoutException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ServerBaseDeployable
implements Deployable {
    private static final Logger LOG = Logger.getInstance(ServerBaseDeployable.class);
    @NotNull
    protected WebServerConfig myServer;

    ServerBaseDeployable(@NotNull WebServerConfig server, @Nullable SshConfig sshConfig) {
        if (server == null) {
            ServerBaseDeployable.$$$reportNull$$$0(0);
        }
        this.myServer = server;
        if (sshConfig != null) {
            server.getFileTransferConfig().setSshConfig(sshConfig);
        }
    }

    @NotNull
    public WebServerConfig getServer() {
        WebServerConfig webServerConfig = this.myServer;
        if (webServerConfig == null) {
            ServerBaseDeployable.$$$reportNull$$$0(1);
        }
        return webServerConfig;
    }

    @Override
    @NlsSafe
    public String getRootNodePresentableDescription(boolean showRootFolder) {
        if (this.myServer.getAccessType().isProtocolBased()) {
            if (showRootFolder) {
                return MessageFormat.format("{0} ({1}{2})", this.myServer.getName(), this.getHost(), this.myServer.getFileTransferConfig().getRootFolder());
            }
            return MessageFormat.format("{0} ({1})", this.myServer.getName(), this.getHost());
        }
        return MessageFormat.format("{0} ({1})", this.myServer.getName(), this.myServer.getFileTransferConfig().getMountedFolder());
    }

    @Override
    @NlsSafe
    public String getName() {
        return this.myServer.getName();
    }

    @Override
    @NotNull
    public FileSystemOptions getConnectionOptions(@NotNull ConnectionOwner connectionOwner, @NotNull String title, FileTransferConfig.Origin originOption, @Nullable EventDispatcher<ForceDisconnectListener> disconnectTrigger, @Nullable ProgressIndicator pi) {
        FileSystemOptions options;
        block14: {
            if (connectionOwner == null) {
                ServerBaseDeployable.$$$reportNull$$$0(2);
            }
            if (title == null) {
                ServerBaseDeployable.$$$reportNull$$$0(3);
            }
            options = this.myServer.getConnectionOptions(connectionOwner, title, originOption, disconnectTrigger, pi);
            FileTransferConfig ftc = this.myServer.getFileTransferConfig();
            if (!ftc.getAccessType().isProtocolBased()) {
                FileSystemOptions fileSystemOptions = options;
                if (fileSystemOptions == null) {
                    ServerBaseDeployable.$$$reportNull$$$0(4);
                }
                return fileSystemOptions;
            }
            try {
                if (ftc.getAccessType() == AccessType.FTP || ftc.getAccessType() == AccessType.FTPS) {
                    Credentials credentials = ftc.isAnonymous() ? new Credentials("anonymous", "user@example.com") : this.getCredentials();
                    String userName = credentials == null ? null : credentials.getUserName();
                    String password = credentials == null ? null : credentials.getPasswordAsString();
                    StaticUserAuthenticator auth = new StaticUserAuthenticator(null, userName, password);
                    DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)auth);
                    break block14;
                }
                if (ftc.getAccessType() == AccessType.SFTP) {
                    Credentials credentials;
                    Credentials credentials2 = credentials = this.isAnonymous() ? new Credentials("anonymous", "user@example.com") : this.getCredentials();
                    if (ftc.getAuthType() == AuthType.KEY_PAIR) {
                        String passwordAsString;
                        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)new StaticUserAuthenticator(null, credentials == null ? null : credentials.getUserName(), null));
                        byte[] passphrase = null;
                        if (credentials != null && (passwordAsString = credentials.getPasswordAsString()) != null) {
                            passphrase = passwordAsString.getBytes(StandardCharsets.UTF_8);
                        }
                        IdentityInfo identityInfo = new IdentityInfo(new File(ftc.getPrivateKeyFile()), passphrase);
                        PlatformSftpFileSystemConfigBuilder.getInstance().setIdentityInfo(options, identityInfo);
                    } else if (ftc.getAuthType() == AuthType.OPEN_SSH) {
                        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)new StaticUserAuthenticator(null, credentials == null ? null : credentials.getUserName(), null));
                        PlatformSftpFileSystemConfigBuilder.getInstance().setIdentityInfo(options, null);
                        SftpIdentityRepositoryFactory repositoryFactory = SshConnectionService.getInstance().getAuthAgentIdentityRepositoryFactory();
                        PlatformSftpFileSystemConfigBuilder.getInstance().setIdentityRepositoryFactory(options, SftpUtil.wrap(repositoryFactory));
                    } else {
                        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)new StaticUserAuthenticator(null, credentials == null ? null : credentials.getUserName(), credentials == null ? null : credentials.getPasswordAsString()));
                        PlatformSftpFileSystemConfigBuilder.getInstance().setIdentityInfo(options, null);
                    }
                    break block14;
                }
                throw new IllegalStateException("Unknown access type " + ftc.getAccessType());
            }
            catch (FileSystemException e) {
                LOG.error((Throwable)e);
            }
        }
        WebServerConfig.checkProperEqualsAndHash(options);
        FileSystemOptions fileSystemOptions = options;
        if (fileSystemOptions == null) {
            ServerBaseDeployable.$$$reportNull$$$0(5);
        }
        return fileSystemOptions;
    }

    @Override
    public boolean hasCredentials() {
        FileTransferConfig fileTransferConfig = this.myServer.getFileTransferConfig();
        if (fileTransferConfig.isAnonymous() || !fileTransferConfig.getAccessType().isProtocolBased()) {
            return true;
        }
        Credentials credentials = this.getCredentials();
        if (credentials != null && credentials.getUserName() != null && (credentials.getPasswordAsString() != null || fileTransferConfig.getAuthType() == AuthType.OPEN_SSH)) {
            return true;
        }
        if (fileTransferConfig.getAuthType() == AuthType.KEY_PAIR) {
            return Ssh.isPrivateKeyNotEncrypted((String)fileTransferConfig.getPrivateKeyFile(), (SshBackendLibrary)SftpUtil.getSshBackendLibraryForWebDeployment());
        }
        return false;
    }

    @Override
    @NotNull
    public AccessType getAccessType() {
        AccessType accessType = this.myServer.getAccessType();
        if (accessType == null) {
            ServerBaseDeployable.$$$reportNull$$$0(6);
        }
        return accessType;
    }

    @Override
    public boolean isProjectLevel() {
        return this.myServer.isProjectLevel();
    }

    @Override
    public String getHost() {
        return this.myServer.getFileTransferConfig().getHost();
    }

    @Override
    public String getLiteralPort() {
        return this.myServer.getFileTransferConfig().getLiteralPort();
    }

    @Override
    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myServer.getFileTransferConfig().getAuthType();
        if (authType == null) {
            ServerBaseDeployable.$$$reportNull$$$0(7);
        }
        return authType;
    }

    @Override
    public String getPrivateKeyFile() {
        return this.myServer.getFileTransferConfig().getPrivateKeyFile();
    }

    @Override
    public boolean isDefaultRootFolder() {
        FileTransferConfig c = this.myServer.getFileTransferConfig();
        return c.getAccessType().getDefaultRootFolder().equals(c.getRootFolder());
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myServer.isCaseSensitive();
    }

    @Override
    public String getRootUri() {
        return this.myServer.getRootUri();
    }

    @Override
    public int getMaxConnections() {
        return this.myServer.getMaxConnections();
    }

    @Override
    public AdvancedOptionsConfig.AccurateTimestamps getAccurateTimestamps() {
        return this.myServer.getAccurateTimestamps();
    }

    @Override
    @NotNull
    public ServerBaseDeployable clone() {
        ServerBaseDeployable serverBaseDeployable;
        try {
            ServerBaseDeployable clone = (ServerBaseDeployable)super.clone();
            clone.myServer = this.myServer.clone();
            serverBaseDeployable = clone;
        }
        catch (CloneNotSupportedException e) {
            if (null == null) {
                ServerBaseDeployable.$$$reportNull$$$0(9);
            }
            return null;
        }
        if (serverBaseDeployable == null) {
            ServerBaseDeployable.$$$reportNull$$$0(8);
        }
        return serverBaseDeployable;
    }

    @Override
    public boolean isBasedOnServer(WebServerConfig server) {
        return !StringUtil.isEmptyOrSpaces((String)this.myServer.getId()) && this.myServer.getId().equals(server.getId());
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String validateSlow(long timeout) throws TimeoutException {
        return this.myServer.validateSlow(timeout);
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String validateInternalSlow(long timeout, boolean checkRootFolder) throws TimeoutException {
        return this.myServer.getFileTransferConfig().validateSlow(timeout, checkRootFolder);
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String validateFastInternal() {
        return this.myServer.getFileTransferConfig().validateFast();
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String validateFastInternal(boolean checkRootFolder) {
        return this.myServer.getFileTransferConfig().validateFast(checkRootFolder);
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String validateFast() {
        return this.myServer.validateFast();
    }

    @Override
    @Nullable
    public String getId() {
        return this.myServer.getId();
    }

    @Override
    public String getPresentablePath(FileName name) {
        return this.myServer.getPresentablePath(name);
    }

    @Override
    public String getPresentablePath(WebServerConfig.RemotePath path) {
        return this.myServer.getPresentablePath(path);
    }

    @Override
    public String getFullPath(String deployPath) {
        return this.myServer.getFullPath(deployPath);
    }

    @Override
    @Nullable
    public String validateUrl() {
        return this.myServer.validateUrl();
    }

    @Override
    @NlsSafe
    public String getUrl() {
        return this.myServer.getUrl();
    }

    @Override
    public WebServerConfig.RemotePath getRootPath() {
        return this.myServer.getRootPath();
    }

    @Override
    public boolean isAnonymous() {
        return this.myServer.getFileTransferConfig().isAnonymous();
    }

    @Override
    @Nullable
    public String getMountedFolder() {
        return this.myServer.getFileTransferConfig().getMountedFolder();
    }

    @Override
    @NotNull
    public WebServerConfig computeWebServerConfig() {
        WebServerConfig webServerConfig = this.myServer;
        if (webServerConfig == null) {
            ServerBaseDeployable.$$$reportNull$$$0(10);
        }
        return webServerConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerBaseDeployable that = (ServerBaseDeployable)o;
        return this.myServer.equals(that.myServer);
    }

    public int hashCode() {
        return this.myServer.hashCode();
    }

    @NonNls
    public String toString() {
        return "ServerBaseDeployable{myServer=" + this.myServer + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWebServerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

