/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepCancelledException;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.AddServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.BaseStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseRemotePathStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseWebPathStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import com.jetbrains.plugins.webDeployment.actions.createproject.FileChooserStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.PublishOptionsStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.SpecifyLocalPathStep;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseServerStep
extends BaseStep {
    private static final Logger LOG = Logger.getInstance(ChooseServerStep.class);
    public static final Object ID = ChooseServerStep.class;
    private JRadioButton myUseExistingServerRB;
    private JRadioButton myAddNewServerRB;
    private TableView<WebServerConfig> myServersTable;
    private JPanel myContentPane;
    private JCheckBox myDontCheckHttpCheckBox;
    private JLabel myMessageLabel;
    private final Set<CreateProjectModel.Scenario> myWasEverShownFor;
    private int myLastSelected;
    private static final ColumnInfo NAME_COLUMN = new ColumnInfo<WebServerConfig, String>(WDBundle.message("create.web.project.server.table.name.column", new Object[0])){
        private final Comparator<WebServerConfig> COMPARATOR = ChooseServerStep.createComparator(this);

        public String valueOf(WebServerConfig item) {
            return item.getName();
        }

        public TableCellRenderer getRenderer(final WebServerConfig item) {
            return new DefaultTableCellRenderer(){

                @Override
                public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    Icon icon = item.getIcon();
                    if (item.validateFast() != null) {
                        icon = new LayeredIcon(new Icon[]{icon, AllIcons.General.WarningDecorator});
                    }
                    label.setIcon(icon);
                    label.setDisabledIcon(icon);
                    return label;
                }
            };
        }

        @Nullable
        public Comparator<WebServerConfig> getComparator() {
            return this.COMPARATOR;
        }
    };
    private static final ColumnInfo HOST_COLUMN = new ColumnInfo<WebServerConfig, String>(WDBundle.message("create.web.project.server.table.host.column", new Object[0])){
        private final Comparator<WebServerConfig> COMPARATOR = ChooseServerStep.createComparator(this);

        public String valueOf(WebServerConfig item) {
            return item.getFileTransferConfig().getDisplayName();
        }

        public TableCellRenderer getRenderer(WebServerConfig webServerConfig) {
            return new DefaultTableCellRenderer();
        }

        @Nullable
        public Comparator<WebServerConfig> getComparator() {
            return this.COMPARATOR;
        }
    };
    private static final ColumnInfo URL_COLUMN = new ColumnInfo<WebServerConfig, String>(WDBundle.message("create.web.project.server.table.url.column", new Object[0])){
        private final Comparator<WebServerConfig> COMPARATOR = ChooseServerStep.createComparator(this);

        public String valueOf(WebServerConfig item) {
            return item.getUrl();
        }

        public TableCellRenderer getRenderer(WebServerConfig webServerConfig) {
            return new DefaultTableCellRenderer();
        }

        @Nullable
        public Comparator<WebServerConfig> getComparator() {
            return this.COMPARATOR;
        }
    };
    private static final ColumnInfo MOUNTED_FOLDER_COLUMN = new ColumnInfo<WebServerConfig, String>(WDBundle.message("create.web.project.server.table.mounted.folder.column", new Object[0])){
        private final Comparator<WebServerConfig> COMPARATOR = ChooseServerStep.createComparator(this);

        public String valueOf(WebServerConfig item) {
            return item.getFileTransferConfig().getMountedFolder();
        }

        public TableCellRenderer getRenderer(WebServerConfig webServerConfig) {
            return new DefaultTableCellRenderer();
        }

        @Nullable
        public Comparator<WebServerConfig> getComparator() {
            return this.COMPARATOR;
        }
    };

    private static Comparator<WebServerConfig> createComparator(ColumnInfo<WebServerConfig, String> info) {
        return (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return StringUtil.compare((String)((String)info.valueOf(o1)), (String)((String)info.valueOf(o2)), (boolean)true);
        };
    }

    public ChooseServerStep(CreateProjectModel model) {
        super(ChooseServerStep.getTitle(model.scenario), model);
        this.$$$setupUI$$$();
        this.myWasEverShownFor = EnumSet.noneOf(CreateProjectModel.Scenario.class);
        this.myServersTable.setSelectionMode(0);
        this.myServersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChooseServerStep.this.fireStateChanged();
                ChooseServerStep.this.updateMessage();
            }
        });
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseServerStep.this.updateUi();
                ChooseServerStep.this.fireStateChanged();
            }
        };
        this.myUseExistingServerRB.addActionListener(l);
        this.myAddNewServerRB.addActionListener(l);
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
    }

    private static String getTitle(CreateProjectModel.Scenario scenario) {
        return WDBundle.message(scenario == CreateProjectModel.Scenario.LocalServer ? "create.web.project.choose.local.server.step.title" : "create.web.project.choose.remote.server.step.title", new Object[0]);
    }

    private void updateUi() {
        if (this.myUseExistingServerRB.isSelected()) {
            if (this.myLastSelected != -1) {
                this.myServersTable.getSelectionModel().setSelectionInterval(this.myLastSelected, this.myLastSelected);
            }
        } else {
            this.myLastSelected = this.myServersTable.getSelectedRow();
            this.myServersTable.getSelectionModel().clearSelection();
        }
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            ChooseServerStep.$$$reportNull$$$0(0);
        }
        return object;
    }

    public Object getNextStepId() {
        if (this.myUseExistingServerRB.isSelected()) {
            return this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? ChooseWebPathStep.ID : ChooseRemotePathStep.ID;
        }
        return AddServerStep.ID;
    }

    public Object getPreviousStepId() {
        if (this.myModel.scenario == CreateProjectModel.Scenario.LocalServer) {
            return FileChooserStep.ID_LOCAL_SERVER;
        }
        return this.myModel.isDefaultConfigUsed() ? SpecifyLocalPathStep.ID : PublishOptionsStep.ID;
    }

    public boolean isComplete() {
        if (this.myModel.scenario == CreateProjectModel.Scenario.NoServer) {
            return true;
        }
        if (!this.myWasEverShownFor.contains((Object)this.myModel.scenario)) {
            return true;
        }
        if (this.myAddNewServerRB.isSelected()) {
            return true;
        }
        return this.validate() == null && this.myServersTable.getSelectedRowCount() > 0;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    protected String validate() {
        File path;
        File mountedFolder;
        if (this.myModel.scenario == CreateProjectModel.Scenario.MountedServer && this.myUseExistingServerRB.isSelected() && this.myServersTable.getSelectedObject() != null && VfsUtilCore.isAncestor((File)(mountedFolder = new File(((WebServerConfig)this.myServersTable.getSelectedObject()).getFileTransferConfig().getMountedFolder())), (File)(path = new File(this.myModel.localPath)), (boolean)false)) {
            return WDBundle.message("path.is.under.mounted.folder", mountedFolder);
        }
        return null;
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        if (commitType == AbstractWizardStepEx.CommitType.Prev) {
            return;
        }
        if (this.myUseExistingServerRB.isSelected()) {
            WebServerConfig server = (WebServerConfig)this.myServersTable.getSelectedObject();
            ChooseServerStep.checkConnection(Deployable.create(server, null), this.myContentPane, !this.myDontCheckHttpCheckBox.isSelected());
            this.myModel.setServer(server);
        }
    }

    public static void checkConnection(Deployable server, JComponent parentComponent, boolean checkHttp) throws CommitStepException {
        String error = server.validateFast();
        if (error != null) {
            throw new CommitStepException(WDBundle.message("server.invalid", server.getName(), error));
        }
        if (server.needsTransfer() && !AuthHelper.ensureAuthSpecified(null, server, parentComponent)) {
            throw new CommitStepCancelledException();
        }
        try {
            String title = WDBundle.message("checking.connection", server.getName());
            PublishUtils.testConnection(server, parentComponent, title, checkHttp);
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            PublishUtils.showLoginDialogAfterAuthFail(e, server);
            throw new CommitStepException(WDBundle.message("connection.to.failed", server.getName(), PublishUtils.getMessage(e, false)));
        }
        catch (ProcessCanceledException e) {
            throw new CommitStepCancelledException();
        }
    }

    @Override
    public JComponent getInnerComponent() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUseExistingServerRB.isSelected() ? this.myServersTable : this.myAddNewServerRB;
    }

    @Override
    public void doInit() {
        int select;
        this.setTitle(ChooseServerStep.getTitle(this.myModel.scenario));
        this.myAddNewServerRB.setText(WDBundle.message(this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? "create.web.project.add.local.server.rb.text" : "create.web.project.add.remote.server.rb.text", new Object[0]));
        this.myWasEverShownFor.add(this.myModel.scenario);
        List<WebServerConfig> servers = this.myModel.getServersForCurrentScenario();
        ColumnInfo[] columns = this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? new ColumnInfo[]{NAME_COLUMN, URL_COLUMN} : (this.myModel.scenario == CreateProjectModel.Scenario.FtpSftpServer ? new ColumnInfo[]{NAME_COLUMN, HOST_COLUMN, URL_COLUMN} : new ColumnInfo[]{NAME_COLUMN, MOUNTED_FOLDER_COLUMN, URL_COLUMN});
        this.myServersTable.setModelAndUpdateColumns(new ListTableModel(columns, servers, 0));
        int n = select = this.myModel.getServer() != null ? servers.indexOf(this.myModel.getServer()) : -1;
        if (select == -1 && !servers.isEmpty()) {
            select = 0;
        }
        this.myUseExistingServerRB.setSelected(true);
        if (select != -1) {
            this.myServersTable.getSelectionModel().setSelectionInterval(select, select);
        }
        this.myLastSelected = -1;
        this.updateUi();
    }

    public String getHelpId() {
        return this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? "reference.dialogs.new.project.from.existing.files.specify.local.server" : "reference.dialogs.new.project.from.existing.files.specify.remote.server";
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected String getSummaryText() {
        String string = WDBundle.message(this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? "create.web.project.choose.local.server.step.summary" : "create.web.project.choose.remote.server.step.summary", new Object[0]);
        if (string == null) {
            ChooseServerStep.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void updateMessage() {
        String errorMessage = this.validate();
        this.myMessageLabel.setText(errorMessage);
        this.myMessageLabel.setVisible(errorMessage != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/ChooseServerStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummaryText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        TableView tableView;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseExistingServerRB = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/WDBundle", ChooseServerStep.class).getString("choose.server.step.use.existing.server"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myServersTable = tableView = new TableView();
        jBScrollPane.setViewportView((Component)tableView);
        this.myAddNewServerRB = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/WDBundle", ChooseServerStep.class).getString("choose.server.step.add.new.remote.server"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDontCheckHttpCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/WDBundle", ChooseServerStep.class).getString("do.not.check.http"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("---");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

