/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.DeploymentCache;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LoadFilesAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(LoadFilesAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadFilesAction.$$$reportNull$$$0(0);
        }
        boolean invokedAtRemoteBrowser = e.getData(WebDeploymentDataKeys.SERVER_TREE) != null;
        Collection<WebServerGroupingWrap> wraps = LoadFilesAction.getExtraWraps(e, invokedAtRemoteBrowser, this.isChooseServer(), this.isHandleVcsChanges());
        if (!this.isChooseServer()) {
            if (invokedAtRemoteBrowser) {
                e.getPresentation().setText(this.getLoadHereMessage());
            } else if (!wraps.isEmpty()) {
                e.getPresentation().setText(this.getLoadToServerMessage(wraps.iterator().next()));
            }
        }
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(!wraps.isEmpty());
        } else {
            e.getPresentation().setEnabled(!wraps.isEmpty());
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected abstract Supplier<String> getLoadHereMessage();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected abstract Supplier<String> getLoadToServerMessage(WebServerGroupingWrap var1);

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected abstract String getServerChooserTitle();

    @NotNull
    static Collection<WebServerGroupingWrap> getExtraWraps(AnActionEvent e, boolean invokedAtRemoteBrowser, boolean chooseServer, boolean handleVcsChanges) {
        Collection<Object> wraps;
        if (chooseServer && invokedAtRemoteBrowser) {
            wraps = Collections.emptyList();
        } else {
            Project project;
            wraps = LoadFilesAction.isEnabled(e, chooseServer, handleVcsChanges);
            if (chooseServer && wraps.size() == 1 && ActionPlaces.isPopupPlace((String)e.getPlace()) && ((WebServerGroupingWrap)wraps.iterator().next()).isSingleServer() && ((project = e.getProject()) == null || PublishConfig.getInstance(project).getDefaultServerOrGroupName() != null && StringUtil.equals((CharSequence)((WebServerGroupingWrap)wraps.iterator().next()).getName(), (CharSequence)PublishConfig.getInstance(project).getDefaultServerOrGroupName()))) {
                wraps = Collections.emptyList();
            }
        }
        List<WebServerGroupingWrap> list = wraps;
        if (list == null) {
            LoadFilesAction.$$$reportNull$$$0(1);
        }
        return list;
    }

    protected boolean isChooseServer() {
        return false;
    }

    protected boolean isHandleVcsChanges() {
        return true;
    }

    @NotNull
    private static Collection<WebServerGroupingWrap> isEnabled(AnActionEvent e, boolean chooseServer, boolean handleVcsChanged) {
        Change[] changes;
        if ("RemoteHostDialogPopup".equals(e.getPlace())) {
            List<WebServerGroupingWrap> list = Collections.emptyList();
            if (list == null) {
                LoadFilesAction.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = e.getProject();
        if (project == null || project.isDisposed() || project.isDefault()) {
            List<WebServerGroupingWrap> list = Collections.emptyList();
            if (list == null) {
                LoadFilesAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        if (handleVcsChanged && (changes = (Change[])e.getData(VcsDataKeys.CHANGES)) != null) {
            return LoadFilesAction.findSuitableWraps(project, publishConfig, changes, chooseServer);
        }
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files != null) {
            return LoadFilesAction.findSuitableWraps(project, publishConfig, files, chooseServer);
        }
        FileObject[] nodes = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (nodes != null) {
            Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
            LOG.assertTrue(server != null);
            if (server.validateFastInternal() != null) {
                List<WebServerGroupingWrap> list = Collections.emptyList();
                if (list == null) {
                    LoadFilesAction.$$$reportNull$$$0(4);
                }
                return list;
            }
            for (FileObject node : nodes) {
                if (publishConfig.getNearestMappingDeploy2Local(node, false, (Mappable)server).getFirst() == null && ((List)publishConfig.getChildMappingsDeploy2Local(node, (Mappable)server).getFirst()).isEmpty()) continue;
                List<WebServerGroupingWrap> list = Collections.singletonList(WebServerGroupingWrap.wrap(server.computeWebServerConfig()));
                if (list == null) {
                    LoadFilesAction.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<WebServerGroupingWrap> list = Collections.emptyList();
        if (list == null) {
            LoadFilesAction.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static Collection<WebServerGroupingWrap> findWraps(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Condition<WebServerConfig> include, boolean chooseServer) {
        WebServerGroupingWrap wrap;
        if (project == null) {
            LoadFilesAction.$$$reportNull$$$0(7);
        }
        if (publishConfig == null) {
            LoadFilesAction.$$$reportNull$$$0(8);
        }
        if (include == null) {
            LoadFilesAction.$$$reportNull$$$0(9);
        }
        List<Object> wraps = chooseServer ? GroupedServersConfigManager.getInstance(project).getGroupedServers() : ((wrap = publishConfig.findDefaultServerOrGroupAsWrap()) == null ? Collections.emptyList() : Collections.singletonList(wrap));
        ArrayList<WebServerGroupingWrap> result = new ArrayList<WebServerGroupingWrap>();
        block0: for (WebServerGroupingWrap wrap2 : wraps) {
            for (WebServerConfig server : wrap2.getServers()) {
                if (!server.needsTransfer() || server.getFileTransferConfig().validateFast() != null || !include.value((Object)server)) continue;
                result.add(wrap2);
                continue block0;
            }
        }
        ArrayList<WebServerGroupingWrap> arrayList = result;
        if (arrayList == null) {
            LoadFilesAction.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    static Collection<WebServerGroupingWrap> findSuitableWraps(@NotNull Project project, @NotNull PublishConfig publishConfig, VirtualFile @NotNull [] roots, boolean chooseServer) {
        DeploymentCache deploymentCache;
        Collection<WebServerGroupingWrap> wraps;
        if (project == null) {
            LoadFilesAction.$$$reportNull$$$0(11);
        }
        if (publishConfig == null) {
            LoadFilesAction.$$$reportNull$$$0(12);
        }
        if (roots == null) {
            LoadFilesAction.$$$reportNull$$$0(13);
        }
        if ((wraps = (deploymentCache = DeploymentCache.getInstance(project)).getSuitableWrapsForFiles(publishConfig, chooseServer, roots)) != null) {
            Collection<WebServerGroupingWrap> collection = wraps;
            if (collection == null) {
                LoadFilesAction.$$$reportNull$$$0(14);
            }
            return collection;
        }
        wraps = LoadFilesAction.findWraps(project, publishConfig, (Condition<WebServerConfig>)((Condition)server -> LoadFilesAction.checkServer(publishConfig, server, roots)), chooseServer);
        deploymentCache.setSuitableWrapsForFiles(publishConfig, chooseServer, roots, wraps);
        Collection<WebServerGroupingWrap> collection = wraps;
        if (collection == null) {
            LoadFilesAction.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    private static Collection<WebServerGroupingWrap> findSuitableWraps(@NotNull Project project, @NotNull PublishConfig publishConfig, Change @NotNull [] changes, boolean chooseServer) {
        DeploymentCache deploymentCache;
        Collection<WebServerGroupingWrap> servers;
        if (project == null) {
            LoadFilesAction.$$$reportNull$$$0(16);
        }
        if (publishConfig == null) {
            LoadFilesAction.$$$reportNull$$$0(17);
        }
        if (changes == null) {
            LoadFilesAction.$$$reportNull$$$0(18);
        }
        if ((servers = (deploymentCache = DeploymentCache.getInstance(project)).getSuitableWrapsForChanges(publishConfig, chooseServer, changes)) != null) {
            Collection<WebServerGroupingWrap> collection = servers;
            if (collection == null) {
                LoadFilesAction.$$$reportNull$$$0(19);
            }
            return collection;
        }
        servers = LoadFilesAction.findWraps(project, publishConfig, (Condition<WebServerConfig>)((Condition)server -> LoadFilesAction.checkServer(publishConfig, server, changes)), chooseServer);
        deploymentCache.setSuitableWrapsForChanges(publishConfig, chooseServer, changes, servers);
        Collection<WebServerGroupingWrap> collection = servers;
        if (collection == null) {
            LoadFilesAction.$$$reportNull$$$0(20);
        }
        return collection;
    }

    private static boolean checkServer(PublishConfig publishConfig, WebServerConfig server, Change[] changes) {
        for (Change change : changes) {
            ContentRevision afterRevision;
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (!(beforeRevision != null ? publishConfig.getNearestMappingForLocal(beforeRevision.getFile().getPath(), false, true, false, (Mappable)server).getFirst() != null : (afterRevision = change.getAfterRevision()) != null && publishConfig.getNearestMappingForLocal(afterRevision.getFile().getPath(), false, true, false, (Mappable)server).getFirst() != null)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkServer(PublishConfig publishConfig, WebServerConfig server, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            if (!PublishActionUtil.checkMapping(publishConfig, server, root.getPath(), true)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Collection<WebServerGroupingWrap> servers;
        Project project;
        if (e == null) {
            LoadFilesAction.$$$reportNull$$$0(21);
        }
        LOG.assertTrue((project = e.getProject()) != null);
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        FileObject[] remoteFiles = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        VfsUtilCore.DistinctVFilesRootsCollection roots = files != null ? new VfsUtilCore.DistinctVFilesRootsCollection(files) : null;
        RemoteConnection connection = (RemoteConnection)e.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        if (changes != null) {
            servers = LoadFilesAction.findSuitableWraps(project, publishConfig, changes, this.isChooseServer());
        } else if (files != null) {
            servers = LoadFilesAction.findSuitableWraps(project, publishConfig, files, this.isChooseServer());
        } else {
            Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
            if (server == null) {
                return;
            }
            servers = Collections.singletonList(WebServerGroupingWrap.wrap(server.computeWebServerConfig()));
        }
        LOG.assertTrue(!servers.isEmpty());
        if (servers.size() == 1 && !this.isChooseServer()) {
            this.execute(project, publishConfig, servers.iterator().next(), changes, changeLists, remoteFiles, connection, (Collection<VirtualFile>)roots);
        } else {
            PublishActionUtil.chooseServerFromWraps(publishConfig, servers, e, this.getServerChooserTitle(), true).onSuccess(arg_0 -> this.lambda$actionPerformed$2(project, publishConfig, changes, changeLists, remoteFiles, connection, (Collection)roots, arg_0));
        }
    }

    protected void execute(@NotNull Project project, PublishConfig publishConfig, @NotNull WebServerGroupingWrap wrap, Change[] changes, ChangeList[] changeLists, FileObject[] remoteFiles, @Nullable RemoteConnection connection, Collection<VirtualFile> roots) {
        if (project == null) {
            LoadFilesAction.$$$reportNull$$$0(22);
        }
        if (wrap == null) {
            LoadFilesAction.$$$reportNull$$$0(23);
        }
        Condition condition = changes != null ? server -> LoadFilesAction.checkServer(publishConfig, server, changes) : (roots != null ? server -> LoadFilesAction.checkServer(publishConfig, server, roots.toArray(VirtualFile.EMPTY_ARRAY)) : serverConfig -> true);
        for (WebServerConfig server2 : wrap.getServers()) {
            if (!server2.needsTransfer()) continue;
            String validationError = server2.getFileTransferConfig().validateFast();
            if (validationError != null) {
                FileTransferToolWindow.printWithTimestamp(project, server2, WDBundle.message("server.is.not.configured.properly.0", validationError), ConsoleViewContentType.ERROR_OUTPUT, publishConfig.getTraceLevel());
                continue;
            }
            if (!condition.value((Object)server2)) {
                FileTransferToolWindow.printWithTimestamp(project, server2, WDBundle.message("server.is.ignored.no.related.mappings.found", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT, publishConfig.getTraceLevel());
                continue;
            }
            this.execute(project, publishConfig, Deployable.create(server2, project), changes, changeLists, remoteFiles, connection, roots);
        }
    }

    protected abstract void execute(@NotNull Project var1, PublishConfig var2, @NotNull Deployable var3, Change[] var4, ChangeList[] var5, FileObject[] var6, @Nullable RemoteConnection var7, Collection<VirtualFile> var8);

    private /* synthetic */ void lambda$actionPerformed$2(Project project, PublishConfig publishConfig, Change[] changes, ChangeList[] changeLists, FileObject[] remoteFiles, RemoteConnection connection, Collection roots, WebServerGroupingWrap server) {
        this.execute(project, publishConfig, server, changes, changeLists, remoteFiles, connection, (Collection<VirtualFile>)roots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraWraps";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "isEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findWraps";
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuitableWraps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findWraps";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableWraps";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

