/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentDragAndDrop;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Settings;
import org.fest.swing.driver.ComponentEnabledCondition;
import org.fest.swing.driver.ComponentPerformDefaultAccessibleActionTask;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentEnabledQuery;
import org.fest.swing.query.ComponentHasFocusQuery;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.query.ComponentVisibleQuery;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class ComponentDriver<T extends Component> {
    private static final String ENABLED_PROPERTY = "enabled";
    private static final String SIZE_PROPERTY = "size";
    private static final String VISIBLE_PROPERTY = "visible";
    protected final Robot robot;
    private final ComponentDragAndDrop dragAndDrop;

    public ComponentDriver(@Nonnull Robot robot) {
        this.robot = robot;
        this.dragAndDrop = new ComponentDragAndDrop(robot);
    }

    @RunsInEDT
    public void click(@Nonnull T c) {
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.click((Component)c);
    }

    @RunsInEDT
    public void click(@Nonnull T c, @Nonnull MouseButton button) {
        this.click(c, button, 1);
    }

    @RunsInEDT
    public void click(@Nonnull T c, @Nonnull MouseClickInfo mouseClickInfo) {
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.click(c, mouseClickInfo.button(), mouseClickInfo.times());
    }

    @RunsInEDT
    public void doubleClick(@Nonnull T c) {
        this.click(c, MouseButton.LEFT_BUTTON, 2);
    }

    @RunsInEDT
    public void rightClick(@Nonnull T c) {
        this.click(c, MouseButton.RIGHT_BUTTON);
    }

    @RunsInEDT
    public void click(@Nonnull T c, @Nonnull MouseButton button, int times) {
        Preconditions.checkNotNull((Object)((Object)button));
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.click((Component)c, button, times);
    }

    @RunsInEDT
    public void click(@Nonnull T c, @Nonnull Point where) {
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.click((Component)c, where);
    }

    @Nonnull
    protected Settings settings() {
        return this.robot.settings();
    }

    @RunsInEDT
    public void requireSize(@Nonnull T c, @Nonnull Dimension size) {
        ((ObjectAssert)Assertions.assertThat((Object)ComponentSizeQuery.sizeOf(c)).as(ComponentDriver.propertyName(c, SIZE_PROPERTY))).isEqualTo((Object)size);
    }

    @RunsInEDT
    public void requireVisible(@Nonnull T c) {
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentVisibleQuery.isVisible(c)).as(ComponentDriver.visibleProperty(c))).isTrue();
    }

    @RunsInEDT
    public void requireNotVisible(@Nonnull T c) {
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentVisibleQuery.isVisible(c)).as(ComponentDriver.visibleProperty(c))).isFalse();
    }

    @Nonnull
    @RunsInEDT
    private static Description visibleProperty(@Nonnull Component c) {
        return ComponentDriver.propertyName(c, VISIBLE_PROPERTY);
    }

    @RunsInEDT
    public void requireFocused(@Nonnull T c) {
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentHasFocusQuery.hasFocus(c)).as(ComponentDriver.requiredFocusedErrorMessage(c))).isTrue();
    }

    @Nonnull
    private static Description requiredFocusedErrorMessage(final Component c) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return String.format("Expected component %s to have input focus", Formatting.format(c));
            }
        };
    }

    @RunsInEDT
    public void requireEnabled(@Nonnull T c) {
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentEnabledQuery.isEnabled(c)).as(ComponentDriver.enabledProperty(c))).isTrue();
    }

    @RunsInEDT
    public void requireEnabled(@Nonnull T c, @Nonnull Timeout timeout) {
        Pause.pause((Condition)ComponentEnabledCondition.untilIsEnabled(c), timeout);
    }

    @RunsInEDT
    public void requireDisabled(@Nonnull T c) {
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentEnabledQuery.isEnabled(c)).as(ComponentDriver.enabledProperty(c))).isFalse();
    }

    @Nonnull
    @RunsInEDT
    private static Description enabledProperty(@Nonnull Component c) {
        return ComponentDriver.propertyName(c, ENABLED_PROPERTY);
    }

    @RunsInEDT
    public void pressAndReleaseKeys(@Nonnull T c, int ... keyCodes) {
        Preconditions.checkNotNull((Object)keyCodes);
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.focusAndWaitForFocusGain((Component)c);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    @RunsInEDT
    public void pressAndReleaseKey(@Nonnull T c, @Nonnull KeyPressInfo keyPressInfo) {
        Preconditions.checkNotNull((Object)keyPressInfo);
        this.pressAndReleaseKey(c, keyPressInfo.keyCode(), keyPressInfo.modifiers());
    }

    @RunsInEDT
    public void pressAndReleaseKey(@Nonnull T c, int keyCode, @Nonnull int[] modifiers) {
        this.focusAndWaitForFocusGain((Component)c);
        this.robot.pressAndReleaseKey(keyCode, modifiers);
    }

    @RunsInEDT
    public void pressKey(@Nonnull T c, int keyCode) {
        this.focusAndWaitForFocusGain((Component)c);
        this.robot.pressKey(keyCode);
    }

    @RunsInEDT
    public void releaseKey(@Nonnull T c, int keyCode) {
        this.focusAndWaitForFocusGain((Component)c);
        this.robot.releaseKey(keyCode);
    }

    @RunsInEDT
    public void focusAndWaitForFocusGain(@Nonnull Component c) {
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.focusAndWaitForFocusGain(c);
    }

    @RunsInEDT
    public void focus(@Nonnull Component c) {
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.focus(c);
    }

    @RunsInEDT
    protected final void drag(@Nonnull T c, @Nonnull Point where) {
        this.dragAndDrop.drag((Component)c, where);
    }

    @RunsInEDT
    protected final void drop(@Nonnull T c, @Nonnull Point where) {
        this.dragAndDrop.drop((Component)c, where);
    }

    protected final void dragOver(@Nonnull T c, @Nonnull Point where) {
        this.dragAndDrop.dragOver((Component)c, where);
    }

    @RunsInCurrentThread
    protected final void performAccessibleActionOf(@Nonnull T c) {
        ComponentPerformDefaultAccessibleActionTask.performDefaultAccessibleAction(c);
        this.robot.waitForIdle();
    }

    @RunsInCurrentThread
    protected final boolean waitForShowing(@Nonnull T c, long timeout) {
        if (this.robot.isReadyForInput((Component)c)) {
            return true;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.robot.isReadyForInput((Component)c)) {
            Component invoker;
            if (c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) instanceof JMenu) {
                this.robot.jitter(invoker);
            }
            if (watch.isTimeOut()) {
                return false;
            }
            Pause.pause();
        }
        return true;
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu invokePopupMenu(@Nonnull T c) {
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        return this.robot.showPopupMenu((Component)c);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu invokePopupMenu(@Nonnull T c, @Nonnull Point p) {
        Preconditions.checkNotNull((Object)p);
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        return this.robot.showPopupMenu((Component)c, p);
    }

    @RunsInEDT
    protected static void checkInEdtEnabledAndShowing(final @Nonnull Component c) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(c);
            }
        });
    }

    @Nonnull
    @RunsInEDT
    public static Description propertyName(final @Nonnull Component c, final @Nonnull String propertyName) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return String.format("%s - property:'%s'", Formatting.format(c), propertyName);
            }
        };
    }

    @RunsInEDT
    protected final void moveMouseIgnoringAnyError(@Nonnull T c, @Nonnull Point p) {
        this.moveMouseIgnoringAnyError(c, p.x, p.y);
    }

    @RunsInEDT
    protected final void moveMouseIgnoringAnyError(@Nonnull T c, int x, int y) {
        try {
            this.robot.moveMouse((Component)c, x, y);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nonnull
    @RunsInEDT
    public Font fontOf(final @Nonnull T c) {
        Font result = GuiActionRunner.execute(new GuiQuery<Font>(){

            @Override
            @Nullable
            protected Font executeInEDT() {
                return c.getFont();
            }
        });
        return (Font)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInEDT
    public Color backgroundOf(final @Nonnull T c) {
        Color result = GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            @Nullable
            protected Color executeInEDT() {
                return c.getBackground();
            }
        });
        return (Color)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInEDT
    public Color foregroundOf(final @Nonnull T c) {
        Color result = GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            @Nullable
            protected Color executeInEDT() {
                return c.getForeground();
            }
        });
        return (Color)Preconditions.checkNotNull((Object)result);
    }
}

