/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.annotation.Nonnull;
import org.fest.swing.core.FocusOwnerFinder;

final class FocusMonitor
implements FocusListener {
    private volatile boolean hasFocus;

    @Nonnull
    static FocusMonitor attachTo(@Nonnull Component c) {
        FocusMonitor monitor = new FocusMonitor(c);
        c.addFocusListener(monitor);
        return monitor;
    }

    private FocusMonitor(Component c) {
        this.hasFocus = FocusOwnerFinder.focusOwner() == c;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
    }

    boolean hasFocus() {
        return this.hasFocus;
    }
}

